/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.JspUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class JspUtilsTest {
    @Test
    public void testMapToXMLAttributes() throws Exception {
        HashMap emptyMap = Maps.newHashMap();
        LinkedHashMap nonEmptyMap = Maps.newLinkedHashMap();
        LinkedHashMap mapWithUnsafeValues = Maps.newLinkedHashMap();
        nonEmptyMap.put("data-state", "stale");
        nonEmptyMap.put("id", "verified-element-101");
        mapWithUnsafeValues.put("data-state", "<script>alert(1);</script>");
        mapWithUnsafeValues.put("id", "\">");
        MatcherAssert.assertThat((Object)JspUtils.mapToXMLAttributes((Map)emptyMap), (Matcher)Matchers.equalTo((Object)""));
        String expected = "data-state=\"stale\" id=\"verified-element-101\"";
        MatcherAssert.assertThat((Object)JspUtils.mapToXMLAttributes((Map)nonEmptyMap), (Matcher)Matchers.equalTo((Object)expected));
        expected = "data-state=\"&lt;script&gt;alert(1);&lt;/script&gt;\" id=\"&#034;&gt;\"";
        MatcherAssert.assertThat((Object)JspUtils.mapToXMLAttributes((Map)mapWithUnsafeValues), (Matcher)Matchers.equalTo((Object)expected));
    }

    @Test
    public void testStripEmailFromCommitter() throws Exception {
        MatcherAssert.assertThat((Object)JspUtils.stripEmailFromCommitter((String)"Liang <lzheng@atlassian.com>"), (Matcher)Matchers.equalTo((Object)"Liang"));
        String committer = "Liang <some random string>";
        MatcherAssert.assertThat((Object)JspUtils.stripEmailFromCommitter((String)committer), (Matcher)Matchers.equalTo((Object)committer));
        committer = "Liang <some_random_string>";
        MatcherAssert.assertThat((Object)JspUtils.stripEmailFromCommitter((String)committer), (Matcher)Matchers.equalTo((Object)committer));
        committer = "Liang";
        MatcherAssert.assertThat((Object)JspUtils.stripEmailFromCommitter((String)committer), (Matcher)Matchers.equalTo((Object)committer));
        MatcherAssert.assertThat((Object)JspUtils.stripEmailFromCommitter(null), (Matcher)Matchers.equalTo((Object)""));
    }
}

