/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.HibernateWatchDAO;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.Date;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class HibernateWatchDAOTest {
    @Autowired
    private HibernateWatchDAO watchDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private final Random rnd = new Random();

    @Test
    public void testApplicationContextSetUp() throws Exception {
        MatcherAssert.assertThat((Object)this.watchDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.userDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.sessionFactory, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testAdd() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch = this.generateWatch(user);
        MatcherAssert.assertThat((Object)watch.getId(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)0));
        this.watchDAO.add(watch);
        MatcherAssert.assertThat((Object)watch.getId(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testAddReadAndCompare() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch = this.generateWatch(user);
        MatcherAssert.assertThat((Object)watch.getId(), (Matcher)Matchers.nullValue());
        this.watchDAO.add(watch);
        MatcherAssert.assertThat((Object)watch.getId(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        Watch reReadWatch = this.watchDAO.load(watch.getId());
        this.assertSameWatch(watch, reReadWatch);
    }

    @Test(expected=Exception.class)
    public void testAddWatchForNonExistingUser() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        Watch watch = this.generateWatch(user);
        this.watchDAO.add(watch);
        this.sessionFactory.getCurrentSession().flush();
        Assert.fail((String)"added watch for non-existing user");
    }

    @Test
    public void testDelete() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch1 = this.generateWatch(user);
        Watch watch2 = this.generateWatch(user);
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)0));
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.sessionFactory.getCurrentSession().flush();
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)2));
        this.watchDAO.delete(watch1.getId());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)1));
        this.watchDAO.delete(watch2.getId());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testDeleteOneFromMany() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch1 = this.generateWatch(user);
        Watch watch2 = this.generateWatch(user);
        Watch watch3 = this.generateWatch(user);
        Watch watch4 = this.generateWatch(user);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.sessionFactory.getCurrentSession().flush();
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch1, watch2, watch3, watch4}));
        this.watchDAO.delete(watch1.getId());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch2, watch3, watch4}));
        this.watchDAO.delete(watch2.getId());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch3, watch4}));
        this.watchDAO.delete(watch3.getId());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch4}));
        this.watchDAO.delete(watch4.getId());
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)0));
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        MatcherAssert.assertThat((Object)this.userDAO.getByUsername(user.getUsername()), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testGetWatchesForRep() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        String rep1 = this.generateRepName();
        String rep2 = this.generateRepName();
        Watch watch1 = this.generateWatch(user1);
        watch1.setRep(rep1);
        Watch watch2 = this.generateWatch(user2);
        watch2.setRep(rep2);
        Watch watch3 = this.generateWatch(user1);
        watch3.setRep(rep1);
        Watch watch4 = this.generateWatch(user2);
        watch4.setRep(rep2);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchesForRep(rep1), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch1, watch3}));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchesForRep(rep2), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch2, watch4}));
    }

    @Test
    public void testGetWatchesForUser() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        Watch watch1 = this.generateWatch(user1);
        Watch watch2 = this.generateWatch(user2);
        Watch watch3 = this.generateWatch(user1);
        Watch watch4 = this.generateWatch(user2);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchesForUser(user1), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch1, watch3}));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchesForUser(user2), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch2, watch4}));
    }

    @Test
    public void testGetWatchesForUserRepPath() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        String rep1 = this.generateRepName();
        String rep2 = this.generateRepName();
        String path1 = this.generatePath();
        String path2 = this.generatePath();
        Watch watch1 = this.generateWatch(user1);
        watch1.setRep(rep1);
        watch1.setPathAsString(path1);
        watch1.setConstraint(null);
        Watch watch2 = this.generateWatch(user1);
        watch2.setRep(rep1);
        watch2.setPathAsString(path2);
        watch2.setConstraint(null);
        Watch watch3 = this.generateWatch(user1);
        watch3.setRep(rep2);
        watch3.setPathAsString(path2);
        watch3.setConstraint(null);
        Watch watch4 = this.generateWatch(user2);
        watch4.setRep(rep1);
        watch4.setPathAsString(path2);
        watch4.setConstraint(null);
        Watch watch5 = this.generateWatch(user2);
        watch5.setRep(rep2);
        watch5.setPathAsString(path2);
        watch5.setConstraint(null);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.watchDAO.add(watch5);
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchForUserRepPath(user1, rep1, new Path((CharSequence)path2)), (Matcher)Matchers.is((Object)watch2));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchForUserRepPath(user1, rep2, new Path((CharSequence)path2)), (Matcher)Matchers.is((Object)watch3));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchForUserRepPath(user2, rep2, new Path((CharSequence)path2)), (Matcher)Matchers.is((Object)watch5));
    }

    @Test
    public void testGetWatchesForUserRepPathConstraint() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        String rep1 = this.generateRepName();
        String rep2 = this.generateRepName();
        String path1 = this.generatePath();
        String path2 = this.generatePath();
        WaybackSpec constraint1 = this.generateWaybackSpec();
        WaybackSpec constraint2 = this.generateWaybackSpec();
        Watch watch1 = this.generateWatch(user1);
        watch1.setRep(rep1);
        watch1.setPathAsString(path1);
        watch1.setConstraintAsCommandString(constraint1.toCommandString().toString());
        Watch watch2 = this.generateWatch(user1);
        watch2.setRep(rep1);
        watch2.setPathAsString(path2);
        watch2.setConstraintAsCommandString(constraint1.toCommandString().toString());
        Watch watch3 = this.generateWatch(user1);
        watch3.setRep(rep2);
        watch3.setPathAsString(path2);
        watch3.setConstraintAsCommandString(constraint2.toCommandString().toString());
        Watch watch4 = this.generateWatch(user2);
        watch4.setRep(rep1);
        watch4.setPathAsString(path2);
        watch4.setConstraintAsCommandString(constraint1.toCommandString().toString());
        Watch watch5 = this.generateWatch(user2);
        watch5.setRep(rep2);
        watch5.setPathAsString(path2);
        watch5.setConstraintAsCommandString(constraint1.toCommandString().toString());
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.watchDAO.add(watch5);
        this.sessionFactory.getCurrentSession().flush();
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchForUserRepPathConstraint(user1, rep1, new Path((CharSequence)path2), constraint1), (Matcher)Matchers.is((Object)watch2));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchForUserRepPathConstraint(user1, rep2, new Path((CharSequence)path2), constraint2), (Matcher)Matchers.is((Object)watch3));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchForUserRepPathConstraint(user2, rep2, new Path((CharSequence)path2), constraint1), (Matcher)Matchers.is((Object)watch5));
    }

    @Test(expected=Exception.class)
    public void testConstraintOnUserRepoPath() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        String rep1 = this.generateRepName();
        String rep2 = this.generateRepName();
        String path1 = this.generatePath();
        String path2 = this.generatePath();
        Watch watch1 = this.generateWatch(user1);
        watch1.setRep(rep1);
        watch1.setPathAsString(path1);
        watch1.setConstraint(null);
        Watch watch2 = this.generateWatch(user1);
        watch2.setRep(rep1);
        watch2.setPathAsString(path2);
        watch2.setConstraint(null);
        Watch watch3 = this.generateWatch(user1);
        watch3.setRep(rep2);
        watch3.setPathAsString(path2);
        watch3.setConstraint(null);
        Watch watch4 = this.generateWatch(user2);
        watch4.setRep(rep2);
        watch4.setPathAsString(path2);
        watch4.setConstraint(null);
        Watch watch5 = this.generateWatch(user2);
        watch5.setRep(rep2);
        watch5.setPathAsString(path2);
        watch5.setConstraint(null);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.watchDAO.add(watch5);
        this.sessionFactory.getCurrentSession().flush();
        Assert.fail((String)"added watch for non-unique user/repo/path");
    }

    @Test
    public void testConstraintOnUserRepoPathConstrain() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        String rep1 = this.generateRepName();
        String path1 = this.generatePath();
        WaybackSpec constraint1 = this.generateWaybackSpec();
        WaybackSpec constraint2 = this.generateWaybackSpec();
        WaybackSpec constraint3 = this.generateWaybackSpec();
        WaybackSpec constraint4 = this.generateWaybackSpec();
        WaybackSpec constraint5 = this.generateWaybackSpec();
        Watch watch1 = this.generateWatch(user1);
        watch1.setRep(rep1);
        watch1.setPathAsString(path1);
        watch1.setConstraint(constraint1);
        Watch watch2 = this.generateWatch(user1);
        watch2.setRep(rep1);
        watch2.setPathAsString(path1);
        watch2.setConstraint(constraint2);
        Watch watch3 = this.generateWatch(user1);
        watch3.setRep(rep1);
        watch3.setPathAsString(path1);
        watch3.setConstraint(constraint3);
        Watch watch4 = this.generateWatch(user2);
        watch4.setRep(rep1);
        watch4.setPathAsString(path1);
        watch4.setConstraint(constraint4);
        Watch watch5 = this.generateWatch(user2);
        watch5.setRep(rep1);
        watch5.setPathAsString(path1);
        watch5.setConstraint(constraint5);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.watchDAO.add(watch5);
        this.sessionFactory.getCurrentSession().flush();
        MatcherAssert.assertThat((String)"constraint is used in watch key", (Object)true, (Matcher)Matchers.is((Object)true));
    }

    @Test(expected=JDBCException.class)
    public void testConstraintOnUserRepoPathConstrainFail() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        String rep1 = this.generateRepName();
        String path1 = this.generatePath();
        WaybackSpec constraint1 = this.generateWaybackSpec();
        Watch watch1 = this.generateWatch(user1);
        watch1.setRep(rep1);
        watch1.setPathAsString(path1);
        watch1.setConstraint(constraint1);
        Watch watch2 = this.generateWatch(user1);
        watch2.setRep(rep1);
        watch2.setPathAsString(path1);
        watch2.setConstraint(constraint1);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.sessionFactory.getCurrentSession().flush();
        Assert.fail((String)"added watch for non-unique user/repo/path/constraint");
    }

    @Test
    public void testRemoveWatchesForUser() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        Watch watch1 = this.generateWatch(user1);
        Watch watch2 = this.generateWatch(user2);
        Watch watch3 = this.generateWatch(user1);
        Watch watch4 = this.generateWatch(user2);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.sessionFactory.getCurrentSession().flush();
        this.watchDAO.removeWatchesForUser(user1);
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.containsInAnyOrder((Object[])new Watch[]{watch2, watch4}));
    }

    @Test
    public void testLoad() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch1 = this.generateWatch(user);
        Watch watch2 = this.generateWatch(user);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        MatcherAssert.assertThat((Object)this.watchDAO.load(watch1.getId()), (Matcher)Matchers.equalTo((Object)watch1));
        MatcherAssert.assertThat((Object)this.watchDAO.load(watch2.getId()), (Matcher)Matchers.equalTo((Object)watch2));
    }

    @Test
    public void testUpdateExisting() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch1 = this.generateWatch(user);
        Watch watch2 = this.generateWatch(user);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        Watch watch1new = this.generateWatch(user);
        watch1new.setId(watch1.getId());
        watch1new.setUser(watch1.getUser());
        watch1new.setRep(watch1.getRep());
        watch1new.setPath(watch1.getPath());
        watch1new.setConstraint(watch1.getConstraint());
        this.assertSameWatch(this.watchDAO.load(watch1.getId()), watch1);
        this.assertSameWatch(this.watchDAO.load(watch2.getId()), watch2);
        this.watchDAO.update(watch1new);
        this.assertSameWatch(this.watchDAO.load(watch1.getId()), watch1new);
        this.assertSameWatch(this.watchDAO.load(watch2.getId()), watch2);
    }

    @Test
    public void testUpdateNonExisting() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch1 = this.generateWatch(user);
        Watch watch2 = this.generateWatch(user);
        watch1.setId(Long.valueOf(new Random().nextLong()));
        this.watchDAO.add(watch2);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)1));
        this.assertSameWatch(this.watchDAO.load(watch2.getId()), watch2);
        this.watchDAO.update(watch1);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        MatcherAssert.assertThat((Object)this.watchDAO.getWatches(), (Matcher)Matchers.hasSize((int)1));
        this.assertSameWatch(this.watchDAO.load(watch2.getId()), watch2);
    }

    @Test
    public void testReproduceFECRU4176() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        Watch watch1 = this.generateWatch(user);
        Watch watch2 = this.generateWatch(user);
        Watch watch3 = this.generateWatch(user);
        Watch watch4 = this.generateWatch(user);
        this.watchDAO.add(watch1);
        this.watchDAO.add(watch2);
        this.watchDAO.add(watch3);
        this.watchDAO.add(watch4);
        this.sessionFactory.getCurrentSession().flush();
        this.watchDAO.delete(watch3.getId());
        this.sessionFactory.getCurrentSession().flush();
        watch3.setLastChecked(new Date().getTime());
        this.watchDAO.update(watch3);
        this.sessionFactory.getCurrentSession().flush();
        MatcherAssert.assertThat((Object)this.watchDAO.getWatchesForUser(user), (Matcher)Matchers.hasSize((int)3));
        this.sessionFactory.getCurrentSession().flush();
    }

    private void assertSameWatch(Watch watch1, Watch watch2) {
        MatcherAssert.assertThat((Object)watch1.getCacheSerialOfLastRevisionSent(), (Matcher)Matchers.equalTo((Object)watch2.getCacheSerialOfLastRevisionSent()));
        MatcherAssert.assertThat((Object)watch1.getConstraintAsCommandString(), (Matcher)Matchers.equalTo((Object)watch2.getConstraintAsCommandString()));
        MatcherAssert.assertThat((Object)watch1.getId(), (Matcher)Matchers.equalTo((Object)watch2.getId()));
        MatcherAssert.assertThat((Object)watch1.getLastChecked(), (Matcher)Matchers.equalTo((Object)watch2.getLastChecked()));
        MatcherAssert.assertThat((Object)watch1.getLastRevisionSent(), (Matcher)Matchers.equalTo((Object)watch2.getLastRevisionSent()));
        MatcherAssert.assertThat((Object)watch1.getPathAsString(), (Matcher)Matchers.equalTo((Object)watch2.getPathAsString()));
        MatcherAssert.assertThat((Object)watch1.getRep(), (Matcher)Matchers.equalTo((Object)watch2.getRep()));
        MatcherAssert.assertThat((Object)watch1.getUser(), (Matcher)Matchers.equalTo((Object)watch2.getUser()));
    }

    private String generateRepName() {
        return "test_watch_rep_" + this.rnd.nextInt(Integer.MAX_VALUE);
    }

    private String generateUserName() {
        return "test_watch_user_" + this.rnd.nextInt(Integer.MAX_VALUE);
    }

    private String generateRev() {
        return "test_watch_rev_" + this.rnd.nextInt(Integer.MAX_VALUE);
    }

    private Watch generateWatch(FecruUser user) {
        Watch watch = new Watch(user, this.generateRepName(), new Path((CharSequence)this.generatePath()), this.generateWaybackSpec(), this.rnd.nextLong(), new RevInfoKey(new Path((CharSequence)this.generatePath()), this.generateRev()));
        watch.setCacheSerialOfLastRevisionSent(this.rnd.nextLong());
        return watch;
    }

    private String generatePath() {
        return this.generatePath(10);
    }

    private String generatePath(int length) {
        StringBuilder path = new StringBuilder("/test_watch_path" + this.rnd.nextInt(Integer.MAX_VALUE));
        for (int i = 0; i < length; ++i) {
            path.append("/").append("path").append(this.rnd.nextInt(Integer.MAX_VALUE));
        }
        return path.toString();
    }

    private WaybackSpec generateWaybackSpec() {
        WaybackSpec waybackSpec = new WaybackSpec();
        waybackSpec.setAuthor("mswinarski" + this.rnd.nextInt(Integer.MAX_VALUE));
        waybackSpec.setBranch("branch" + this.rnd.nextInt(Integer.MAX_VALUE));
        waybackSpec.setCommentSearchText("la vie est belle!");
        waybackSpec.setDate(System.currentTimeMillis());
        waybackSpec.setDirectedToRoot(Boolean.valueOf(this.rnd.nextBoolean()));
        waybackSpec.setStartTime(System.currentTimeMillis() - (long)this.rnd.nextInt(3600000));
        waybackSpec.setEndTime(System.currentTimeMillis() + (long)this.rnd.nextInt(3600000));
        waybackSpec.setFileExtension("file_extension" + this.rnd.nextInt(100));
        waybackSpec.setFileName("file_name" + this.rnd.nextInt(100));
        waybackSpec.setMultipleBranches(Boolean.valueOf(this.rnd.nextBoolean()));
        waybackSpec.setTag("tag_name" + this.rnd.nextInt(100));
        return waybackSpec;
    }
}

