/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.util.FisheyeEmailValidator;
import com.opensymphony.xwork.validator.ValidationException;
import org.junit.Assert;
import org.junit.Test;

public class FisheyeEmailValidatorTest {
    private FisheyeEmailValidator validator = new FisheyeEmailValidator();

    @Test
    public void testValidate() throws ValidationException {
        Assert.assertTrue((boolean)this.validator.isValid((Object)"hat@hat.com"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"o'hat@hat.com"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"o'ohat'@hat.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"at.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)""));
        Assert.assertFalse((boolean)this.validator.isValid(null));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"@"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"foo@bazz@bar"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"white space@example.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)";@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)",@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)":@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"(@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)")@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"<@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)">@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"[@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"]@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"\\@dot.com"));
        Assert.assertFalse((boolean)this.validator.isValid((Object)"\"@dot.com"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"\"foo\"@bar"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"admin@127.0.0.1"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"admin@[IPv6:2001:db8:1ff::a0b:dbd0]"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"#CinematicsSourceCommits@blizzard.com"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"special!#$%&'*+-/=?^_`{|}~chars@special.!#$%&'*+-/=?^_`{|}~.com"));
        Assert.assertTrue((boolean)this.validator.isValid((Object)"\"()<>[]:,;@\\\\\\\"!#$%&'*+-/=?^_`{}| ~.a\"@example.com"));
    }
}

