/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.util.RevisionDateRange;
import com.cenqua.fisheye.web.FisheyeChangelogExplorer;
import java.util.Date;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FisheyeChangelogExplorerTest {
    @Mock
    private RevisionCache revisionCache;
    @Mock
    private DirInfo dirInfo;
    @Mock
    private Path path;
    private RevisionDateRange revisionDateRange;
    private FisheyeChangelogExplorer fisheyeChangelogExplorer;

    @Before
    public void setUp() throws Exception {
        this.revisionDateRange = new RevisionDateRange();
        Mockito.when((Object)this.revisionCache.findDirInfo((Path)Matchers.argThat((Matcher)org.hamcrest.Matchers.equalTo((Object)this.path)))).thenReturn((Object)this.dirInfo);
        Mockito.when((Object)this.dirInfo.getSubTreeDateRange()).thenReturn((Object)this.revisionDateRange);
    }

    @Test
    public void testConstructorNoMinMax() throws Exception {
        this.revisionDateRange.reset();
        long startTS = System.currentTimeMillis();
        this.fisheyeChangelogExplorer = new FisheyeChangelogExplorer(this.path, this.revisionCache, null);
        long stopTS = System.currentTimeMillis();
        Assert.assertThat((String)"same timestamp used for both min and max", (Object)this.fisheyeChangelogExplorer.getStartDate(), (Matcher)org.hamcrest.Matchers.equalTo((Object)this.fisheyeChangelogExplorer.getEndDate()));
        Assert.assertThat((String)"current timestamp was used", (Object)this.fisheyeChangelogExplorer.getStartDate(), (Matcher)org.hamcrest.Matchers.both((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(startTS))).and(org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(stopTS))));
    }

    @Test
    public void testConstructorMinMax() throws Exception {
        long min = new Date().getTime() - 123456L;
        long max = new Date().getTime() + 234567L;
        this.revisionDateRange.update(min, 1);
        this.revisionDateRange.update(max, 3);
        this.fisheyeChangelogExplorer = new FisheyeChangelogExplorer(this.path, this.revisionCache, null);
        Assert.assertThat((String)"provided min value was used", (Object)this.fisheyeChangelogExplorer.getStartDate(), (Matcher)org.hamcrest.Matchers.equalTo((Object)min));
        Assert.assertThat((String)"provided max value was used", (Object)this.fisheyeChangelogExplorer.getEndDate(), (Matcher)org.hamcrest.Matchers.equalTo((Object)max));
    }
}

