/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FishEyePathInfoTest {
    @Test
    public void testExtractRepositoryName() {
        this.assertRepNameEquals("name/branch/dir/filename.ext", "name");
        this.assertRepNameEquals(":name/branch/dir/filename.ext", "name");
    }

    private void assertRepNameEquals(String pathString, String repName) {
        FishEyePathInfo info = new FishEyePathInfo(pathString);
        Assert.assertEquals((Object)repName, (Object)info.getRepname());
    }

    @Test
    public void shouldNotDropQuestionMarksWhenCreatedFromRequest() throws Exception {
        HttpServletRequest req = this.makeRequest("https://fisheye.dev.internal.atlassian.com/committer/FE-git/%3Fukasz%20ku%3Fy%3Fski%20%3Clkuzynski%40atlassian.com%3E?ajax=true", "", "/committer");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getLocalPath(), (Matcher)Matchers.equalTo((Object)new Path((CharSequence)"?ukasz ku?y?ski <lkuzynski@atlassian.com>")));
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"FE-git"));
    }

    @Test
    public void shouldDropQuestionMarksWhenCreatedFromString() throws Exception {
        FishEyePathInfo pi = new FishEyePathInfo("/fecru/lukasz?foo=baR");
        Assert.assertThat((Object)pi.getLocalPath(), (Matcher)Matchers.equalTo((Object)new Path((CharSequence)"lukasz")));
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"fecru"));
    }

    @Test
    public void shouldCreateSingleSegmentPathWhenCreatedFromRequestWithEncodedSlashes() throws Exception {
        HttpServletRequest req = this.makeRequest("http://localhost:6060/foo/committer/samplehg/%3C%2Fa%3E%3Cscript%3Ealert%28f%29%3C%2Fscript%3E%20user%20%3Calerted2%40example.com%3E#fragment", "/foo", "/committer");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getLocalPath(), (Matcher)Matchers.equalTo((Object)new Path((List)ImmutableList.of((Object)"</a><script>alert(f)</script> user <alerted2@example.com>"))));
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"samplehg"));
        Assert.assertThat((Object)pi.getFullPath(), (Matcher)Matchers.equalTo((Object)new Path((List)ImmutableList.of((Object)"samplehg", (Object)"</a><script>alert(f)</script> user <alerted2@example.com>"))));
    }

    @Test
    public void shouldCreateMultiSegmentPathWhenCreatedFromRequestWithSlashes() throws Exception {
        HttpServletRequest req = this.makeRequest("http://fisheye/%2F%2F/foo%2Fbar/foobar/foo/", "", "");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getLocalPath(), (Matcher)Matchers.equalTo((Object)new Path((List)ImmutableList.of((Object)"foo/bar", (Object)"foobar", (Object)"foo"))));
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"//"));
    }

    @Test
    public void shouldSimplifyPaths() throws Exception {
        HttpServletRequest req = this.makeRequest("http://fisheye/foo/../bar/./foo..bar/foo.bar/.bar/.foo", "", "");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getLocalPath(), (Matcher)Matchers.equalTo((Object)new Path((List)ImmutableList.of((Object)"foo..bar", (Object)"foo.bar", (Object)".bar", (Object)".foo"))));
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void shouldSimplifyPathsToRoot() throws Exception {
        HttpServletRequest req = this.makeRequest("http://fisheye/foo/..", "", "");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getFullPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
    }

    @Test
    public void shouldHandlePathParamsAndUnreservedChars() throws Exception {
        HttpServletRequest req = this.makeRequest("http://example.com/repo/:@-._~!$&'()*+,=;:@-._~!$&'()*+,=:@-._~!$&'()*+,==?/?:@-._~!$'()*+,;=/?:@-._~!$", "", "");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"repo"));
        Assert.assertThat((Object)pi.getLocalPath().getPath(), (Matcher)Matchers.equalTo((Object)":@-._~!$&'()*+,="));
        Assert.assertThat((Object)pi.getFullPath(), (Matcher)Matchers.equalTo((Object)new Path((List)ImmutableList.of((Object)"repo", (Object)":@-._~!$&'()*+,="))));
    }

    @Test
    public void shouldHandleReservedChars() throws Exception {
        HttpServletRequest req = this.makeRequest("http://example.com/%2F%2Ffred@example.com%3Bfoo%2C%3Dbar%25", "", "");
        FishEyePathInfo pi = new FishEyePathInfo(req);
        Assert.assertThat((Object)pi.getRepname(), (Matcher)Matchers.equalTo((Object)"//fred@example.com;foo,=bar%"));
        Assert.assertThat((Object)pi.getLocalPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
    }

    @Test
    public void shouldHandleRootPath() throws Exception {
        HttpServletRequest root1 = this.makeRequest("http://example.com/", "", "");
        HttpServletRequest root2 = this.makeRequest("http://example.com/repo", "", "");
        HttpServletRequest root3 = this.makeRequest("http://example.com/repo/", "", "");
        HttpServletRequest root4 = this.makeRequest("http://example.com/repo//", "", "");
        HttpServletRequest root5 = this.makeRequest("http://example.com/repo/../../", "", "");
        FishEyePathInfo pi1 = new FishEyePathInfo(root1);
        FishEyePathInfo pi2 = new FishEyePathInfo(root2);
        FishEyePathInfo pi3 = new FishEyePathInfo(root3);
        FishEyePathInfo pi4 = new FishEyePathInfo(root4);
        FishEyePathInfo pi5 = new FishEyePathInfo(root5);
        Assert.assertThat((Object)pi1.getLocalPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
        Assert.assertThat((Object)pi1.getFullPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
        Assert.assertThat((Object)pi2.getLocalPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
        Assert.assertThat((Object)pi3.getLocalPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
        Assert.assertThat((Object)pi4.getLocalPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
        Assert.assertThat((Object)pi5.getLocalPath(), (Matcher)Matchers.equalTo((Object)Path.ROOT));
    }

    private HttpServletRequest makeRequest(final String uri, final String context, final String servlet) {
        return new DummyHttpServletRequest(){

            @Override
            public String getRequestURI() {
                return uri;
            }

            @Override
            public String getServletPath() {
                return servlet;
            }

            @Override
            public String getContextPath() {
                return context;
            }
        };
    }
}

