/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.DefaultWatchManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultWatchManagerChangeSetDataTest {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RepositoryEngine repositoryEngineMock;
    @Mock
    private ChangeSet changeSetMock;

    @Test
    public void testUrlsAreAbsolute() throws Exception {
        Mockito.when((Object)this.changeSetMock.getRepName()).thenReturn((Object)"someRepository");
        Mockito.when((Object)this.changeSetMock.getId()).thenReturn((Object)"abc123");
        Mockito.when((Object)this.repositoryEngineMock.getCfg().isAllowChangesetDiscussions()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isCrucible()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getSiteURL()).thenReturn((Object)"https://my.server/with-context");
        DefaultWatchManager.ChangeSetData csd = new DefaultWatchManager.ChangeSetData(this.changeSetMock, this.repositoryEngineMock, null);
        Assert.assertThat((String)"changeset discussion link", (Object)csd.getCommentUrlAbs(), (Matcher)Matchers.equalTo((Object)"https://my.server/with-context/changelog/someRepository?cs=abc123#c0"));
        Assert.assertThat((String)"create review link", (Object)csd.getCreateReviewUrlAbs(), (Matcher)Matchers.equalTo((Object)"https://my.server/with-context/cru/create?csid=%2F%2FsomeRepository%2Fabc123"));
    }
}

