/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.BranchSelectorPref;
import com.cenqua.fisheye.web.CookiePreferences;
import junit.framework.TestCase;

public class CookiePreferencesTest
extends TestCase {
    public void testOverride() throws Exception {
        CookiePreferences prefs = new CookiePreferences();
        CookiePreferencesTest.assertEquals((String)"Default value for implicitLines should be 'all'", (String)"all", (String)prefs.getImplicitLines());
        prefs.setValueUsingCookieName("impllines", "auth");
        CookiePreferencesTest.assertEquals((String)"Value for implicitLines should overridden", (String)"auth", (String)prefs.getImplicitLines());
    }

    public void testSetInvalid() throws Exception {
        CookiePreferences prefs = new CookiePreferences();
        prefs.setValueUsingCookieName("impllines", "blahblah");
        CookiePreferencesTest.assertEquals((String)"Value for implicitLines should not be overridden", (String)"all", (String)prefs.getImplicitLines());
    }

    public void testAppendToNonJsonCookie() throws Exception {
        CookiePreferences prefs = new CookiePreferences();
        prefs.putValueUsingCookieName("impllines", "auth");
        CookiePreferencesTest.assertEquals((String)"Value for implicitLines should be overridden", (String)"auth", (String)prefs.getImplicitLines());
    }

    public void testAppendToJsonCookie() throws Exception {
        CookiePreferences prefs = new CookiePreferences();
        CookiePreferencesTest.assertEquals(null, (Object)prefs.getLastSelectedBranch("rep1"));
        CookiePreferencesTest.assertEquals(null, (Object)prefs.getLastSelectedBranch("rep2"));
        prefs.putValueUsingCookieName("lsbr", "{\"rep1\":{\"t\":\"b\",\"n\":\"br1\"}}");
        BranchSelectorPref.Branch branch1 = prefs.getLastSelectedBranch("rep1");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch1.type);
        CookiePreferencesTest.assertEquals((String)"br1", (String)branch1.name);
        CookiePreferencesTest.assertEquals(null, (Object)prefs.getLastSelectedBranch("rep2"));
        prefs.putValueUsingCookieName("lsbr", "{\"rep1\":{\"t\":\"b\",\"n\":\"br2\"}}");
        branch1 = prefs.getLastSelectedBranch("rep1");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch1.type);
        CookiePreferencesTest.assertEquals((String)"br2", (String)branch1.name);
        CookiePreferencesTest.assertEquals(null, (Object)prefs.getLastSelectedBranch("rep2"));
        prefs.putValueUsingCookieName("lsbr", "{\"rep2\":{\"t\":\"t\",\"n\":\"tag1\"}}");
        branch1 = prefs.getLastSelectedBranch("rep1");
        BranchSelectorPref.Branch branch2 = prefs.getLastSelectedBranch("rep2");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch1.type);
        CookiePreferencesTest.assertEquals((String)"br2", (String)branch1.name);
        CookiePreferencesTest.assertEquals((String)"t", (String)branch2.type);
        CookiePreferencesTest.assertEquals((String)"tag1", (String)branch2.name);
    }

    public void testAppendInvalidToJsonCookie() throws Exception {
        CookiePreferences prefs = new CookiePreferences();
        prefs.putValueUsingCookieName("lsbr", "\"rep1\":{\"t\":\"b\",\"n\":\"br1\"}}");
        CookiePreferencesTest.assertEquals(null, (Object)prefs.getLastSelectedBranch("rep1"));
        prefs.putValueUsingCookieName("lsbr", "{\"rep1\":{\"t\":\"b\",\"n\":\"br1\"}}");
        BranchSelectorPref.Branch branch1 = prefs.getLastSelectedBranch("rep1");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch1.type);
        CookiePreferencesTest.assertEquals((String)"br1", (String)branch1.name);
        prefs.putValueUsingCookieName("lsbr", "\"rep1\":{\"t\":\"b\",\"n\":\"br1\"}}");
        branch1 = prefs.getLastSelectedBranch("rep1");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch1.type);
        CookiePreferencesTest.assertEquals((String)"br1", (String)branch1.name);
    }

    public void testAppendMaxJsonCookies() throws Exception {
        CookiePreferences prefs = new CookiePreferences(3);
        prefs.putValueUsingCookieName("lsbr", "{\"rep1\":{\"t\":\"b\",\"n\":\"br1\"}}");
        prefs.putValueUsingCookieName("lsbr", "{\"rep2\":{\"t\":\"b\",\"n\":\"br2\"}}");
        prefs.putValueUsingCookieName("lsbr", "{\"rep3\":{\"t\":\"b\",\"n\":\"br3\"}}");
        BranchSelectorPref.Branch branch1 = prefs.getLastSelectedBranch("rep1");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch1.type);
        CookiePreferencesTest.assertEquals((String)"br1", (String)branch1.name);
        BranchSelectorPref.Branch branch2 = prefs.getLastSelectedBranch("rep2");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch2.type);
        CookiePreferencesTest.assertEquals((String)"br2", (String)branch2.name);
        BranchSelectorPref.Branch branch3 = prefs.getLastSelectedBranch("rep3");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch3.type);
        CookiePreferencesTest.assertEquals((String)"br3", (String)branch3.name);
        BranchSelectorPref.Branch branch4 = prefs.getLastSelectedBranch("rep4");
        CookiePreferencesTest.assertEquals(null, (Object)branch4);
        prefs.putValueUsingCookieName("lsbr", "{\"rep4\":{\"t\":\"b\",\"n\":\"br4\"}}");
        branch1 = prefs.getLastSelectedBranch("rep1");
        CookiePreferencesTest.assertEquals(null, (Object)branch1);
        branch2 = prefs.getLastSelectedBranch("rep2");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch2.type);
        CookiePreferencesTest.assertEquals((String)"br2", (String)branch2.name);
        branch3 = prefs.getLastSelectedBranch("rep3");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch3.type);
        CookiePreferencesTest.assertEquals((String)"br3", (String)branch3.name);
        branch4 = prefs.getLastSelectedBranch("rep4");
        CookiePreferencesTest.assertEquals((String)"b", (String)branch4.type);
        CookiePreferencesTest.assertEquals((String)"br4", (String)branch4.name);
    }
}

