/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.activity.ActivityItemComparators;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImplTest;
import com.cenqua.fisheye.rep.DummyChangeSet;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.DummyCommitterUserMappingManager;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ChangeSetHolderTest {
    private ChangeSetHolder.Context contextMock;

    @Before
    public void setUp() throws Exception {
        this.contextMock = (ChangeSetHolder.Context)Mockito.mock(ChangeSetHolder.Context.class);
    }

    @Test
    public void testGetSortedBranches() throws Exception {
        DummyChangeSet cs = new DummyChangeSet(){

            public Set<String> getBranches() {
                HashSet<String> branches = new HashSet<String>();
                branches.add("master");
                branches.add("default");
                branches.add("mainline");
                branches.add("trunk");
                branches.add("branch-1");
                branches.add("20pc-seb-html-emails");
                return branches;
            }
        };
        Mockito.when((Object)this.contextMock.getDefaultBranch()).thenReturn((Object)"mainline");
        ChangeSetHolder csHolder = new ChangeSetHolder((ChangeSet)cs, this.contextMock, true, (CommitterUserMappingManager)new DummyCommitterUserMappingManager());
        Iterable branches = csHolder.getSortedBranches();
        Iterator iterator = branches.iterator();
        MatcherAssert.assertThat((String)"Branches are not empty", (Object)iterator.hasNext(), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((String)"First branch is the default branch", iterator.next(), (Matcher)Matchers.is((Object)"mainline"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"20pc-seb-html-emails"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"branch-1"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"default"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"master"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"trunk"));
        MatcherAssert.assertThat((String)"There are no more branches", (Object)iterator.hasNext(), (Matcher)Matchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testGetSortedBranchesWithNoDefault() throws Exception {
        DummyChangeSet cs = new DummyChangeSet(){

            public Set<String> getBranches() {
                HashSet<String> branches = new HashSet<String>();
                branches.add("master");
                branches.add("default");
                branches.add("mainline");
                branches.add("trunk");
                branches.add("branch-1");
                branches.add("20pc-seb-html-emails");
                return branches;
            }
        };
        Mockito.when((Object)this.contextMock.getDefaultBranch()).thenReturn(null);
        ChangeSetHolder csHolder = new ChangeSetHolder((ChangeSet)cs, this.contextMock, true, (CommitterUserMappingManager)new DummyCommitterUserMappingManager());
        Iterable branches = csHolder.getSortedBranches();
        Iterator iterator = branches.iterator();
        MatcherAssert.assertThat((String)"Branches are not empty", (Object)iterator.hasNext(), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"20pc-seb-html-emails"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"branch-1"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"default"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"mainline"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"master"));
        MatcherAssert.assertThat(iterator.next(), (Matcher)Matchers.is((Object)"trunk"));
        MatcherAssert.assertThat((String)"There are no more branches", (Object)iterator.hasNext(), (Matcher)Matchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testSorting() throws Exception {
        Date now = new Date();
        CommitterUserMappingManager committerUserMappingManager = (CommitterUserMappingManager)Mockito.mock(CommitterUserMappingManager.class);
        ChangeSetHolder.Context contextRep1 = (ChangeSetHolder.Context)Mockito.mock(ChangeSetHolder.Context.class);
        Mockito.when((Object)contextRep1.getRepoName()).thenReturn((Object)"rep1");
        ChangeSetHolder cs1 = new ChangeSetHolder((ChangeSet)new ChangeSetImplTest.TestChangeSetImpl("123", now.getTime(), "rep1"), contextRep1, false, committerUserMappingManager);
        ChangeSetHolder cs1Dup = new ChangeSetHolder((ChangeSet)new ChangeSetImplTest.TestChangeSetImpl("123", now.getTime(), "rep1"), contextRep1, false, committerUserMappingManager);
        ChangeSetHolder.Context contextRep2 = (ChangeSetHolder.Context)Mockito.mock(ChangeSetHolder.Context.class);
        Mockito.when((Object)contextRep2.getRepoName()).thenReturn((Object)"rep2");
        ChangeSetHolder cs2 = new ChangeSetHolder((ChangeSet)new ChangeSetImplTest.TestChangeSetImpl("123", now.getTime(), "rep2"), contextRep2, false, committerUserMappingManager);
        MatcherAssert.assertThat((String)"same changesets from same repo equal by compareTo (asc)", (Object)ActivityItemComparators.asc().compare(cs1, cs1Dup), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"changesets from different repositories, even when made at the same time and with same revision number, differ (asc)", (Object)ActivityItemComparators.asc().compare(cs1, cs2), (Matcher)Matchers.not((Matcher)Matchers.is((Object)0)));
        MatcherAssert.assertThat((String)"same changesets from same repo equal by compareTo (desc)", (Object)ActivityItemComparators.desc().compare(cs1, cs1Dup), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"changesets from different repositories, even when made at the same time and with same revision number, differ (desc)", (Object)ActivityItemComparators.desc().compare(cs1, cs2), (Matcher)Matchers.not((Matcher)Matchers.is((Object)0)));
    }
}

