/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.BranchSelectorPref;
import junit.framework.TestCase;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchSelectorPrefTest
extends TestCase {
    public void testGetBranch() throws Exception {
        JSONObject singleBranch = new JSONObject("{\"t\":\"b\",\"n\":\"name\"}");
        JSONObject cookie = new JSONObject("{\"rep1\":" + singleBranch.toString() + "}");
        BranchSelectorPref pref = new BranchSelectorPref(cookie);
        BranchSelectorPref.Branch expectedBranch = new BranchSelectorPref.Branch(singleBranch);
        BranchSelectorPrefTest.assertEquals((Object)expectedBranch, (Object)pref.getSelectedBranchForRepository("rep1"));
        BranchSelectorPrefTest.assertEquals(null, (Object)pref.getSelectedBranchForRepository("rep2"));
    }

    public void testUnusualCharacters() throws Exception {
        String branchName = ";:@#blah;(*>},uh oh&nbsp;";
        JSONObject singleBranch = new JSONObject("{\"t\":\"b\",\"n\":\"" + branchName + "\"}");
        JSONObject cookie = new JSONObject("{\"rep1\":" + singleBranch.toString() + "}");
        BranchSelectorPref pref = new BranchSelectorPref(cookie);
        BranchSelectorPref.Branch expectedBranch = new BranchSelectorPref.Branch(singleBranch);
        BranchSelectorPrefTest.assertEquals((Object)expectedBranch, (Object)pref.getSelectedBranchForRepository("rep1"));
        BranchSelectorPrefTest.assertEquals((String)branchName, (String)pref.getSelectedBranchForRepository("rep1").getName());
    }

    public void testInvalidType() throws Exception {
        JSONObject singleBranch = new JSONObject("{\"x\":\"x\",\"n\":\"name\"}");
        JSONObject cookie = new JSONObject("{\"rep1\":" + singleBranch.toString() + "}");
        BranchSelectorPref pref = new BranchSelectorPref(cookie);
        JSONException e = null;
        try {
            pref.getSelectedBranchForRepository("rep1");
        }
        catch (JSONException expectedE) {
            e = expectedE;
        }
        BranchSelectorPrefTest.assertNotNull((Object)((Object)e));
        BranchSelectorPrefTest.assertEquals((String)"JSONObject[\"t\"] not found.", (String)e.getMessage());
    }
}

