/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fecru.util.ListIterable;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DummyChangeSet;
import com.cenqua.fisheye.rep.DummyRevisionCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.SortedList;
import com.cenqua.fisheye.vis.ViewCommitGraphAction;
import com.cenqua.fisheye.web.DummyCommitterUserMappingManager;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ViewCommitGraphActionTest {
    private List<ChangeSet> changesets = new SortedList((left, right) -> left.getDateValue().compareTo(right.getDateValue()));

    @Before
    public void setUp() throws Exception {
        this.changesets.clear();
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss");
        this.createChangeSet(this.changesets, "root", formatter.parseMillis("2011/05/01 12:10:11"), "root:");
        this.createChangeSet(this.changesets, "ten", formatter.parseMillis("2011/04/01 12:10:11"), "default");
        this.createChangeSet(this.changesets, "nine", formatter.parseMillis("2011/03/01 12:10:11"), "branch9");
        this.createChangeSet(this.changesets, "eight", formatter.parseMillis("2011/02/01 12:10:11"), "branch8");
        this.createChangeSet(this.changesets, "seven", formatter.parseMillis("2011/01/01 12:10:11"), "branch7");
        this.createChangeSet(this.changesets, "six", formatter.parseMillis("2010/12/01 12:10:11"), "branch6");
        this.createChangeSet(this.changesets, "five", formatter.parseMillis("2010/11/01 12:10:11"), "branch5");
        this.createChangeSet(this.changesets, "four", formatter.parseMillis("2010/10/01 12:10:11"), "branch4");
        this.createChangeSet(this.changesets, "three", formatter.parseMillis("2010/09/01 12:10:11"), "branch3");
        this.createChangeSet(this.changesets, "two", formatter.parseMillis("2010/08/01 12:10:11"), "branch2");
        this.createChangeSet(this.changesets, "one", formatter.parseMillis("2010/07/01 12:10:11"), "branch1");
        this.createChangeSet(this.changesets, "zero", formatter.parseMillis("2010/06/01 12:10:11"), "branch0");
    }

    private void createChangeSet(List<ChangeSet> changesetsForIds, String csid, long createDate, String branchName) {
        TestChangeSet cs = new TestChangeSet(csid, createDate, branchName);
        changesetsForIds.add((ChangeSet)cs);
    }

    @Test
    public void testGetRecentlyActiveBranches() throws Exception {
        String repoName = "Test";
        RepositoryHandle repositoryHandle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        RepositoryConfig repositoryConfig = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        RepositoryManager repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        Mockito.when((Object)repositoryHandle.getName()).thenReturn((Object)repoName);
        Mockito.when((Object)repositoryHandle.getCfg()).thenReturn((Object)repositoryConfig);
        Mockito.when((Object)repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.HG);
        Mockito.when((Object)repositoryManager.getRepository(repoName)).thenReturn((Object)repositoryHandle);
        TestViewRepositoryGraphAction action = new TestViewRepositoryGraphAction(repositoryManager, "default", this.changesets);
        action.setRepoName(repoName);
        Set recentlyActiveBranches = action.getRecentlyActiveBranches();
        Assert.assertEquals((long)5L, (long)recentlyActiveBranches.size());
        Iterator iterator = recentlyActiveBranches.iterator();
        Assert.assertEquals((Object)"default", iterator.next());
        Assert.assertEquals((Object)"root:", iterator.next());
        Assert.assertEquals((Object)"branch9", iterator.next());
        Assert.assertEquals((Object)"branch8", iterator.next());
        Assert.assertEquals((Object)"branch7", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        action = new TestViewRepositoryGraphAction(repositoryManager, "default", this.changesets);
        action.setRepoName(repoName);
        Mockito.when((Object)repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.SVN);
        recentlyActiveBranches = action.getRecentlyActiveBranches();
        iterator = recentlyActiveBranches.iterator();
        Assert.assertEquals((Object)"default", iterator.next());
        Assert.assertEquals((Object)"branch9", iterator.next());
        Assert.assertEquals((Object)"branch8", iterator.next());
        Assert.assertEquals((Object)"branch7", iterator.next());
        Assert.assertEquals((Object)"branch6", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private class TestViewRepositoryGraphAction
    extends ViewCommitGraphAction {
        private final List<ChangeSet> changesets;
        private final String defaultBranch;
        private RevisionCache revCache;

        private TestViewRepositoryGraphAction(RepositoryManager repositoryManager, String defaultBranch, List<ChangeSet> changesets) {
            super(repositoryManager, null, null, null, null, null, null, null, null, (CommitterUserMappingManager)new DummyCommitterUserMappingManager());
            this.revCache = new DummyRevisionCache(){

                @Override
                public String getDefaultBranch() {
                    return TestViewRepositoryGraphAction.this.defaultBranch;
                }

                @Override
                public FileRevision findFileRevision(Path path, String revision) throws DbException {
                    return null;
                }

                @Override
                public ListIterable<ChangeSet> getChangeSets() {
                    return new ListIterable<ChangeSet>(){

                        public ListIterator<ChangeSet> iterator() {
                            return TestViewRepositoryGraphAction.this.changesets.listIterator();
                        }

                        public ListIterator<ChangeSet> iteratorFromEnd() {
                            return TestViewRepositoryGraphAction.this.changesets.listIterator(TestViewRepositoryGraphAction.this.changesets.size());
                        }
                    };
                }
            };
            this.defaultBranch = defaultBranch;
            this.changesets = changesets;
        }

        protected RevisionCache getRevisionCache() {
            return this.revCache;
        }
    }

    private static class TestChangeSet
    extends DummyChangeSet {
        private final String csid;
        private final long createDate;
        private final Set<String> branches;

        private TestChangeSet(String csid, long createDate, String branch) {
            this.csid = csid;
            this.createDate = createDate;
            this.branches = Sets.newHashSet((Object[])new String[]{branch});
        }

        public String getId() {
            return this.csid;
        }

        public long getDate() {
            return this.createDate;
        }

        public Date getDateValue() {
            return new Date(this.createDate);
        }

        public Set<String> getBranches() {
            return this.branches;
        }
    }
}

