/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Timer;
import java.awt.Window;
import java.io.IOException;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class StackedChartTester
extends ApplicationFrame {
    public StackedChartTester(String string) throws IOException, DbException {
        super(string);
        this.setContentPane(StackedChartTester.createDemoPanel());
    }

    public static JPanel createDemoPanel() throws IOException, DbException {
        XYSeries[] seriess;
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        XYSeries series = new XYSeries((Comparable)((Object)"s1"), true, false);
        series.add(1.0, 100.0);
        series.add(2.0, 250.0);
        series.add(3.0, 5000.0);
        series.add(4.0, 1800.0);
        XYSeries series2 = new XYSeries((Comparable)((Object)"s2"), true, false);
        series2.add(1.0, 100.0);
        series2.add(2.0, 200.0);
        series2.add(3.0, 1000.0);
        series2.add(4.0, 150.0);
        XYSeries series3 = new XYSeries((Comparable)((Object)"series3"), true, true);
        series3.add(1.0, 20.0);
        series3.add(2.0, 20.0);
        series3.add(3.0, 20.0);
        series3.add(4.0, 20.0);
        series3.add(5.0, 20.0);
        series3.add(6.0, 2.0);
        for (XYSeries xySeries : seriess = new XYSeries[]{series, series2}) {
            dataset.addSeries(xySeries);
        }
        JFreeChart chart = StackedChartTester.createChart((XYDataset)dataset);
        return new ChartPanel(chart);
    }

    private static JFreeChart createChart(XYDataset dataset) {
        Timer time = new Timer("render");
        StackedXYAreaRenderer2 stepRenderer = new StackedXYAreaRenderer2();
        Range range = stepRenderer.findRangeBounds(dataset);
        Range domain = stepRenderer.findDomainBounds(dataset);
        System.out.println("range = " + range);
        System.out.println("domain = " + domain);
        NumberAxis domainAxis = new NumberAxis();
        NumberAxis rangeAxis = new NumberAxis();
        XYPlot plot = new XYPlot(dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)stepRenderer);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.removeLegend();
        chart.setPadding(new RectangleInsets(1.0, 1.0, 1.0, 15.0));
        return chart;
    }

    public static void main(String[] args) throws IOException, DbException {
        StackedChartTester tester = new StackedChartTester("Line Count Demo");
        tester.setResizable(true);
        tester.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)tester));
        tester.setVisible(true);
    }
}

