/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.diff;

import com.cenqua.fisheye.util.diff.SectionSpec;
import com.cenqua.fisheye.util.diff.UnifiedDiffSectionSpec;
import junit.framework.TestCase;

public class SectionSpecTest
extends TestCase {
    public void testStandardSection() {
        UnifiedDiffSectionSpec spec = new UnifiedDiffSectionSpec("@@ -1,2 +3,4 @@");
        this.assertSection((SectionSpec)spec, 1, 2, 3, 4);
    }

    public void testNoTo() {
        UnifiedDiffSectionSpec spec = new UnifiedDiffSectionSpec("@@ -1,325 @@\n");
        this.assertSection((SectionSpec)spec, 1, 325, -1, -1);
    }

    public void testNoFromCount() {
        UnifiedDiffSectionSpec spec = new UnifiedDiffSectionSpec("@@ -1 +1,1281 @@");
        this.assertSection((SectionSpec)spec, 1, 1, 1, 1281);
    }

    public void testNoToCount() {
        UnifiedDiffSectionSpec spec = new UnifiedDiffSectionSpec("@@ -0,0 +1 @@");
        this.assertSection((SectionSpec)spec, 0, 0, 1, 1);
    }

    private void assertSection(SectionSpec spec, int from, int fromCount, int to, int toCount) {
        SectionSpecTest.assertEquals((String)"From mismatch", (int)from, (int)spec.getFrom());
        SectionSpecTest.assertEquals((String)"From count mismatch", (int)fromCount, (int)spec.getFromCount());
        SectionSpecTest.assertEquals((String)"To mismatch", (int)to, (int)spec.getTo());
        SectionSpecTest.assertEquals((String)"To count mismatch", (int)toCount, (int)spec.getToCount());
    }
}

