/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.cond;

import com.cenqua.fisheye.util.cond.AtomEvaluator;
import com.cenqua.fisheye.util.cond.AtomExpr;
import com.cenqua.fisheye.util.cond.BoolExpr;
import junit.framework.TestCase;

public class BoolExprTest
extends TestCase {
    private AtomEvaluator evaluator = new TestEvaluator();

    public void testBasicParsing() throws Exception {
        BoolExpr.parse((String)"foo");
        BoolExpr.parse((String)"foo & bar");
        BoolExpr.parse((String)"foo | bar");
        BoolExpr.parse((String)"foo | bar & wombat");
        BoolExpr.parse((String)"foo | (bar & wombat)");
    }

    public void testStringTokens() throws Exception {
        AtomExpr e = (AtomExpr)BoolExpr.parse((String)"foo");
        BoolExprTest.assertEquals((String)"foo", (String)e.getIdent());
        e = (AtomExpr)BoolExpr.parse((String)"'foo'");
        BoolExprTest.assertEquals((String)"foo", (String)e.getIdent());
        e = (AtomExpr)BoolExpr.parse((String)"\"foo\"");
        BoolExprTest.assertEquals((String)"foo", (String)e.getIdent());
        e = (AtomExpr)BoolExpr.parse((String)"'f o o'");
        BoolExprTest.assertEquals((String)"f o o", (String)e.getIdent());
        e = (AtomExpr)BoolExpr.parse((String)"'f\\'o'");
        BoolExprTest.assertEquals((String)"f'o", (String)e.getIdent());
        e = (AtomExpr)BoolExpr.parse((String)"'f\\\"o'");
        BoolExprTest.assertEquals((String)"f\"o", (String)e.getIdent());
        e = (AtomExpr)BoolExpr.parse((String)"'f\\\\o'");
        BoolExprTest.assertEquals((String)"f\\o", (String)e.getIdent());
    }

    public void testNonAscii() throws Exception {
        AtomExpr e = (AtomExpr)BoolExpr.parse((String)"'D\u00e9veloppement'");
        BoolExprTest.assertEquals((String)"D\u00e9veloppement", (String)e.getIdent());
    }

    public void testEvaluation() throws Exception {
        this.assertExprEquals(true, "a");
        this.assertExprEquals(false, "b");
        this.assertExprEquals(true, "a|b");
        this.assertExprEquals(true, "b|a");
        this.assertExprEquals(false, "a&b");
        this.assertExprEquals(false, "b&a");
        this.assertExprEquals(false, "a&b&c)");
        this.assertExprEquals(true, "b|a|c)");
        this.assertExprEquals(true, "(a|b)&c");
        this.assertExprEquals(false, "(a|b)&d");
        this.assertExprEquals(true, "a|(b&c)");
        this.assertExprEquals(true, "a|(b&d)");
        this.assertExprEquals(true, "a|b&c");
        this.assertExprEquals(true, "a|b&d");
    }

    private void assertExprEquals(boolean expected, String expr) throws Exception {
        BoolExpr e = BoolExpr.parse((String)expr);
        BoolExprTest.assertEquals((boolean)expected, (boolean)e.evaluate(this.evaluator));
    }

    static class TestEvaluator
    implements AtomEvaluator {
        TestEvaluator() {
        }

        public boolean eval(String ident) {
            if ("a".equals(ident)) {
                return true;
            }
            if ("c".equals(ident)) {
                return true;
            }
            return "e".equals(ident);
        }
    }
}

