/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.bitset;

import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.BiDiBitSet;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import junit.framework.TestCase;

public class SortedIntSetTest
extends TestCase {
    public void testBiDiBitSet() {
        this.doTests(BiDiBitSet::new);
    }

    public void testSegmentedBitSet() {
        this.doTests(length -> new SegmentedIntSet());
    }

    private void doTests(Factory f) {
        this.doTestLength(f);
        this.doTestPrevOnLeadngZeros(f);
        this.doTestEmptyGets(f);
        this.doTest1(f);
        this.doTestClear(f);
    }

    private void doTestClear(Factory f) {
        SortedIntSet testSet = f.make(20);
        testSet.set(1);
        testSet.set(5);
        testSet.set(10);
        testSet.set(20);
        SortedIntSetTest.assertEquals((int)4, (int)testSet.cardinality());
        testSet.clear(5);
        SortedIntSetTest.assertEquals((int)3, (int)testSet.cardinality());
        testSet.clear(5);
        SortedIntSetTest.assertEquals((int)3, (int)testSet.cardinality());
        testSet.clear(6);
        SortedIntSetTest.assertEquals((int)3, (int)testSet.cardinality());
        testSet.clear(10);
        testSet.clear(20);
        SortedIntSetTest.assertEquals((int)1, (int)testSet.cardinality());
        testSet.clear(1);
        SortedIntSetTest.assertEquals((int)0, (int)testSet.cardinality());
        testSet.clear(1);
        SortedIntSetTest.assertEquals((int)0, (int)testSet.cardinality());
        testSet.set(1);
        SortedIntSetTest.assertEquals((int)1, (int)testSet.cardinality());
    }

    private void doTestEmptyGets(Factory f) {
        SortedIntSet sbs = f.make(10);
        SortedIntSetTest.assertEquals((boolean)false, (boolean)sbs.get(0));
        SortedIntSetTest.assertEquals((boolean)false, (boolean)sbs.get(5));
        SortedIntSetTest.assertEquals((boolean)false, (boolean)sbs.get(10));
        SortedIntSetTest.assertEquals((int)-1, (int)sbs.nextSetBit(0));
        SortedIntSetTest.assertEquals((int)-1, (int)sbs.prevSetBit(10));
    }

    private void doTestLength(Factory f) {
        SortedIntSet sbs = f.make(10);
        SortedIntSetTest.assertEquals((int)0, (int)sbs.length());
        sbs.set(0);
        SortedIntSetTest.assertEquals((int)1, (int)sbs.length());
        sbs.set(10);
        SortedIntSetTest.assertEquals((int)11, (int)sbs.length());
        sbs.set(8);
        SortedIntSetTest.assertEquals((int)11, (int)sbs.length());
        int x = 8192;
        sbs.set(x - 1);
        SortedIntSetTest.assertEquals((int)x, (int)sbs.length());
        sbs.set(x);
        SortedIntSetTest.assertEquals((int)(x + 1), (int)sbs.length());
        sbs.set(10 * x - 1);
        SortedIntSetTest.assertEquals((int)(10 * x), (int)sbs.length());
        sbs.set(10 * x);
        SortedIntSetTest.assertEquals((int)(10 * x + 1), (int)sbs.length());
    }

    private void doTestPrevOnLeadngZeros(Factory f) {
        SortedIntSet sbs = f.make(10);
        sbs.set(2);
        SortedIntSetTest.assertEquals((int)2, (int)sbs.prevSetBit(Integer.MAX_VALUE));
        SortedIntSetTest.assertEquals((int)2, (int)sbs.prevSetBit(8192));
        SortedIntSetTest.assertEquals((int)2, (int)sbs.prevSetBit(10));
        SortedIntSetTest.assertEquals((int)2, (int)sbs.prevSetBit(3));
        SortedIntSetTest.assertEquals((int)2, (int)sbs.prevSetBit(2));
        SortedIntSetTest.assertEquals((int)-1, (int)sbs.prevSetBit(1));
        SortedIntSetTest.assertEquals((int)-1, (int)sbs.prevSetBit(0));
    }

    private void doTest1(Factory f) {
        int length = 1000000;
        int lastSet = 0;
        int cardinality = 0;
        SortedIntSet sbs = f.make(length);
        for (int i = 0; i <= length; ++i) {
            if (i % 63 != 0) continue;
            sbs.set(i);
            lastSet = i;
            ++cardinality;
        }
        SortedIntSetTest.assertEquals((int)cardinality, (int)sbs.cardinality());
        Timer timer = new Timer("large bit set " + sbs.getClass().getName());
        for (int i = 0; i <= length; ++i) {
            String msg = "at " + i;
            SortedIntSetTest.assertEquals((String)msg, (i % 63 == 0 ? 1 : 0) != 0, (boolean)sbs.get(i));
            if (i % 63 == 0) {
                SortedIntSetTest.assertEquals((String)msg, (int)i, (int)sbs.nextSetBit(i));
            } else if (i <= lastSet) {
                SortedIntSetTest.assertEquals((String)msg, (int)(i / 63 * 63 + 63), (int)sbs.nextSetBit(i));
            } else {
                SortedIntSetTest.assertEquals((String)msg, (int)-1, (int)sbs.nextSetBit(i));
            }
            if (i % 63 == 0) {
                SortedIntSetTest.assertEquals((String)msg, (int)i, (int)sbs.prevSetBit(i));
                continue;
            }
            SortedIntSetTest.assertEquals((String)msg, (int)((i - 1) / 63 * 63), (int)sbs.prevSetBit(i));
        }
        timer.end();
    }

    static interface Factory {
        public SortedIntSet make(int var1);
    }
}

