/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.bitset;

import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.BiDiBitSet;
import java.util.BitSet;
import junit.framework.TestCase;

public class BiDiBitSetTest
extends TestCase {
    public void genArray() {
        int i;
        int[] array = new int[256];
        for (i = 0; i < array.length; ++i) {
            array[i] = BiDiBitSetTest.startingZeroCnt(i) - 56;
        }
        System.out.print("{");
        for (i = 0; i < array.length; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            int val = array[i];
            System.out.print(val + ", ");
        }
        System.out.print("}");
    }

    public void testUnrolledLoop() {
        long i;
        BiDiBitSetTest.assertEquals((int)0, (int)BiDiBitSet.unrolledStartingZeroCnt((long)Long.MIN_VALUE));
        BiDiBitSetTest.assertEquals((int)1, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x4000000000000000L));
        BiDiBitSetTest.assertEquals((int)2, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x2000000000000000L));
        BiDiBitSetTest.assertEquals((int)3, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x1000000000000000L));
        BiDiBitSetTest.assertEquals((int)4, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x800000000000000L));
        BiDiBitSetTest.assertEquals((int)5, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x400000000000000L));
        BiDiBitSetTest.assertEquals((int)6, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x200000000000000L));
        BiDiBitSetTest.assertEquals((int)7, (int)BiDiBitSet.unrolledStartingZeroCnt((long)0x100000000000000L));
        for (int i2 = 0; i2 < 1000; ++i2) {
            BiDiBitSetTest.assertEquals((String)("i = " + i2), (int)BiDiBitSetTest.startingZeroCnt(i2), (int)BiDiBitSet.unrolledStartingZeroCnt((long)i2));
        }
        for (i = 9223372036854774807L; i < Long.MAX_VALUE; ++i) {
            BiDiBitSetTest.assertEquals((String)("i = " + i), (int)BiDiBitSetTest.startingZeroCnt(i), (int)BiDiBitSet.unrolledStartingZeroCnt((long)i));
        }
        i = 0L;
        while (i < Long.MAX_VALUE) {
            BiDiBitSetTest.assertEquals((String)("i = " + i), (int)BiDiBitSetTest.startingZeroCnt(i), (int)BiDiBitSet.unrolledStartingZeroCnt((long)i));
            i = i * 2L + 1L;
        }
    }

    public void testLargeBitSetPerf() {
        int i;
        int length = 10000000;
        BiDiBitSet bidibs = new BiDiBitSet(length);
        BitSet bs = new BitSet(length);
        int setBitInterval = 657;
        Timer timer = new Timer("LargeBitSet");
        for (i = 0; i <= length; ++i) {
            bs.set(i, i % 657 == 0);
            bidibs.set(i, i % 657 == 0);
        }
        timer.mark("created BitSets");
        i = bidibs.length() - 1;
        while (i > 0) {
            BiDiBitSetTest.assertEquals((String)("i = " + i), (int)0, (int)(i % 657));
            i = bidibs.prevSetBit(i - 1);
        }
        timer.mark("bidibs.prevSetBit");
        i = bs.nextSetBit(0);
        while (i >= 0) {
            BiDiBitSetTest.assertEquals((String)("i = " + i), (int)0, (int)(i % 657));
            i = bs.nextSetBit(i + 1);
        }
        timer.mark("bs.nextSetBit");
        i = bs.nextSetBit(0);
        while (i >= 0) {
            BiDiBitSetTest.assertEquals((String)("i = " + i), (int)0, (int)(i % 657));
            i = bidibs.nextSetBit(i + 1);
        }
        timer.mark("bidibs.nextSetBit");
        timer.end();
    }

    public void testLargeIndex() {
        BiDiBitSet bidibs = new BiDiBitSet();
        bidibs.set(2);
        BiDiBitSetTest.assertEquals((int)2, (int)bidibs.prevSetBit(Integer.MAX_VALUE));
        BiDiBitSetTest.assertEquals((int)2, (int)bidibs.prevSetBit(8192));
        BiDiBitSetTest.assertEquals((int)2, (int)bidibs.prevSetBit(10));
        BiDiBitSetTest.assertEquals((int)2, (int)bidibs.prevSetBit(3));
        BiDiBitSetTest.assertEquals((int)2, (int)bidibs.prevSetBit(2));
        BiDiBitSetTest.assertEquals((int)-1, (int)bidibs.prevSetBit(1));
        BiDiBitSetTest.assertEquals((int)-1, (int)bidibs.prevSetBit(0));
    }

    public void testLargeBitSet() {
        int length = 1000000;
        BiDiBitSet bidibs = new BiDiBitSet(length);
        for (int i = 0; i <= length; ++i) {
            bidibs.set(i, i % 63 == 0);
        }
        Timer timer = new Timer("large bit set");
        for (int i = 0; i <= length; ++i) {
            int prevSetBit = bidibs.prevSetBit(i);
            BiDiBitSetTest.assertEquals((String)("Failed on i = " + i), (int)0, (int)(prevSetBit % 63));
        }
        timer.end();
    }

    public void testPreviousBitSet() {
        int i;
        BiDiBitSet zeroBs = new BiDiBitSet(0);
        BiDiBitSetTest.assertEquals((int)-1, (int)zeroBs.prevSetBit(0));
        BiDiBitSet singleBs = new BiDiBitSet(1);
        BiDiBitSetTest.assertEquals((int)-1, (int)singleBs.prevSetBit(0));
        singleBs.set(0);
        BiDiBitSetTest.assertEquals((int)0, (int)singleBs.prevSetBit(0));
        BiDiBitSetTest.assertEquals((int)0, (int)singleBs.prevSetBit(1));
        BiDiBitSet bs = new BiDiBitSet(10);
        for (i = 0; i <= 10; ++i) {
            bs.set(i, i % 3 == 0);
        }
        for (i = 32; i >= 0; --i) {
            int n = bs.prevSetBit(i);
        }
        BiDiBitSetTest.assertEquals((int)9, (int)bs.prevSetBit(12));
        BiDiBitSetTest.assertEquals((int)9, (int)bs.prevSetBit(11));
        BiDiBitSetTest.assertEquals((int)9, (int)bs.prevSetBit(10));
        BiDiBitSetTest.assertEquals((int)9, (int)bs.prevSetBit(9));
        BiDiBitSetTest.assertEquals((int)6, (int)bs.prevSetBit(8));
        BiDiBitSetTest.assertEquals((int)6, (int)bs.prevSetBit(7));
        BiDiBitSetTest.assertEquals((int)6, (int)bs.prevSetBit(6));
        BiDiBitSetTest.assertEquals((int)3, (int)bs.prevSetBit(5));
        BiDiBitSetTest.assertEquals((int)3, (int)bs.prevSetBit(4));
        BiDiBitSetTest.assertEquals((int)3, (int)bs.prevSetBit(3));
        BiDiBitSetTest.assertEquals((int)0, (int)bs.prevSetBit(2));
        BiDiBitSetTest.assertEquals((int)0, (int)bs.prevSetBit(1));
        BiDiBitSetTest.assertEquals((int)0, (int)bs.prevSetBit(0));
        try {
            bs.prevSetBit(-1);
            BiDiBitSetTest.fail((String)"No Exception thrown");
        }
        catch (IndexOutOfBoundsException i2) {
        }
        catch (Exception e) {
            BiDiBitSetTest.fail((String)("Incorrect exception thrown: " + e));
        }
    }

    public void testNextBitSet() {
        int i;
        BiDiBitSet zeroBs = new BiDiBitSet(0);
        BiDiBitSetTest.assertEquals((int)-1, (int)zeroBs.nextSetBit(0));
        BiDiBitSet singleBs = new BiDiBitSet(1);
        BiDiBitSetTest.assertEquals((int)-1, (int)singleBs.nextSetBit(0));
        singleBs.set(0);
        BiDiBitSetTest.assertEquals((int)0, (int)singleBs.nextSetBit(0));
        BiDiBitSetTest.assertEquals((int)-1, (int)singleBs.nextSetBit(1));
        BiDiBitSet bs = new BiDiBitSet(100);
        for (i = 0; i <= 10; ++i) {
            bs.set(i, i % 3 == 0);
        }
        for (i = 0; i <= 100; ++i) {
            bs.nextSetBit(i);
        }
        BiDiBitSetTest.assertEquals((int)9, (int)bs.nextSetBit(9));
        BiDiBitSetTest.assertEquals((int)9, (int)bs.nextSetBit(8));
        BiDiBitSetTest.assertEquals((int)9, (int)bs.nextSetBit(7));
        BiDiBitSetTest.assertEquals((int)6, (int)bs.nextSetBit(6));
        BiDiBitSetTest.assertEquals((int)6, (int)bs.nextSetBit(5));
        BiDiBitSetTest.assertEquals((int)6, (int)bs.nextSetBit(4));
        BiDiBitSetTest.assertEquals((int)3, (int)bs.nextSetBit(3));
        BiDiBitSetTest.assertEquals((int)3, (int)bs.nextSetBit(2));
        BiDiBitSetTest.assertEquals((int)3, (int)bs.nextSetBit(1));
        BiDiBitSetTest.assertEquals((int)0, (int)bs.nextSetBit(0));
    }

    static int startingZeroCnt(long val) {
        if (val == 0L) {
            return 32;
        }
        long mask = Long.MIN_VALUE;
        int offset = 0;
        while ((val & mask) == 0L) {
            ++offset;
            val <<= 1;
        }
        return offset;
    }
}

