/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.util.Zipper;
import com.google.common.base.Charsets;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;

public class ZipperTest
extends TestCase {
    public void testZip() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] testData = "testing 123".getBytes();
        Zipper zipper = new Zipper();
        File[] files = new File[4];
        for (int i = 0; i < files.length - 1; ++i) {
            files[i] = FisheyeTestUtil.createTempFile(ZipperTest.class.getName());
            FileOutputStream fouts = new FileOutputStream(files[i]);
            fouts.write(testData);
            fouts.flush();
            fouts.close();
            zipper.add(new Path((CharSequence)files[i].getPath()), files[i]);
        }
        zipper.add(new Path((CharSequence)"path/nullfile"), null);
        zipper.zip((OutputStream)out);
        byte[] zippedBytes = out.toByteArray();
        ZipperTest.assertTrue((zippedBytes.length > 0 ? 1 : 0) != 0);
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(out.toByteArray()));
        for (int i = 0; i < files.length - 1; ++i) {
            File file = files[i];
            ZipEntry zentry = zin.getNextEntry();
            ZipperTest.assertTrue((boolean)file.getPath().contains(zentry.getName()));
        }
    }

    public void testEmptyZip() {
        try {
            Zipper zipper = new Zipper();
            zipper.zip((OutputStream)new ByteArrayOutputStream());
            ZipperTest.fail((String)"No IOException for empty zip thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testZipDir() throws IOException {
        ZipEntry zentry;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HashMap<String, File> files = this.makeZipDir(out);
        byte[] zippedBytes = out.toByteArray();
        ZipperTest.assertTrue((zippedBytes.length > 0 ? 1 : 0) != 0);
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(out.toByteArray()));
        while ((zentry = zin.getNextEntry()) != null) {
            System.out.println("zip entry: " + zentry.getName());
            ZipperTest.assertTrue((boolean)files.containsKey(zentry.getName()));
            zin.closeEntry();
        }
    }

    public void testUnZip() throws IOException {
        File outFile = FisheyeTestUtil.createTempFile(ZipperTest.class.getName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        HashMap<String, File> files = this.makeZipDir(out);
        File dest = FisheyeTestUtil.createTempDir(ZipperTest.class.getName());
        Zipper zipper = new Zipper();
        System.out.println("unziping to " + dest.getAbsolutePath());
        Zipper.unzip((File)outFile, (File)dest);
        for (String path : files.keySet()) {
            File destFile = new File(dest, path);
            ZipperTest.assertTrue((String)"file doesn't exist", (boolean)destFile.exists());
        }
    }

    private HashMap<String, File> makeZipDir(OutputStream out) throws IOException {
        byte[] testData = "testing 123".getBytes();
        Path internalZipPath = new Path((CharSequence)"save/data/here");
        File dir = FisheyeTestUtil.createTempDir(ZipperTest.class.getName());
        Zipper zipper = new Zipper();
        HashMap<String, File> files = this.makeFiles(dir, testData, internalZipPath);
        zipper.add(internalZipPath, dir);
        zipper.zip(out);
        return files;
    }

    private HashMap<String, File> makeFiles(File dir, byte[] testData, Path internalZipPath) throws IOException {
        HashMap<String, File> files = new HashMap<String, File>();
        for (int i = 0; i < 4; ++i) {
            File tmpFile = FisheyeTestUtil.createTempFile(ZipperTest.class.getName(), dir);
            Path tmpPath = new Path(internalZipPath, tmpFile.getName());
            System.out.println("file: " + tmpPath.getPath());
            files.put(tmpPath.getPath(), tmpFile);
            FileOutputStream fouts = new FileOutputStream(tmpFile);
            fouts.write(testData);
            fouts.flush();
            fouts.close();
        }
        return files;
    }

    public void testRecursive() throws Exception {
        File root = FisheyeTestUtil.createTempDir("test");
        File d1 = new File(root, "1");
        d1.mkdirs();
        IOHelper.copyStringToFile((String)"file1", (Charset)Charsets.UTF_8, (File)new File(d1, "file1"));
        File d12 = new File(root, "1/2");
        d12.mkdirs();
        IOHelper.copyStringToFile((String)"file2", (Charset)Charsets.UTF_8, (File)new File(d12, "file2"));
        File d123 = new File(root, "1/2/3");
        d123.mkdirs();
        IOHelper.copyStringToFile((String)"file3", (Charset)Charsets.UTF_8, (File)new File(d123, "file3"));
        Zipper zipper = new Zipper();
        zipper.add(new Path((CharSequence)"1"), d1.getAbsoluteFile());
        File zipfile = FisheyeTestUtil.createTempFile("dest.zip");
        FileOutputStream dest = new FileOutputStream(zipfile);
        zipper.zip((OutputStream)dest);
        dest.close();
        File copy = FisheyeTestUtil.createTempDir("copy");
        Zipper.unzip((File)zipfile, (File)copy);
        ZipperTest.assertTrue((boolean)new File(copy, "1").isDirectory());
        ZipperTest.assertTrue((boolean)new File(copy, "1/file1").isFile());
        ZipperTest.assertTrue((boolean)new File(copy, "1/2").isDirectory());
        ZipperTest.assertTrue((boolean)new File(copy, "1/2/file2").isFile());
        ZipperTest.assertTrue((boolean)new File(copy, "1/2/3").isDirectory());
        ZipperTest.assertTrue((boolean)new File(copy, "1/2/3/file3").isFile());
    }
}

