/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.XmlUtils;
import junit.framework.TestCase;

public class XmlUtilsTest
extends TestCase {
    private final String legal = "legal:   \ufffc";
    private final String decoded = "Illegal: \u0000 \b \u0010 \u000b \u001f \ufffe \\";
    private final String encoded = "Illegal: \\u0000 \\u0008 \\u0010 \\u000B \\u001F \\uFFFE \\\\";

    private String createTestString() {
        StringBuilder builder = new StringBuilder();
        for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            if (c >= '\ud801' && c <= '\udbff') continue;
            builder.append(c);
        }
        return builder.append('\uffff').toString();
    }

    public void testUnicodeDecoding() throws Exception {
        XmlUtils xu = new XmlUtils();
        XmlUtilsTest.assertEquals((String)"legal:   \ufffc", (String)xu.unicodeDecode("legal:   \ufffc"));
        XmlUtilsTest.assertEquals((String)"Illegal: \u0000 \b \u0010 \u000b \u001f \ufffe \\", (String)xu.unicodeDecode("Illegal: \\u0000 \\u0008 \\u0010 \\u000B \\u001F \\uFFFE \\\\"));
        XmlUtilsTest.assertNull((Object)xu.unicodeDecode(null));
    }

    public void testUnicodeEncoding() throws Exception {
        XmlUtils xu = new XmlUtils();
        XmlUtilsTest.assertEquals((String)"legal:   \ufffc", (String)xu.unicodeEncode("legal:   \ufffc"));
        XmlUtilsTest.assertEquals((String)"Illegal: \\u0000 \\u0008 \\u0010 \\u000B \\u001F \\uFFFE \\\\", (String)xu.unicodeEncode("Illegal: \u0000 \b \u0010 \u000b \u001f \ufffe \\"));
        XmlUtilsTest.assertNull((Object)xu.unicodeEncode(null));
    }

    public void testCodec() throws Exception {
        XmlUtils xu = new XmlUtils();
        String encoded = xu.unicodeEncode(this.createTestString());
        String decoded = xu.unicodeDecode(encoded);
        XmlUtilsTest.assertEquals((String)this.createTestString(), (String)decoded);
    }
}

