/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.VersionNumber;
import junit.framework.TestCase;

public class VersionNumberTest
extends TestCase {
    public void testParseValidVersion() {
        VersionNumber version = new VersionNumber("1.6.0.m5");
        VersionNumberTest.assertEquals((int)1, (int)version.getMajor());
        VersionNumberTest.assertEquals((int)6, (int)version.getMinor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMaintenance());
        version = new VersionNumber("1.6.0.m5.p1");
        VersionNumberTest.assertEquals((int)1, (int)version.getMajor());
        VersionNumberTest.assertEquals((int)6, (int)version.getMinor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMaintenance());
        version = new VersionNumber("1.6.0");
        VersionNumberTest.assertEquals((int)1, (int)version.getMajor());
        VersionNumberTest.assertEquals((int)6, (int)version.getMinor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMaintenance());
        version = new VersionNumber("1.6.0.");
        VersionNumberTest.assertEquals((int)1, (int)version.getMajor());
        VersionNumberTest.assertEquals((int)6, (int)version.getMinor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMaintenance());
        version = new VersionNumber("1");
        VersionNumberTest.assertEquals((int)1, (int)version.getMajor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMinor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMaintenance());
        version = new VersionNumber("");
        VersionNumberTest.assertEquals((int)0, (int)version.getMajor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMinor());
        VersionNumberTest.assertEquals((int)0, (int)version.getMaintenance());
    }

    public void testParseInvalidVersion() {
        try {
            new VersionNumber("sdf");
            VersionNumberTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VersionNumber("1.sdf");
            VersionNumberTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VersionNumber("1..1");
            VersionNumberTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VersionNumber("1.2..");
            VersionNumberTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VersionNumber("1.2.A345");
            VersionNumberTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCompareAndEquals() {
        VersionNumber num = new VersionNumber("2.2.2");
        VersionNumberTest.assertTrue((num.compareTo(new VersionNumber("2.2.2")) == 0 ? 1 : 0) != 0);
        VersionNumberTest.assertEquals((Object)num, (Object)new VersionNumber("2.2.2"));
        VersionNumberTest.assertEquals((int)num.hashCode(), (int)new VersionNumber("2.2.2").hashCode());
        VersionNumberTest.assertTrue((num.compareTo(new VersionNumber("2.2.2.m5")) == 0 ? 1 : 0) != 0);
        VersionNumberTest.assertTrue((num.compareTo(new VersionNumber("2.2.1")) > 0 ? 1 : 0) != 0);
        VersionNumberTest.assertFalse((boolean)num.equals((Object)new VersionNumber("2.2.1")));
        VersionNumberTest.assertTrue((num.compareTo(new VersionNumber("2.2")) > 0 ? 1 : 0) != 0);
        VersionNumberTest.assertFalse((boolean)num.equals((Object)new VersionNumber("2.2")));
    }

    public void testToString() {
        VersionNumberTest.assertTrue((boolean)"1.6.0".equals(new VersionNumber("1.6.0").toString()));
        VersionNumberTest.assertTrue((boolean)"1.6.0".equals(new VersionNumber("1.6.0.m5").toString()));
        VersionNumberTest.assertTrue((boolean)"1.6.0".equals(new VersionNumber("1.6").toString()));
        VersionNumberTest.assertTrue((boolean)"1.0.0".equals(new VersionNumber("1").toString()));
    }

    public void testToInteger() {
        VersionNumberTest.assertEquals((int)1002003, (int)new VersionNumber("1.2.3-123XYZ").toInteger());
        VersionNumberTest.assertEquals((int)1002034, (int)new VersionNumber("1.2.34").toInteger());
        VersionNumberTest.assertEquals((int)0x3B8B883B, (int)new VersionNumber("999.0.123").toInteger());
    }
}

