/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigMockery;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.util.UrlUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class UrlUtilsTest {
    @Test
    public void testParseBasicUrl() {
        UrlUtils.UrlDetails details = UrlUtils.parse((String)"http://www.google.com:80/?q=daily%20wtf");
        Assert.assertEquals((Object)"http://", (Object)details.protocol);
        Assert.assertNull((Object)details.username);
        Assert.assertNull((Object)details.password);
        Assert.assertEquals((Object)"www.google.com:80/?q=daily%20wtf", (Object)details.simpleUrl);
    }

    @Test
    public void testParseUrlWithUsername() {
        UrlUtils.UrlDetails details = UrlUtils.parse((String)"https://who@youknowit.com/bla");
        Assert.assertEquals((Object)"https://", (Object)details.protocol);
        Assert.assertEquals((Object)"who", (Object)details.username);
        Assert.assertNull((Object)details.password);
        Assert.assertEquals((Object)"youknowit.com/bla", (Object)details.simpleUrl);
    }

    @Test
    public void testParseUrlWithUsenameAndPassword() {
        UrlUtils.UrlDetails details = UrlUtils.parse((String)"https://who:password@youknowit.com/bla");
        Assert.assertEquals((Object)"https://", (Object)details.protocol);
        Assert.assertEquals((Object)"who", (Object)details.username);
        Assert.assertEquals((Object)"password", (Object)details.password);
        Assert.assertEquals((Object)"youknowit.com/bla", (Object)details.simpleUrl);
    }

    @Test
    public void testParseNonStandardProtocol() {
        UrlUtils.UrlDetails details = UrlUtils.parse((String)"woot://who:me@atlassian.com");
        Assert.assertEquals((Object)"woot://", (Object)details.protocol);
        Assert.assertEquals((Object)"who", (Object)details.username);
        Assert.assertEquals((Object)"me", (Object)details.password);
        Assert.assertEquals((Object)"atlassian.com", (Object)details.simpleUrl);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalUrl() {
        UrlUtils.parse((String)"not a url at all");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUrlWithoutProtocol() {
        UrlUtils.parse((String)"www.google.com");
    }

    @Test
    public void testAddAuthentication() {
        String expected = "http://who:me@areyoutalkingtome.com:80/what?q=doyouwant";
        Assert.assertEquals((Object)expected, (Object)UrlUtils.addAuthentication((String)"http://areyoutalkingtome.com:80/what?q=doyouwant", (String)"who", (String)"me"));
        Assert.assertEquals((Object)"http://areyoutalkingtome.com:80/what?q=doyouwant", (Object)UrlUtils.addAuthentication((String)"http://areyoutalkingtome.com:80/what?q=doyouwant", null, null));
        Assert.assertEquals((Object)expected, (Object)UrlUtils.addAuthentication((String)"http://who:me@areyoutalkingtome.com:80/what?q=doyouwant", null, null));
        Assert.assertEquals((Object)expected, (Object)UrlUtils.addAuthentication((String)"http://no:you@areyoutalkingtome.com:80/what?q=doyouwant", (String)"who", (String)"me"));
        Assert.assertEquals((Object)expected, (Object)UrlUtils.addAuthentication((String)"http://someone@areyoutalkingtome.com:80/what?q=doyouwant", (String)"who", (String)"me"));
    }

    @Test
    public void testAddPort() throws Exception {
        Assert.assertEquals((Object)"http://localhost:42", (Object)UrlUtils.addPort((String)"http://localhost", (int)42));
        Assert.assertEquals((Object)"http://localhost:42", (Object)UrlUtils.addPort((String)"http://localhost:6060", (int)42));
        Assert.assertEquals((Object)"http://localhost:42/", (Object)UrlUtils.addPort((String)"http://localhost/", (int)42));
        Assert.assertEquals((Object)"http://localhost:42/", (Object)UrlUtils.addPort((String)"http://localhost:6060/", (int)42));
        Assert.assertEquals((Object)"http://localhost:42/foo", (Object)UrlUtils.addPort((String)"http://localhost/foo", (int)42));
        Assert.assertEquals((Object)"http://localhost:42/foo", (Object)UrlUtils.addPort((String)"http://localhost:6060/foo", (int)42));
        Assert.assertEquals((Object)"http://user@localhost:42", (Object)UrlUtils.addPort((String)"http://user@localhost", (int)42));
        Assert.assertEquals((Object)"http://user@localhost:42", (Object)UrlUtils.addPort((String)"http://user@localhost:6060", (int)42));
        Assert.assertEquals((Object)"http://user@localhost:42/foo", (Object)UrlUtils.addPort((String)"http://user@localhost/foo", (int)42));
        Assert.assertEquals((Object)"http://user@localhost:42/foo", (Object)UrlUtils.addPort((String)"http://user@localhost:6060/foo", (int)42));
        Assert.assertEquals((Object)"http://user:pass@localhost:42", (Object)UrlUtils.addPort((String)"http://user:pass@localhost", (int)42));
        Assert.assertEquals((Object)"http://user:pass@localhost:42", (Object)UrlUtils.addPort((String)"http://user:pass@localhost:6060", (int)42));
        Assert.assertEquals((Object)"http://user:pass@localhost:42/foo", (Object)UrlUtils.addPort((String)"http://user:pass@localhost/foo", (int)42));
        Assert.assertEquals((Object)"http://user:pass@localhost:42/foo", (Object)UrlUtils.addPort((String)"http://user:pass@localhost:6060/foo", (int)42));
        try {
            UrlUtils.addPort((String)"test.url", (int)42);
            Assert.fail((String)"URL is invalid. UrlUtils.addPort should have failed.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("test.url"));
        }
    }

    @Test
    public void testRemovePort() throws Exception {
        Assert.assertEquals((Object)"http://localhost", (Object)UrlUtils.removePort((String)"http://localhost"));
        Assert.assertEquals((Object)"http://localhost", (Object)UrlUtils.removePort((String)"http://localhost:42"));
        Assert.assertEquals((Object)"http://localhost", (Object)UrlUtils.removePort((String)"http://localhost:6060"));
        Assert.assertEquals((Object)"http://localhost/", (Object)UrlUtils.removePort((String)"http://localhost:42/"));
        Assert.assertEquals((Object)"http://localhost/", (Object)UrlUtils.removePort((String)"http://localhost:6060/"));
        Assert.assertEquals((Object)"http://localhost/foo", (Object)UrlUtils.removePort((String)"http://localhost:42/foo"));
        Assert.assertEquals((Object)"http://user@localhost", (Object)UrlUtils.removePort((String)"http://user@localhost:42"));
        Assert.assertEquals((Object)"http://user@localhost/", (Object)UrlUtils.removePort((String)"http://user@localhost:42/"));
        Assert.assertEquals((Object)"http://user@localhost/foo", (Object)UrlUtils.removePort((String)"http://user@localhost:42/foo"));
        Assert.assertEquals((Object)"http://user:pass@localhost", (Object)UrlUtils.removePort((String)"http://user:pass@localhost:42"));
        Assert.assertEquals((Object)"http://user:pass@localhost/", (Object)UrlUtils.removePort((String)"http://user:pass@localhost:42/"));
        Assert.assertEquals((Object)"http://user:pass@localhost/foo", (Object)UrlUtils.removePort((String)"http://user:pass@localhost:42/foo"));
        try {
            UrlUtils.removePort((String)"test.url");
            Assert.fail((String)"URL is invalid. UrlUtils.removePort should have failed.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("test.url"));
        }
    }

    @Test
    public void testObfuscatePasswordsInString() {
        String example = "this is an \t example test with some http://your:password@secret.com/bla passwords in the url\nlet's try to add another line with http://more:secrets@secretstuff.com/in/it and see what happens\t\nthis:should not be replaces I guess";
        String expected = "this is an \t example test with some http://your:XXXX@secret.com/bla passwords in the url\nlet's try to add another line with http://more:XXXX@secretstuff.com/in/it and see what happens\t\nthis:should not be replaces I guess";
        Assert.assertEquals((Object)expected, (Object)UrlUtils.obfucscatePasswordsInString((String)example));
    }

    @Test
    public void testUsernameAndPasswordUrlEscaped() {
        Assert.assertEquals((Object)"http://username%21%23:password%21%23@areyoutalkingtome.com:80/what?q=doyouwant", (Object)UrlUtils.addAuthentication((String)"http://areyoutalkingtome.com:80/what?q=doyouwant", (String)"username!#", (String)"password!#"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSiteUrl() throws Exception {
        CrucibleFilter.Context priorContext = CrucibleFilter.hasContext() ? CrucibleFilter.getContext() : null;
        RootConfig priorConfig = AppConfig.getsConfig();
        try {
            HttpServletRequest request = this.mockRequest();
            CrucibleFilter.setContext((CrucibleFilter.Context)new CrucibleFilter.Context((ServletRequest)request, null));
            AppConfig.resetConfig(null);
            Assert.assertEquals((Object)"http://test/path", (Object)UrlUtils.getSiteUrl());
            CrucibleFilter.setContext(null);
            AppConfig.resetConfig((RootConfig)this.mockConfig());
            Assert.assertEquals((Object)"http://localhost", (Object)UrlUtils.getSiteUrl());
        }
        finally {
            CrucibleFilter.setContext((CrucibleFilter.Context)priorContext);
            AppConfig.resetConfig((RootConfig)priorConfig);
        }
    }

    private HttpServletRequest mockRequest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"test");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)80);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"path");
        return request;
    }

    private RootConfig mockConfig() {
        return ConfigMockery.mockRootConfig();
    }
}

