/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.SessionState;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.user.UserManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hibernate.Session;
import org.mockito.Mockito;

public class TestUtil {
    public static void writeToFile(File dest, String s) throws IOException {
        if (s == null) {
            return;
        }
        FileWriter out = new FileWriter(dest);
        out.write(s);
        out.close();
    }

    public static void writeToFile(File aFile, String[] aLines) throws IOException {
        FileWriter out = new FileWriter(aFile);
        for (String line : aLines) {
            out.write(line);
            out.write("\n");
        }
        out.close();
    }

    public static void assertRegex(Pattern pattern, boolean matches, String ... strings) {
        for (String s : strings) {
            Assert.assertEquals((boolean)matches, (boolean)pattern.matcher(s).find());
        }
    }

    public static void assertRegexMatches(Pattern pattern, String ... strings) {
        TestUtil.assertRegex(pattern, true, strings);
    }

    public static void assertRegexFails(Pattern pattern, String ... strings) {
        TestUtil.assertRegex(pattern, false, strings);
    }

    @Deprecated
    public static void addFisheyeUser(String username, String displayName, String email) throws Exception {
        UserManager um = AppConfig.getsConfig().getUserManager();
        if (um.existsLicensedUser(username)) {
            return;
        }
        um.addUser(username, displayName, email, username, false);
    }

    public static void setStaticFinalField(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    public static void mockHibernateUtilSession(Session session) throws Exception {
        MatcherAssert.assertThat((String)"Session can't be null for the mocking to work", (Object)session, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((String)"Session#isOpen must return true for the mocking to work", (Object)session.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        SessionState sessionState = (SessionState)Mockito.mock(SessionState.class);
        ThreadLocal sessionStateThreadLocal = (ThreadLocal)Mockito.mock(ThreadLocal.class);
        Mockito.when((Object)sessionState.getSession()).thenReturn((Object)session);
        Mockito.when(sessionStateThreadLocal.get()).thenReturn((Object)sessionState);
        TestUtil.setStaticFinalField(HibernateUtil.class.getDeclaredField("threadSessionState"), sessionStateThreadLocal);
    }

    public static void restoreHibernateUtilSession() throws Exception {
        TestUtil.setStaticFinalField(HibernateUtil.class.getDeclaredField("threadSessionState"), new ThreadLocal());
    }
}

