/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.StringUtil;
import junit.framework.TestCase;

public class StringUtilTest
extends TestCase {
    private static final String test = "0123456 89012\t4567890\r\n34567890";

    public void testNearestWhiteSpaceBefore() {
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.nearestWhiteSpaceBefore((String)test, (int)6));
        StringUtilTest.assertEquals((int)7, (int)StringUtil.nearestWhiteSpaceBefore((String)test, (int)10));
        StringUtilTest.assertEquals((int)13, (int)StringUtil.nearestWhiteSpaceBefore((String)test, (int)17));
        StringUtilTest.assertEquals((int)22, (int)StringUtil.nearestWhiteSpaceBefore((String)test, (int)25));
        StringUtilTest.assertEquals((int)22, (int)StringUtil.nearestWhiteSpaceBefore((String)test, (int)30));
        StringUtilTest.assertEquals((int)22, (int)StringUtil.nearestWhiteSpaceBefore((String)test, (int)31));
    }

    public void testNearestWhiteSpaceAfter() {
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.nearestWhiteSpaceAfter((String)test, (int)26));
        StringUtilTest.assertEquals((int)7, (int)StringUtil.nearestWhiteSpaceAfter((String)test, (int)3));
        StringUtilTest.assertEquals((int)13, (int)StringUtil.nearestWhiteSpaceAfter((String)test, (int)10));
        StringUtilTest.assertEquals((int)21, (int)StringUtil.nearestWhiteSpaceAfter((String)test, (int)15));
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.nearestWhiteSpaceAfter((String)test, (int)30));
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.nearestWhiteSpaceAfter((String)test, (int)31));
    }

    public void testIndexOfEOL() {
        StringUtilTest.assertEquals((int)21, (int)StringUtil.indexOfEOL((String)test));
    }

    public void testFirstLineOf() {
        String result = StringUtil.firstLineOf((String)test, (int)-1, (boolean)false, (boolean)false, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456 89012\t4567890", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)-1, (boolean)false, (boolean)false, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456 89012\t4567890", (String)result);
        result = StringUtil.firstLineOf((String)"hello", (int)-1, (boolean)false, (boolean)false, (boolean)true);
        StringUtilTest.assertEquals((String)"hello", (String)result);
        result = StringUtil.firstLineOf((String)"0123456789 123456789", (int)24, (boolean)false, (boolean)false, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456789 123456789", (String)result);
        result = StringUtil.firstLineOf((String)"0123456789 123456789", (int)24, (boolean)false, (boolean)false, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456789 123456789", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)27, (boolean)false, (boolean)false, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456 89012\t4567890", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)27, (boolean)false, (boolean)false, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456 89012\t4567890", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)19, (boolean)false, (boolean)false, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456 89012\t45678", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)19, (boolean)false, (boolean)false, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456 89012\t45678...", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)19, (boolean)false, (boolean)true, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456 89012\t4567890", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)19, (boolean)false, (boolean)true, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456 89012\t4567890...", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)15, (boolean)false, (boolean)true, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456 89012", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)15, (boolean)false, (boolean)true, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456 89012...", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)19, (boolean)true, (boolean)true, (boolean)false);
        StringUtilTest.assertEquals((String)"0123456 89012", (String)result);
        result = StringUtil.firstLineOf((String)test, (int)19, (boolean)true, (boolean)true, (boolean)true);
        StringUtilTest.assertEquals((String)"0123456 89012...", (String)result);
    }

    public void testMiddleTruncation() {
        String result = StringUtil.abbreviateText((String)"123456789", (int)3, (int)3);
        StringUtilTest.assertEquals((String)"123456789", (String)result);
        result = StringUtil.abbreviateText((String)"1234567890", (int)3, (int)3);
        StringUtilTest.assertEquals((String)"123...890", (String)result);
        result = StringUtil.abbreviateText((String)"1234567890", (int)0, (int)3);
        StringUtilTest.assertEquals((String)"...890", (String)result);
        result = StringUtil.abbreviateText((String)"1234567890", (int)3, (int)0);
        StringUtilTest.assertEquals((String)"123...", (String)result);
        result = StringUtil.abbreviateText((String)"12", (int)3, (int)3);
        StringUtilTest.assertEquals((String)"12", (String)result);
        result = StringUtil.abbreviateText((String)"1234", (int)3, (int)3);
        StringUtilTest.assertEquals((String)"1234", (String)result);
        result = StringUtil.abbreviateText((String)"1234", (int)-1, (int)-1);
        StringUtilTest.assertEquals((String)"1234", (String)result);
        result = StringUtil.abbreviateText((String)"12 345678\t90", (int)3, (int)3);
        StringUtilTest.assertEquals((String)"12 ...\t90", (String)result);
        result = StringUtil.abbreviateText((String)"12 345678\t90", (int)0, (int)0);
        StringUtilTest.assertEquals((String)"...", (String)result);
    }

    public void testEqualsWithNullAsEmpty() {
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty(null, (String)""));
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty((String)"", null));
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty(null, (String)""));
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty(null, null));
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty((String)"", (String)""));
        StringUtilTest.assertFalse((boolean)StringUtil.equalsWithNullsAsEmpty((String)" ", null));
        StringUtilTest.assertFalse((boolean)StringUtil.equalsWithNullsAsEmpty(null, (String)" "));
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty((String)" ", (String)" "));
        StringUtilTest.assertFalse((boolean)StringUtil.equalsWithNullsAsEmpty((String)"Foo", (String)"Bar"));
        StringUtilTest.assertTrue((boolean)StringUtil.equalsWithNullsAsEmpty((String)"Foo", (String)"Foo"));
        StringUtilTest.assertFalse((boolean)StringUtil.equalsWithNullsAsEmpty((String)"Foo", null));
        StringUtilTest.assertFalse((boolean)StringUtil.equalsWithNullsAsEmpty((String)"", (String)"Foo"));
        StringUtilTest.assertFalse((boolean)StringUtil.equalsWithNullsAsEmpty((String)"Foo", (String)""));
    }
}

