/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.fisheye.util.RevisionDateRange;
import com.infinitydb.Cu;
import com.infinitydb.InfinityDB;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RevisionDateRangeTest {
    private File tmpDbFile;

    public static void writeLegacyToCursor(MinMaxLongRange minMaxLongRange, Cu cu) {
        cu.append(minMaxLongRange.isSet());
        cu.append(minMaxLongRange.getMin());
        cu.append(minMaxLongRange.getMax());
    }

    public static MinMaxLongRange readLegacyFromCursor(Cu cu, int off) {
        boolean set = cu.booleanAt(off);
        off = cu.skipBoolean(off);
        if (set) {
            long min = cu.longAt(off);
            off = cu.skipLong(off);
            long max = cu.longAt(off);
            cu.skipLong(off);
            return new MinMaxLongRange(min, max);
        }
        return new MinMaxLongRange();
    }

    @Before
    public void setup() throws IOException {
        this.tmpDbFile = File.createTempFile(this.getClass().getSimpleName(), ".db");
    }

    @After
    public void tearDown() {
        if (this.tmpDbFile != null) {
            this.tmpDbFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWriteMinMaxLongRange() throws IOException {
        InfinityDB db = InfinityDB.create((String)this.tmpDbFile.getAbsolutePath(), (boolean)false);
        MinMaxLongRange empty = new MinMaxLongRange();
        Assert.assertFalse((String)"Expecting range to be unset", (boolean)empty.isSet());
        Cu cu = Cu.alloc();
        try {
            RevisionDateRangeTest.writeLegacyToCursor(empty, cu);
            db.insert(cu);
            cu.clear();
            Assert.assertTrue((String)"Expecting to find element in db", (boolean)db.next(cu));
            MinMaxLongRange legacyRead = RevisionDateRangeTest.readLegacyFromCursor(cu, 0);
            Assert.assertEquals((String)"Expecting read value to equal written", (Object)empty, (Object)legacyRead);
            cu.clear();
            RevisionDateRange read = new RevisionDateRange();
            db.next(cu);
            read.readFromCursor(cu, 0);
            Assert.assertFalse((String)"Not expecting min/max data", (boolean)read.hasMinMax());
            Assert.assertFalse((String)"Not expecting revision data", (boolean)read.hasRevisionInfo());
            db.clear();
            cu.clear();
            legacyRead.add(5L);
            RevisionDateRangeTest.writeLegacyToCursor(legacyRead, cu);
            db.insert(cu);
            cu.clear();
            db.next(cu);
            MinMaxLongRange set = RevisionDateRangeTest.readLegacyFromCursor(cu, 0);
            Assert.assertTrue((String)"Expecting min/max data", (boolean)set.isSet());
            Assert.assertEquals((String)"Wrong min value", (long)5L, (long)set.getMin());
            Assert.assertEquals((String)"Wrong max value", (long)5L, (long)set.getMax());
            cu.clear();
            read = new RevisionDateRange();
            db.next(cu);
            read.readFromCursor(cu, 0);
            Assert.assertTrue((String)"Expecting min/max data", (boolean)read.hasMinMax());
            Assert.assertEquals((String)"Wrong min value", (Object)5L, (Object)read.getMin().get());
            Assert.assertEquals((String)"Wrong max value", (Object)5L, (Object)read.getMax().get());
            Assert.assertFalse((String)"Not expecting revision data", (boolean)read.hasRevisionInfo());
            read.update(6L, 1);
            Assert.assertTrue((String)"Expecting min/max data", (boolean)read.hasMinMax());
            Assert.assertEquals((String)"Wrong min value", (Object)5L, (Object)read.getMin().get());
            Assert.assertEquals((String)"Wrong max value", (Object)6L, (Object)read.getMax().get());
            Assert.assertFalse((String)"Not expecting min revision data", (boolean)read.hasMinRevisionInfo());
            Assert.assertTrue((String)"Expecting max revision data", (boolean)read.hasMaxRevisionInfo());
            Assert.assertEquals((String)"Wrong max rev value", (Object)new Integer(1), (Object)read.getMaxRevId());
            read.update(4L, 2);
            Assert.assertTrue((String)"Expecting min/max data", (boolean)read.hasMinMax());
            Assert.assertEquals((String)"Wrong min value", (Object)4L, (Object)read.getMin().get());
            Assert.assertEquals((String)"Wrong max value", (Object)6L, (Object)read.getMax().get());
            Assert.assertTrue((String)"Expecting revision data", (boolean)read.hasRevisionInfo());
            Assert.assertTrue((String)"Expecting min revision data", (boolean)read.hasMinRevisionInfo());
            Assert.assertTrue((String)"Expecting max revision data", (boolean)read.hasMaxRevisionInfo());
            Assert.assertEquals((String)"Wrong min rev value", (Object)new Integer(2), (Object)read.getMinRevId());
            Assert.assertEquals((String)"Wrong max rev value", (Object)new Integer(1), (Object)read.getMaxRevId());
            read.update(1L, 2);
            read.update(10L, 3);
            db.clear();
            cu.clear();
            read.writeToCursor(cu);
            db.insert(cu);
            cu.clear();
            db.next(cu);
            set = RevisionDateRangeTest.readLegacyFromCursor(cu, 0);
            Assert.assertTrue((String)"Expecting min/max data", (boolean)set.isSet());
            Assert.assertEquals((String)"Wrong min value", (long)1L, (long)set.getMin());
            Assert.assertEquals((String)"Wrong max value", (long)10L, (long)set.getMax());
            cu.clear();
            read = new RevisionDateRange();
            db.next(cu);
            read.readFromCursor(cu, 0);
            Assert.assertTrue((String)"Expecting min/max data", (boolean)read.hasMinMax());
            Assert.assertEquals((String)"Wrong min value", (Object)1L, (Object)read.getMin().get());
            Assert.assertEquals((String)"Wrong max value", (Object)10L, (Object)read.getMax().get());
            Assert.assertTrue((String)"Expecting revision data", (boolean)read.hasRevisionInfo());
            Assert.assertEquals((String)"Wrong min rev value", (Object)new Integer(2), (Object)read.getMinRevId());
            Assert.assertEquals((String)"Wrong max rev value", (Object)new Integer(3), (Object)read.getMaxRevId());
        }
        finally {
            cu.dispose();
        }
    }
}

