/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.rep.activity.ActivityLog;
import com.cenqua.fisheye.util.RecentHistory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class RecentHistoryTest
extends TestCase {
    public void testConstructor0Capacity() {
        try {
            RecentHistory history = new RecentHistory(0);
            RecentHistoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorMinus1Capacity() {
        try {
            RecentHistory history = new RecentHistory(-1);
            RecentHistoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertHistorySize(RecentHistory history, int numCurrent, int numArchived) {
        List items = history.getAllItems();
        List curItems = history.getCurrentItems();
        List archivedtems = history.getArchivedItems();
        RecentHistoryTest.assertEquals((int)(numCurrent + numArchived), (int)history.size());
        RecentHistoryTest.assertEquals((int)(numCurrent + numArchived), (int)items.size());
        RecentHistoryTest.assertEquals((int)numCurrent, (int)curItems.size());
        RecentHistoryTest.assertEquals((int)numArchived, (int)archivedtems.size());
    }

    private void assertHistoryContents(RecentHistory history, ActivityLog[] current, ActivityLog[] archived) {
        List<ActivityLog> expCur = Arrays.asList(current);
        List<ActivityLog> expArch = Arrays.asList(archived);
        ArrayList<ActivityLog> expAll = new ArrayList<ActivityLog>();
        expAll.addAll(expCur);
        expAll.addAll(expArch);
        RecentHistoryTest.assertEquals(expCur, (Object)history.getCurrentItems());
        RecentHistoryTest.assertEquals(expArch, (Object)history.getArchivedItems());
        RecentHistoryTest.assertEquals(expAll, (Object)history.getAllItems());
    }

    public void testGetRecentItemsEmpty() {
        RecentHistory history = new RecentHistory(1);
        this.assertHistorySize(history, 0, 0);
    }

    public void testAddOnly() {
        RecentHistory history = new RecentHistory(3);
        ActivityLog one = new ActivityLog("one");
        ActivityLog two = new ActivityLog("two");
        history.add(one);
        history.add(two);
        this.assertHistorySize(history, 2, 0);
        this.assertHistoryContents(history, new ActivityLog[]{two, one}, new ActivityLog[0]);
    }

    public void testAddAndArchive() {
        RecentHistory history = new RecentHistory(1);
        ActivityLog one = new ActivityLog("one");
        ActivityLog two = new ActivityLog("two");
        ActivityLog three = new ActivityLog("three");
        history.add(one);
        history.add(two);
        history.add(three);
        this.assertHistorySize(history, 3, 0);
        this.assertHistoryContents(history, new ActivityLog[]{three, two, one}, new ActivityLog[0]);
        history.archive(one);
        this.assertHistorySize(history, 2, 1);
        this.assertHistoryContents(history, new ActivityLog[]{three, two}, new ActivityLog[]{one});
        history.archive(three);
        this.assertHistorySize(history, 1, 1);
        this.assertHistoryContents(history, new ActivityLog[]{two}, new ActivityLog[]{three});
    }

    public void testArchiveNull() {
        RecentHistory history = new RecentHistory(1);
        ActivityLog one = new ActivityLog("one");
        history.add(one);
        try {
            history.archive(null);
            RecentHistoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testArchiveNonMember() {
        RecentHistory history = new RecentHistory(1);
        ActivityLog one = new ActivityLog("one");
        ActivityLog two = new ActivityLog("two");
        history.add(one);
        try {
            history.archive(two);
            RecentHistoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

