/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.extras.common.LicenseException;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.util.ProductUpdateInfo;
import com.cenqua.fisheye.util.ProductUpdateInfoParser;
import com.cenqua.fisheye.util.ProductUpdateParseException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.easymock.classextension.EasyMock;

public class ProductUpdateInfoParserTest
extends TestCase {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final long DAY = 86400000L;
    private Date now = null;
    private String xml = null;

    public void setUp() throws ParseException {
        this.now = this.formatter.parse("2008-08-25");
    }

    public void testConstructor() {
        try {
            new ProductUpdateInfoParser(null);
            ProductUpdateInfoParserTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new ProductUpdateInfoParser(new FisheyeVersionInfo());
    }

    public void testValidVersionInput() {
        ProductUpdateInfo pui;
        ProductUpdateInfoParser parser;
        FisheyeVersionInfo fvi;
        LicenseInfo li;
        Date nextMonth;
        try {
            nextMonth = new Date(this.now.getTime() + 2592000000L);
            li = (LicenseInfo)EasyMock.createMock(LicenseInfo.class);
            EasyMock.expect((Object)li.getLatestBuildAllowedValue()).andStubReturn((Object)new Date(this.now.getTime() + 31536000000L));
            fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
            EasyMock.expect((Object)fvi.getLicense()).andStubReturn((Object)li);
            EasyMock.replay((Object[])new Object[]{li});
            EasyMock.replay((Object[])new Object[]{fvi});
            parser = new ProductUpdateInfoParser(fvi);
            pui = parser.parse(String.format("<version>\n        <number>1.6.1.m6</number>\n        <downloadUrl>http://some/url</downloadUrl>\n        <buildDate>%s</buildDate>\n</version>", this.formatter.format(nextMonth)));
            ProductUpdateInfoParserTest.assertEquals((String)"1.6.1.m6", (String)pui.getVersion());
            ProductUpdateInfoParserTest.assertEquals((String)"http://some/url", (String)pui.getDownloadUrl());
            ProductUpdateInfoParserTest.assertEquals((Object)nextMonth, (Object)pui.getBuildDate());
            ProductUpdateInfoParserTest.assertFalse((boolean)pui.getNeedAdditionalMaintenance());
            EasyMock.verify((Object[])new Object[]{li});
            EasyMock.verify((Object[])new Object[]{fvi});
        }
        catch (LicenseException | ProductUpdateParseException e) {
            ProductUpdateInfoParserTest.fail();
        }
        try {
            nextMonth = new Date(this.now.getTime() + 2592000000L);
            li = (LicenseInfo)EasyMock.createMock(LicenseInfo.class);
            EasyMock.expect((Object)li.getLatestBuildAllowedValue()).andStubReturn((Object)this.now);
            fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
            EasyMock.expect((Object)fvi.getLicense()).andStubReturn((Object)li);
            EasyMock.replay((Object[])new Object[]{li});
            EasyMock.replay((Object[])new Object[]{fvi});
            parser = new ProductUpdateInfoParser(fvi);
            pui = parser.parse(String.format("<version>\n        <number>1.6.1.m6</number>\n        <downloadUrl>http://some/url</downloadUrl>\n        <buildDate>%s</buildDate>\n</version>", this.formatter.format(nextMonth)));
            ProductUpdateInfoParserTest.assertEquals((String)"1.6.1.m6", (String)pui.getVersion());
            ProductUpdateInfoParserTest.assertEquals((String)"http://some/url", (String)pui.getDownloadUrl());
            ProductUpdateInfoParserTest.assertEquals((Object)nextMonth, (Object)pui.getBuildDate());
            ProductUpdateInfoParserTest.assertTrue((boolean)pui.getNeedAdditionalMaintenance());
            EasyMock.verify((Object[])new Object[]{li});
            EasyMock.verify((Object[])new Object[]{fvi});
        }
        catch (LicenseException | ProductUpdateParseException e) {
            ProductUpdateInfoParserTest.fail();
        }
    }

    public void testInvalidXML() {
        try {
            Date nextMonth = new Date(this.now.getTime() + 2592000000L);
            LicenseInfo li = (LicenseInfo)EasyMock.createMock(LicenseInfo.class);
            EasyMock.expect((Object)li.getLatestBuildAllowedValue()).andStubReturn((Object)new Date(this.now.getTime() + 31536000000L));
            FisheyeVersionInfo fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
            EasyMock.expect((Object)fvi.getLicense()).andStubReturn((Object)li);
            EasyMock.replay((Object[])new Object[]{li});
            EasyMock.replay((Object[])new Object[]{fvi});
            ProductUpdateInfoParser parser = new ProductUpdateInfoParser(fvi);
            try {
                parser.parse("<dsf>fdgds");
                ProductUpdateInfoParserTest.fail();
            }
            catch (ProductUpdateParseException productUpdateParseException) {
                // empty catch block
            }
            try {
                parser.parse("<version>\n        <number>1.6.1.m6</number>\n        <downloadUrl>http://some/url</downloadUrl>\n        <buildDate>25/08/2008</buildDate>\n</version>");
                ProductUpdateInfoParserTest.fail();
            }
            catch (ProductUpdateParseException productUpdateParseException) {
                // empty catch block
            }
            try {
                parser.parse("<version>\n        <downloadUrl>http://some/url</downloadUrl>\n        <buildDate>2008-08-25</buildDate>\n</version>");
                ProductUpdateInfoParserTest.fail();
            }
            catch (ProductUpdateParseException productUpdateParseException) {
                // empty catch block
            }
            EasyMock.verify((Object[])new Object[]{li});
            EasyMock.verify((Object[])new Object[]{fvi});
        }
        catch (LicenseException e) {
            ProductUpdateInfoParserTest.fail();
        }
    }
}

