/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneConnectionTest {
    private static final LuceneIndexes INDEX = LuceneIndexes.activeValues()[0];
    private Analyzer mAnalyzer = new StandardAnalyzer(Version.LUCENE_29);
    private File mLocation;

    @Before
    public void setUp() throws Exception {
        this.mLocation = FisheyeTestUtil.createTempDir("crucibletest");
    }

    @Test
    public void testStuff() throws Exception {
        LuceneConnection conn = new LuceneConnection(this.mLocation, this.mAnalyzer, (LuceneConnection.IndexConfig[])LuceneIndexes.activeValues());
        conn.createIndexes();
        this.add((LuceneConnection<LuceneIndexes>)conn, "fred");
        this.assertNumberMatching((LuceneConnection<LuceneIndexes>)conn, "fred", 1);
        this.add((LuceneConnection<LuceneIndexes>)conn, "fred");
        this.assertNumberMatching((LuceneConnection<LuceneIndexes>)conn, "fred", 2);
        conn.close();
    }

    private void assertNumberMatching(LuceneConnection<LuceneIndexes> conn, String value, int expected) throws Exception {
        conn.withIndexSearcher((LuceneConnection.IndexConfig)INDEX, searcher -> {
            try {
                QueryParser parser = new QueryParser(Version.LUCENE_29, "body", this.mAnalyzer);
                TopDocs hits = searcher.search(parser.parse(value), 1000);
                Assert.assertEquals((long)expected, (long)hits.totalHits);
            }
            catch (ParseException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            return null;
        });
    }

    private void add(LuceneConnection<LuceneIndexes> conn, String value) throws Exception {
        conn.withWriter((LuceneConnection.IndexConfig)INDEX, writer -> {
            Document doc = new Document();
            doc.add((Fieldable)LuceneHelper.Text((String)"body", (String)value));
            writer.addDocument(doc);
            return null;
        });
    }
}

