/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.LargeNumberFormatter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class JfreeChartTester
extends ApplicationFrame {
    private Marker mMarker = null;
    private static final Color[] LINE_COLOURS = new Color[]{Color.MAGENTA, Color.YELLOW.darker(), Color.CYAN.darker()};

    public JfreeChartTester(String s) throws IOException {
        super(s);
        XYSeriesCollection datasets = new XYSeriesCollection();
        datasets.addSeries(this.createDataSeries("Hi", 100));
        datasets.addSeries(this.createDataSeries("Bye", 20));
        datasets.addSeries(this.createDataSeries("Yo", 50));
        JFreeChart chart = this.createChart(datasets);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    public static void main(String[] args) throws IOException {
        JfreeChartTester demo = new JfreeChartTester("JFREE CHART TEST");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    public String getImageContentType() {
        return "image/png";
    }

    private JFreeChart createChart(XYSeriesCollection datasets) throws IOException {
        DateAxis xAxis = new DateAxis("date");
        NumberAxis yAxis = new NumberAxis("L.O.C");
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart chart = ChartFactory.createXYStepAreaChart(null, null, null, (XYDataset)datasets, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainAxis((ValueAxis)xAxis);
        XYStepRenderer seriesRenderer = new XYStepRenderer();
        plot.setRenderer((XYItemRenderer)seriesRenderer);
        for (int i = 0; i < datasets.getSeriesCount(); ++i) {
            Color lineColour = LINE_COLOURS[i % LINE_COLOURS.length];
            seriesRenderer.setSeriesPaint(i, (Paint)lineColour);
            seriesRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(6.0f));
        }
        plot.setBackgroundPaint((Paint)Color.white);
        if (this.mMarker != null) {
            plot.addDomainMarker(this.mMarker, Layer.FOREGROUND);
        }
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        domainAxis.setLowerMargin(0.02);
        domainAxis.setUpperMargin(0.02);
        domainAxis.setAutoRange(true);
        domainAxis.setAutoTickUnitSelection(true);
        domainAxis.setTickUnit(new DateTickUnit(2, 4), true, false);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits((TickUnitSource)new EngineeringNumberTickUnits());
        chart.setPadding(new RectangleInsets(1.0, 1.0, 1.0, 15.0));
        return chart;
    }

    private XYSeries createDataSeries(String name, int base) throws IOException {
        XYSeries xySeries = new XYSeries((Comparable)((Object)name));
        Calendar cal = Calendar.getInstance();
        xySeries.add((double)cal.getTimeInMillis(), (double)(base * 2));
        cal.add(5, 1);
        xySeries.add((double)cal.getTimeInMillis(), (double)(base * 5));
        cal.add(5, 1);
        xySeries.add((double)cal.getTimeInMillis(), (double)(base * 8));
        cal.add(5, 1);
        xySeries.add((double)cal.getTimeInMillis(), (double)(base * 9));
        return xySeries;
    }

    public void addDateRangeMarker(long d1, long d2, Color colour) {
        this.mMarker = new IntervalMarker((double)d1, (double)d2, (Paint)colour, (Stroke)new BasicStroke(1.0f), null, null, 0.01f);
    }

    public static class EngineeringNumberTickUnits
    implements TickUnitSource {
        private static final double LOG_10_VALUE = Math.log(10.0);

        public TickUnit getLargerTickUnit(TickUnit unit) {
            double x = unit.getSize();
            double log = Math.log(x) / LOG_10_VALUE;
            double higher = Math.ceil(log);
            return new EngineeringNumberTickUnit(Math.pow(10.0, higher));
        }

        public TickUnit getCeilingTickUnit(TickUnit unit) {
            return this.getLargerTickUnit(unit);
        }

        public TickUnit getCeilingTickUnit(double v) {
            double log = Math.log(v) / LOG_10_VALUE;
            double higher = Math.ceil(log);
            return new EngineeringNumberTickUnit(Math.pow(10.0, higher));
        }
    }

    public static class EngineeringNumberTickUnit
    extends NumberTickUnit {
        DecimalFormat df = new DecimalFormat("0.###");

        public EngineeringNumberTickUnit(double v) {
            super(v);
        }

        public EngineeringNumberTickUnit(double v, DecimalFormat numberFormat) {
            super(v);
            this.df = numberFormat;
        }

        public String valueToString(double value) {
            return LargeNumberFormatter.formatValue((DecimalFormat)this.df, (double)value);
        }
    }
}

