/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.JDBCHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class JDBCHelperTest {
    private ResultSet rs = null;
    private Statement statement = null;
    private Connection connection = null;

    @Before
    public void setUp() throws Exception {
        this.rs = (ResultSet)EasyMock.createMock(ResultSet.class);
        this.rs.close();
        EasyMock.expectLastCall().andThrow((Throwable)new SQLException());
        this.statement = (Statement)EasyMock.createMock(Statement.class);
        this.statement.close();
        EasyMock.expectLastCall().andThrow((Throwable)new SQLException());
        this.connection = (Connection)EasyMock.createMock(Connection.class);
        this.connection.close();
        EasyMock.expectLastCall().andThrow((Throwable)new SQLException());
        EasyMock.replay((Object[])new Object[]{this.rs, this.statement, this.connection});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.rs, this.statement, this.connection});
    }

    @Test
    public void testSingleMethods() {
        JDBCHelper.closeQuietly((Connection)this.connection);
        JDBCHelper.closeQuietly((Connection)null);
        JDBCHelper.closeQuietly((Statement)this.statement);
        JDBCHelper.closeQuietly((Statement)null);
        JDBCHelper.closeQuietly((ResultSet)this.rs);
        JDBCHelper.closeQuietly((ResultSet)null);
    }

    @Test
    public void testAggregatedMethods() {
        JDBCHelper.closeQuietly((ResultSet)this.rs, (Statement)this.statement, (Connection)this.connection);
        JDBCHelper.closeQuietly(null, null, null);
    }
}

