/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class ISO8601DateHelperTest
extends TestCase {
    private final TimeZone utc = TimeZone.getTimeZone("GMT");
    private final DateFormat formatter = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm aaa");

    public void testImplicitLocaltime() throws Exception {
        GregorianCalendar expected = new GregorianCalendar();
        expected.clear();
        expected.set(1994, 10, 5, 8, 15, 30);
        Date d1 = ISO8601DateHelper.parseAsTimeZone((String)"1994-11-05T08:15:30", (TimeZone)AppConfig.getsConfig().getTimezone());
        ISO8601DateHelperTest.assertEquals((Object)expected.getTime(), (Object)d1);
    }

    public void testParsing_NOTE_datetime_19980827() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(TimeZone.getTimeZone("GMT-05:00"));
        expected.clear();
        expected.set(1994, 10, 5, 8, 15, 30);
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"1994-11-05T13:15:30Z");
        ISO8601DateHelperTest.assertEquals((Object)expected.getTime(), (Object)d1);
        Date d2 = ISO8601DateHelper.parseAsTimeZone((String)"1994-11-05T13:15:30Z", (TimeZone)AppConfig.getsConfig().getTimezone());
        ISO8601DateHelperTest.assertEquals((Object)expected.getTime(), (Object)d2);
        Date d3 = ISO8601DateHelper.parseAsUTC((String)"1994-11-05T08:15:30-05:00");
        ISO8601DateHelperTest.assertEquals((Object)expected.getTime(), (Object)d3);
    }

    public void testParsing_TN2004121510000085() throws Exception {
        GregorianCalendar expected = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        expected.clear();
        expected.set(1998, 6, 17, 14, 8, 55);
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"19980717T14:08:55");
        ISO8601DateHelperTest.assertEquals((Object)expected.getTime(), (Object)d1);
    }

    public void testToString_TN2004121510000085() throws Exception {
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.clear();
        date.set(1998, 6, 17, 14, 8, 55);
        ISO8601DateHelperTest.assertEquals((String)"19980717T14:08:55", (String)ISO8601DateHelper.toXmlRpcDate((Date)date.getTime()));
    }

    private void assertWorkingDaysAdded(Date startDate, int daysToAdd, Date expected) {
        this.formatter.setTimeZone(this.utc);
        Date actual = ISO8601DateHelper.addWorkingDays((Date)startDate, (int)daysToAdd, (TimeZone)this.utc);
        ISO8601DateHelperTest.assertEquals((String)String.format("Added %d days and expected %s, Got: %s", daysToAdd, this.formatter.format(expected), this.formatter.format(actual)), (Object)expected, (Object)actual);
    }

    public void testAddWorkingDaysPositive() throws Exception {
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"2009-03-18T13:15:30Z");
        this.assertWorkingDaysAdded(d1, 1, ISO8601DateHelper.parseAsUTC((String)"2009-03-19T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, 3, ISO8601DateHelper.parseAsUTC((String)"2009-03-23T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, 5, ISO8601DateHelper.parseAsUTC((String)"2009-03-25T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, 10, ISO8601DateHelper.parseAsUTC((String)"2009-04-01T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, 17, ISO8601DateHelper.parseAsUTC((String)"2009-04-10T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, 18, ISO8601DateHelper.parseAsUTC((String)"2009-04-13T13:15:30Z"));
    }

    public void testAddWorkingDaysNegative() throws Exception {
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"2009-03-18T13:15:30Z");
        this.assertWorkingDaysAdded(d1, -1, ISO8601DateHelper.parseAsUTC((String)"2009-03-17T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, -3, ISO8601DateHelper.parseAsUTC((String)"2009-03-13T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, -5, ISO8601DateHelper.parseAsUTC((String)"2009-03-11T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, -10, ISO8601DateHelper.parseAsUTC((String)"2009-03-04T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, -17, ISO8601DateHelper.parseAsUTC((String)"2009-02-23T13:15:30Z"));
        this.assertWorkingDaysAdded(d1, -18, ISO8601DateHelper.parseAsUTC((String)"2009-02-20T13:15:30Z"));
    }

    public void testAddWorkingDaysZero() throws Exception {
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"2009-03-18T13:15:30Z");
        this.assertWorkingDaysAdded(d1, 0, d1);
    }

    private void assertReturnsElapsedWorkingDays(Date startDate, int expected, Date endDate) {
        this.formatter.setTimeZone(this.utc);
        int actual = ISO8601DateHelper.getElapsedWorkingDays((Date)startDate, (Date)endDate, (TimeZone)this.utc);
        ISO8601DateHelperTest.assertEquals((String)String.format("Expected %d days between %s and %s, Got: %d", expected, this.formatter.format(startDate), this.formatter.format(endDate), actual), (int)expected, (int)actual);
    }

    public void testGetElapsedWorkingDaysPositive() throws Exception {
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"2009-03-18T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d1, 1, ISO8601DateHelper.parseAsUTC((String)"2009-03-19T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, 3, ISO8601DateHelper.parseAsUTC((String)"2009-03-23T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, 5, ISO8601DateHelper.parseAsUTC((String)"2009-03-25T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, 10, ISO8601DateHelper.parseAsUTC((String)"2009-04-01T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, 17, ISO8601DateHelper.parseAsUTC((String)"2009-04-10T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, 18, ISO8601DateHelper.parseAsUTC((String)"2009-04-13T13:15:30Z"));
        Date d2 = ISO8601DateHelper.parseAsUTC((String)"2009-03-21T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d2, 1, ISO8601DateHelper.parseAsUTC((String)"2009-03-24T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d2, 6, ISO8601DateHelper.parseAsUTC((String)"2009-03-31T13:15:30Z"));
        Date d3 = ISO8601DateHelper.parseAsUTC((String)"2009-03-22T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d3, 1, ISO8601DateHelper.parseAsUTC((String)"2009-03-24T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d3, 6, ISO8601DateHelper.parseAsUTC((String)"2009-03-31T13:15:30Z"));
    }

    public void testGetElapsedWorkingDaysNegative() throws Exception {
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"2009-03-18T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d1, -1, ISO8601DateHelper.parseAsUTC((String)"2009-03-17T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, -3, ISO8601DateHelper.parseAsUTC((String)"2009-03-13T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, -5, ISO8601DateHelper.parseAsUTC((String)"2009-03-11T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, -10, ISO8601DateHelper.parseAsUTC((String)"2009-03-04T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, -17, ISO8601DateHelper.parseAsUTC((String)"2009-02-23T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d1, -18, ISO8601DateHelper.parseAsUTC((String)"2009-02-20T13:15:30Z"));
        Date d2 = ISO8601DateHelper.parseAsUTC((String)"2009-03-21T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d2, -1, ISO8601DateHelper.parseAsUTC((String)"2009-03-19T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d2, -6, ISO8601DateHelper.parseAsUTC((String)"2009-03-12T13:15:30Z"));
        Date d3 = ISO8601DateHelper.parseAsUTC((String)"2009-03-22T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d3, -1, ISO8601DateHelper.parseAsUTC((String)"2009-03-19T13:15:30Z"));
        this.assertReturnsElapsedWorkingDays(d3, -6, ISO8601DateHelper.parseAsUTC((String)"2009-03-12T13:15:30Z"));
    }

    public void testGetElapsedWorkingDaysZero() throws Exception {
        Date d1 = ISO8601DateHelper.parseAsUTC((String)"2009-03-18T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d1, 0, d1);
        Date d2 = ISO8601DateHelper.parseAsUTC((String)"2009-03-21T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d2, 0, d2);
        Date d3 = ISO8601DateHelper.parseAsUTC((String)"2009-03-22T13:15:30Z");
        this.assertReturnsElapsedWorkingDays(d3, 0, d3);
    }
}

