/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.crucible.util.HqlUtil;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class HqlUtilTest
extends TestCase {
    public void testNestedWhereClauseBuilderSimple() {
        String expected = "where ( a = b or c = d ) ";
        ArrayList<String> clauses = new ArrayList<String>(){
            {
                this.add("a = b");
                this.add("c = d");
            }
        };
        HqlUtilTest.assertEquals((String)"wrong nested where clause", (String)expected.trim(), (String)HqlUtil.nestedWhereBuilder((String)"", (List)clauses, (String)"and", (String)"or").replaceAll("\\s+", " ").trim());
    }

    public void testNestedWhereClauseBuilderComplex() {
        String expected = "where x1 = y1 and ( a = b or c = d ) ";
        ArrayList<String> clauses = new ArrayList<String>(){
            {
                this.add("a = b");
                this.add("c = d");
            }
        };
        HqlUtilTest.assertEquals((String)"wrong nested where clause", (String)expected.trim(), (String)HqlUtil.nestedWhereBuilder((String)"where x1 = y1 ", (List)clauses, (String)"and", (String)"or").replaceAll("\\s+", " ").trim());
    }

    public void testWhereClauseBuilder() {
        String expected = "where a = b and c = d and x1 = y1";
        ArrayList<String> clauses = new ArrayList<String>(){
            {
                this.add("a = b");
                this.add("c = d");
                this.add("x1 = y1");
            }
        };
        String result = "";
        for (String clause : clauses) {
            result = HqlUtil.whereBuilder((String)result, (String)clause, (String)"and");
        }
        HqlUtilTest.assertEquals((String)"wrong nested where clause", (String)expected.trim(), (String)result.replaceAll("\\s+", " ").trim());
    }
}

