/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import junit.framework.TestCase;

public class FileUtilsTest
extends TestCase {
    public void testFormatFileSize() {
        FileUtilsTest.assertEquals((String)"0B", (String)FileUtils.formatFileSize((long)0L));
        FileUtilsTest.assertEquals((String)"0.9K", (String)FileUtils.formatFileSize((long)1000L));
        FileUtilsTest.assertEquals((String)"0.9K", (String)FileUtils.formatFileSize((long)1023L));
        FileUtilsTest.assertEquals((String)"1K", (String)FileUtils.formatFileSize((long)1024L));
        FileUtilsTest.assertEquals((String)"1K", (String)FileUtils.formatFileSize((long)1025L));
        FileUtilsTest.assertEquals((String)"999K", (String)FileUtils.formatFileSize((long)1022976L));
        FileUtilsTest.assertEquals((String)"0.9M", (String)FileUtils.formatFileSize((long)1047552L));
        try {
            FileUtils.formatFileSize((long)-10L);
            FileUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDeleteTreeWithFile() throws Exception {
        File file = File.createTempFile("mytest", "suffix");
        FileUtilsTest.assertTrue((boolean)file.exists());
        FileUtilsTest.assertTrue((boolean)FileUtils.deleteTree((File)file));
        FileUtilsTest.assertFalse((boolean)file.exists());
    }
}

