/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.cenqua.fisheye.SafeExternalProcessBuilder;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class FileSystemUtilsTest {
    private FileSystemUtils fileSystemUtils;
    private final Collection<File> tempFiles = Lists.newLinkedList();
    private CLib clib;

    @Before
    public void setUp() throws Exception {
        Assume.assumeThat((Object)SystemUtils.IS_OS_WINDOWS, (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        this.clib = (CLib)Native.loadLibrary((String)"c", CLib.class);
        this.fileSystemUtils = new FileSystemUtils();
    }

    @After
    public void tearDown() throws Exception {
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
    }

    @Test
    public void testPrivatise() throws Exception {
        File f = this.newTempFile();
        this.chmod(f, Integer.parseInt("0777", 8));
        Assert.assertThat((String)"full 0777 perms prior to the test", (Object)f, (Matcher)FilePermsMatcher.matchFilePerms("rwxrwxrwx"));
        Assert.assertThat((String)"file readable prior to the test", (Object)f, (Matcher)FileReadableMatcher.fileReadable());
        this.fileSystemUtils.privatise(f);
        Assert.assertThat((String)"group and world perms revoked", (Object)f, (Matcher)FilePermsMatcher.matchFilePerms("rw-------"));
        Assert.assertThat((String)"file still readable after the test", (Object)f, (Matcher)FileReadableMatcher.fileReadable());
    }

    @Test
    public void testPrivatise_NoAccessInitially() throws Exception {
        File f = this.newTempFile();
        this.chmod(f, Integer.parseInt("0000", 8));
        Assert.assertThat((String)"no perms (0000) prior to the test", (Object)f, (Matcher)FilePermsMatcher.matchFilePerms("---------"));
        Assert.assertThat((String)"file not readable prior to the test", (Object)f, (Matcher)CoreMatchers.not((Matcher)FileReadableMatcher.fileReadable()));
        this.fileSystemUtils.privatise(f);
        Assert.assertThat((String)"group and world perms revoked", (Object)f, (Matcher)FilePermsMatcher.matchFilePerms("rw-------"));
        Assert.assertThat((String)"file readable after the test", (Object)f, (Matcher)FileReadableMatcher.fileReadable());
    }

    @Test
    public void testPrivatise_Directory() throws Exception {
        File f = this.newTempFile();
        Assert.assertThat((String)"managed to delete temp file", (Object)f.delete(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"managed to create temp directory", (Object)f.mkdir(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        this.chmod(f, Integer.parseInt("0777", 8));
        Assert.assertThat((String)"full 0777 perms prior to the test", (Object)f, (Matcher)FilePermsMatcher.matchFilePerms("rwxrwxrwx"));
        Assert.assertThat((String)"managed to create file inside temp folder prior the test", (Object)this.newTempFile(f), (Matcher)CoreMatchers.notNullValue());
        this.fileSystemUtils.privatise(f);
        Assert.assertThat((String)"group and world perms revoked, execute privs stays in place", (Object)f, (Matcher)FilePermsMatcher.matchFilePerms("rwx------"));
        Assert.assertThat((String)"still managed to create file inside temp folder after the test", (Object)this.newTempFile(f), (Matcher)CoreMatchers.notNullValue());
    }

    private File newTempFile() throws IOException {
        return this.newTempFile(null);
    }

    private File newTempFile(File directory) throws IOException {
        File f = File.createTempFile(FileSystemUtilsTest.class.getSimpleName() + "_", "", directory);
        this.tempFiles.add(f);
        return f;
    }

    private void chmod(File file, int posixPerms) {
        this.clib.chmod(file.getPath(), posixPerms);
    }

    private static interface CLib
    extends Library {
        public int chmod(String var1, int var2);
    }

    private static class FileReadableMatcher
    extends TypeSafeMatcher<File> {
        private FileReadableMatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean matchesSafely(File file) {
            boolean failed = false;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                failed = false;
            }
            catch (FileNotFoundException e) {
                failed = true;
            }
            finally {
                if (null != br) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            return !failed;
        }

        public void describeTo(Description description) {
            description.appendText("readable file expected");
        }

        public static FileReadableMatcher fileReadable() {
            return new FileReadableMatcher();
        }
    }

    private static class FilePermsMatcher
    extends TypeSafeMatcher<File> {
        private final String expectedPerms;
        private String actualPerms;

        private FilePermsMatcher(String expectedPerms) {
            this.expectedPerms = (String)Preconditions.checkNotNull((Object)expectedPerms, (Object)"expectedPerms");
        }

        protected boolean matchesSafely(File file) {
            StringOutputHandler outputHandler = new StringOutputHandler();
            PluggableProcessHandler handler = new PluggableProcessHandler((OutputHandler)outputHandler, (OutputHandler)new StringOutputHandler());
            ExternalProcessBuilder builder = new SafeExternalProcessBuilder().command(Arrays.asList("ls", "-ald", file.getAbsolutePath())).handler((ProcessHandler)handler);
            ExternalProcess process = builder.build();
            process.execute();
            if (!handler.succeeded()) {
                throw new AssertionError((Object)("Failed to assert file permissions match, error: " + handler.getError() + ", command: " + process.getCommandLine()));
            }
            String output = outputHandler.getOutput();
            this.actualPerms = output.substring(1, 10);
            return this.expectedPerms.equals(this.actualPerms);
        }

        public void describeTo(Description description) {
            description.appendText("expected permissions: ");
            description.appendValue((Object)this.expectedPerms);
            description.appendText(" but got: ");
            description.appendValue((Object)this.actualPerms);
        }

        public static FilePermsMatcher matchFilePerms(String perms) {
            return new FilePermsMatcher(perms);
        }
    }
}

