/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.util.DefaultProductUpdatePoller;
import com.cenqua.fisheye.util.ProductUpdateInfo;
import java.util.Date;
import junit.framework.TestCase;
import org.easymock.classextension.EasyMock;

public class DefaultProductUpdatePollerTest
extends TestCase {
    private final Date now = new Date();
    private final long DAY = 86400000L;

    public void testUpToDate() {
        FisheyeVersionInfo fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
        EasyMock.expect((Object)fvi.getReleaseNum()).andStubReturn((Object)"1.0");
        EasyMock.replay((Object[])new Object[]{fvi});
        DefaultProductUpdatePoller poller = new DefaultProductUpdatePoller(fvi);
        poller.checkForUpdates(new ProductUpdateInfo("1.0", "http://some/url", false, this.now));
        DefaultProductUpdatePollerTest.assertFalse((boolean)poller.getUpdateAvailable());
        DefaultProductUpdatePollerTest.assertNull((Object)poller.getLatestVersion());
        EasyMock.verify((Object[])new Object[]{fvi});
    }

    public void testNewVersionAvailable() {
        FisheyeVersionInfo fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
        EasyMock.expect((Object)fvi.getReleaseNum()).andStubReturn((Object)"1.0");
        EasyMock.replay((Object[])new Object[]{fvi});
        ProductUpdateInfo update = new ProductUpdateInfo("1.1", "http://some/url", false, this.now);
        DefaultProductUpdatePoller poller = new DefaultProductUpdatePoller(fvi);
        poller.checkForUpdates(update);
        DefaultProductUpdatePollerTest.assertTrue((boolean)poller.getUpdateAvailable());
        DefaultProductUpdatePollerTest.assertEquals((Object)update, (Object)poller.getLatestVersion());
        EasyMock.verify((Object[])new Object[]{fvi});
    }

    public void testNewVersionRequiresSupport() {
        FisheyeVersionInfo fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
        EasyMock.expect((Object)fvi.getReleaseNum()).andStubReturn((Object)"1.0");
        EasyMock.replay((Object[])new Object[]{fvi});
        ProductUpdateInfo update = new ProductUpdateInfo("1.1", "http://some/url", true, new Date(this.now.getTime() + 31622400000L));
        DefaultProductUpdatePoller poller = new DefaultProductUpdatePoller(fvi);
        poller.checkForUpdates(update);
        DefaultProductUpdatePollerTest.assertTrue((boolean)poller.getUpdateAvailable());
        DefaultProductUpdatePollerTest.assertEquals((Object)update, (Object)poller.getLatestVersion());
        EasyMock.verify((Object[])new Object[]{fvi});
    }

    public void testPullNewRelease() {
        FisheyeVersionInfo fvi = (FisheyeVersionInfo)EasyMock.createMock(FisheyeVersionInfo.class);
        EasyMock.expect((Object)fvi.getReleaseNum()).andStubReturn((Object)"1.0");
        EasyMock.replay((Object[])new Object[]{fvi});
        ProductUpdateInfo update = new ProductUpdateInfo("1.1", "http://some/url", true, new Date(this.now.getTime() + 31622400000L));
        DefaultProductUpdatePoller poller = new DefaultProductUpdatePoller(fvi);
        poller.checkForUpdates(update);
        DefaultProductUpdatePollerTest.assertTrue((boolean)poller.getUpdateAvailable());
        DefaultProductUpdatePollerTest.assertEquals((Object)update, (Object)poller.getLatestVersion());
        update = new ProductUpdateInfo("1.0", "http://some/url", false, this.now);
        poller.checkForUpdates(update);
        DefaultProductUpdatePollerTest.assertFalse((boolean)poller.getUpdateAvailable());
        DefaultProductUpdatePollerTest.assertNull((Object)poller.getLatestVersion());
        EasyMock.verify((Object[])new Object[]{fvi});
    }
}

