/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.DateHelper;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public class DateParserTest
extends TestCase {
    long now = System.currentTimeMillis();
    TimeZone tz = TimeZone.getTimeZone("Australia/Sydney");

    public void testDateParsing() {
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)4, (int)4, (int)0, (int)0, (int)0), "2003/4/4Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)4, (int)3, (int)14, (int)0, (int)0), "2003/4/4");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)4, (int)0, (int)0, (int)0), "2003/12/4Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)3, (int)13, (int)0, (int)0), "2003/12/4");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)5, (int)12, (int)0, (int)0, (int)0), "2003/5/12Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)5, (int)11, (int)14, (int)0, (int)0), "2003/5/12");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)0, (int)0, (int)0), "2003/12/12Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)11, (int)13, (int)0, (int)0), "2003/12/12");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)0, (int)0, (int)0), "2003/12/12T00:00:00Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)1, (int)0, (int)0), "2003/12/12T01:00:00Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)1, (int)13, (int)0), "2003/12/12T01:13:00Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)1, (int)12, (int)34), "2003/12/12T01:12:34Z");
    }

    public void testTimezones() {
        this.assertDateParses(DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28), "2005-02-11T10:02:28+11:00");
        this.assertDateParses(DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28), "2005-02-11T10:02:28+1100");
        this.assertDateParses(DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28), "2005-02-10T23:02:28+0000");
        this.assertDateParses(DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28), "2005-02-10T23:02:28Z");
        this.assertDateParses(DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28), "2005-02-10T21:32:28-0130");
    }

    public void testDurations() {
        this.assertDateParses(DateHelper.componentsToTime((int)2004, (int)12, (int)12, (int)0, (int)0, (int)0), "2003/12/12T00:00:00Z+P1Y");
        this.assertDateParses(DateHelper.componentsToTime((int)2004, (int)1, (int)12, (int)0, (int)0, (int)0), "2003/12/12T00:00:00Z+P1M");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)13, (int)0, (int)0, (int)0), "2003/12/12T00:00:00Z+P1D");
        this.assertDateParses(DateHelper.componentsToTime((int)2005, (int)1, (int)13, (int)0, (int)0, (int)0), "2003/12/12T00:00:00Z+P1Y1M1D");
        this.assertDateParses(DateHelper.componentsToTime((int)2002, (int)11, (int)10, (int)0, (int)0, (int)0), "2003/12/12T00:00:00Z-P1Y1M2D");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)13, (int)0, (int)0), "2003/12/12T00:00:00Z+PT13H");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)0, (int)13, (int)0), "2003/12/12T00:00:00Z+PT13M");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)0, (int)0, (int)13), "2003/12/12T00:00:00Z+PT13S");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)0, (int)0, (int)13), "2003/12/12T00:00:00Z+PT13.13S");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)12, (int)13, (int)13, (int)13), "2003/12/12T00:00:00Z+PT13H13M13S");
        this.assertDateParses(DateHelper.componentsToTime((int)2003, (int)12, (int)11, (int)10, (int)46, (int)47), "2003/12/12T00:00:00Z-PT13H13M13S");
        this.assertDateParses(DateHelper.componentsToTime((int)2002, (int)11, (int)10, (int)10, (int)46, (int)47), "2003/12/12T00:00:00Z-P1Y1M1DT13H13M13S");
        this.assertInvalidDate("2003/12/12T00:00:00+P");
        this.assertInvalidDate("2003/12/12T00:00:00+P1");
        this.assertInvalidDate("2003/12/12T00:00:00+P1H");
        this.assertInvalidDate("2003/12/12T00:00:00+PT");
        this.assertInvalidDate("2003/12/12T00:00:00+PT1");
    }

    public void testDatesNearDST() {
        this.assertDateParses(this.toDate("2004-10-31T01:59:30+1000"), "2004-10-31T01:59:30");
        this.assertDateParses(this.toDate("2004-10-31T02:00:00+1000"), "2004-10-31T02:00:00");
        this.assertDateParses(this.toDate("2004-10-31T03:00:00+1100"), "2004-10-31T02:00:00");
        this.assertDateParses(this.toDate("2004-10-31T02:30:00+1000"), "2004-10-31T02:30:00");
        this.assertDateParses(this.toDate("2004-10-31T03:30:00+1100"), "2004-10-31T02:30:00");
        this.assertDateParses(this.toDate("2004-10-31T02:00:00+1000"), "2004-10-31T03:00:00");
        this.assertDateParses(this.toDate("2004-10-31T03:00:00+1100"), "2004-10-31T03:00:00");
        this.assertDateParses(this.toDate("2004-10-31T02:30:00+1000"), "2004-10-31T03:30:00");
        this.assertDateParses(this.toDate("2004-10-31T03:30:00+1100"), "2004-10-31T03:30:00");
        this.assertDateParses(this.toDate("2005-03-27T01:59:30+1100"), "2005-03-27T01:59:30");
        this.assertDateParses(this.toDate("2005-03-27T03:00:00+1100"), "2005-03-27T02:00:00");
    }

    public void testDateConstants() {
        this.assertDateParses(this.now, "now");
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28);
        this.assertDateParses(this.now, "now");
        this.assertDateParses(this.toDate("2005-02-11T00:00:00+11:00"), "today");
        this.assertDateParses(this.toDate("2005-02-10T00:00:00Z"), "todaygmt");
        this.assertDateParses(this.toDate("2005-02-01T00:00:00+11:00"), "thismonth");
        this.assertDateParses(this.toDate("2005-02-01T00:00:00Z"), "thismonthgmt");
        this.assertDateParses(this.toDate("2005-01-01T00:00:00+11:00"), "thisyear");
        this.assertDateParses(this.toDate("2005-01-01T00:00:00Z"), "thisyeargmt");
        this.now = DateHelper.componentsToTime((int)2004, (int)12, (int)31, (int)20, (int)21, (int)22);
        this.assertDateParses(this.now, "now");
        this.assertDateParses(this.toDate("2005-01-01T00:00:00+11:00"), "today");
        this.assertDateParses(this.toDate("2004-12-31T00:00:00Z"), "todaygmt");
        this.assertDateParses(this.toDate("2005-01-01T00:00:00+11:00"), "thismonth");
        this.assertDateParses(this.toDate("2004-12-01T00:00:00Z"), "thismonthgmt");
        this.assertDateParses(this.toDate("2005-01-01T00:00:00+11:00"), "thisyear");
        this.assertDateParses(this.toDate("2004-01-01T00:00:00Z"), "thisyeargmt");
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28);
        this.assertDateParses(this.toDate("2005-02-06T00:00:00+11:00"), "thisweek");
        this.assertDateParses(this.toDate("2005-02-06T00:00:00Z"), "thisweekgmt");
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)11, (int)23, (int)2, (int)28);
        this.assertDateParses(this.toDate("2005-02-06T00:00:00+11:00"), "thisweek");
        this.assertDateParses(this.toDate("2005-02-06T00:00:00Z"), "thisweekgmt");
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)12, (int)23, (int)2, (int)28);
        this.assertDateParses(this.toDate("2005-02-13T00:00:00+11:00"), "thisweek");
        this.assertDateParses(this.toDate("2005-02-06T00:00:00Z"), "thisweekgmt");
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)13, (int)23, (int)2, (int)28);
        this.assertDateParses(this.toDate("2005-02-13T00:00:00+11:00"), "thisweek");
        this.assertDateParses(this.toDate("2005-02-13T00:00:00Z"), "thisweekgmt");
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)14, (int)23, (int)2, (int)28);
        this.assertDateParses(this.toDate("2005-02-13T00:00:00+11:00"), "thisweek");
        this.assertDateParses(this.toDate("2005-02-13T00:00:00Z"), "thisweekgmt");
    }

    public void testDateConstantsWithOffsets() {
        this.now = DateHelper.componentsToTime((int)2005, (int)2, (int)10, (int)23, (int)2, (int)28);
        this.assertDateParses(this.toDate("2005-02-12T00:00:00+11:00"), "today+P1D");
        this.assertDateParses(this.toDate("2005-02-11T00:00:00Z"), "todaygmt+P1D");
        this.assertDateParses(this.toDate("2005-02-09T23:00:00+11:00"), "today-P1DT1H");
        this.assertDateParses(this.toDate("2005-02-08T23:00:00Z"), "todaygmt-P1DT1H");
    }

    private long toDate(String s) {
        Long v = DateHelper.parseDate((String)s, (long)this.now, (TimeZone)this.tz);
        DateParserTest.assertNotNull((Object)v);
        return v;
    }

    private void assertInvalidDate(String s) {
        DateParserTest.assertNull((Object)DateHelper.parseDate((String)s, (long)this.now, (TimeZone)this.tz));
    }

    private void assertDateParses(long date, String str) {
        Long val = DateHelper.parseDate((String)str, (long)this.now, (TimeZone)this.tz);
        DateParserTest.assertNotNull((Object)val);
        long ts = val;
        DateParserTest.assertEquals((String)(DateHelper.toGmtString((Date)new Date(date)) + " vs " + DateHelper.toGmtString((Date)new Date(ts))), (long)date, (long)ts);
    }
}

