/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public class DateHelperTest
extends TestCase {
    private static final long second = 1000L;
    private static final long minute = 60000L;
    private static final long hour = 3600000L;
    private static final long day = 86400000L;
    private static final long year = 31622400000L;
    private static final long month = 2635200000L;

    public void testAgeCalcs() {
        this.assertAge("1 second", 1000L);
        this.assertAge("3 seconds", 3000L);
        this.assertAge("60 seconds", 60000L);
        this.assertAge("4 minutes", 240000L);
        this.assertAge("60 minutes", 3600000L);
        this.assertAge("5 hours", 18000000L);
        this.assertAge("30 days", 2635200000L);
        this.assertAge("2 months", 5270400000L);
        this.assertAge("2 months and 1 day", 5356800000L);
        this.assertAge("2 months and 2 days", 5443200000L);
        this.assertAge("2 months and 29 days", 7776000000L);
        this.assertAge("12 months", 31622400000L);
        this.assertAge("2 years", 63244800000L);
        this.assertAge("3 years", 94867200000L);
        this.assertAge("4 years", 126489600000L);
        this.assertAge("13 months", 34257600000L);
        this.assertAge("14 months", 36892800000L);
        this.assertAge("23 months", 60609600000L);
        this.assertAge("2 years", 63331200000L);
        this.assertAge("2 years and 1 month", 65880000000L);
        this.assertAge("3 years and 6 months", 110764800000L);
        this.assertAge("4 years and 11 months", 155563200000L);
    }

    public void testEndOfDay() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        cal.set(1, 2006);
        cal.set(2, 10);
        cal.set(5, 11);
        cal.set(11, 12);
        cal.set(12, 13);
        cal.set(13, 14);
        cal.set(14, 15);
        Date eod = DateHelper.getEndOfDay((Date)cal.getTime(), (TimeZone)TimeZone.getDefault());
        cal.setTime(eod);
        DateHelperTest.assertEquals((int)cal.get(1), (int)2006);
        DateHelperTest.assertEquals((int)cal.get(2), (int)10);
        DateHelperTest.assertEquals((int)cal.get(5), (int)11);
        DateHelperTest.assertEquals((int)cal.get(11), (int)((Calendar)cal).getMaximum(11));
        DateHelperTest.assertEquals((int)cal.get(12), (int)((Calendar)cal).getMaximum(12));
        DateHelperTest.assertEquals((int)cal.get(13), (int)((Calendar)cal).getMaximum(13));
        DateHelperTest.assertEquals((int)cal.get(14), (int)((Calendar)cal).getMaximum(14));
    }

    public void testStartOfDay() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        cal.set(1, 2006);
        cal.set(2, 10);
        cal.set(5, 11);
        cal.set(11, 12);
        cal.set(12, 13);
        cal.set(13, 14);
        cal.set(14, 15);
        Date sod = DateHelper.getStartOfDay((Date)cal.getTime(), (TimeZone)TimeZone.getDefault());
        cal.setTime(sod);
        DateHelperTest.assertEquals((int)cal.get(1), (int)2006);
        DateHelperTest.assertEquals((int)cal.get(2), (int)10);
        DateHelperTest.assertEquals((int)cal.get(5), (int)11);
        DateHelperTest.assertEquals((int)cal.get(11), (int)((Calendar)cal).getMinimum(11));
        DateHelperTest.assertEquals((int)cal.get(12), (int)((Calendar)cal).getMinimum(12));
        DateHelperTest.assertEquals((int)cal.get(13), (int)((Calendar)cal).getMinimum(13));
        DateHelperTest.assertEquals((int)cal.get(14), (int)((Calendar)cal).getMinimum(14));
    }

    private void assertAge(String expected, long age) {
        long now = System.currentTimeMillis();
        long birth = now - age;
        DateHelperTest.assertEquals((String)expected, (String)DateHelper.age((long)birth, (long)now));
    }

    public void testFuzzyAgeCalcs() {
        this.assertFuzzyAge("a few seconds", -5000L);
        this.assertFuzzyAge("a few minutes", -540000L);
        this.assertFuzzyAge("a few seconds", 1000L);
        this.assertFuzzyAge("a few seconds", 59000L);
        this.assertFuzzyAge("a few minutes", 60000L);
        this.assertFuzzyAge("a few minutes", 599000L);
        this.assertFuzzyAge("10 mins", 601000L);
        this.assertFuzzyAge("59 mins", 3599000L);
        this.assertFuzzyAge("59 mins", this.getMillis(2011, 3, 27, 15, 10), this.getMillis(2011, 3, 27, 16, 9));
        this.assertFuzzyAge("1 hour", this.getMillis(2011, 3, 27, 15, 10), this.getMillis(2011, 3, 27, 16, 10));
        this.assertFuzzyAge("2 hours", this.getMillis(2011, 3, 27, 13, 11), this.getMillis(2011, 3, 27, 16, 10));
        this.assertFuzzyAge("3 hours", this.getMillis(2011, 3, 27, 13, 9), this.getMillis(2011, 3, 27, 16, 10));
        this.assertFuzzyAge("23 hours", this.getMillis(2005, 5, 5, 0, 0), this.getMillis(2005, 5, 5, 23, 59));
        this.assertFuzzyAge("24 hours", this.getMillis(2005, 5, 4, 23, 59), this.getMillis(2005, 5, 5, 23, 59));
        this.assertFuzzyAge("24 hours", this.getMillis(2005, 5, 4, 23, 59), this.getMillis(2005, 5, 5, 23, 59), this.gmt(), Locale.FRANCE);
        this.assertFuzzyAge("4 days", this.getMillis(2009, 3, 10, 12, 0), this.getMillis(2009, 3, 14, 12, 0));
        this.assertFuzzyAge("4 days", this.getMillis(2009, 3, 10, 12, 0), this.getMillis(2009, 3, 14, 12, 0), this.gmt(), Locale.FRANCE);
        this.assertFuzzyAge("7 days", this.getMillis(2009, 3, 7, 12, 0), this.getMillis(2009, 3, 14, 12, 0));
        this.assertFuzzyAge("7 days", this.getMillis(2009, 3, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyAge("5 weeks", this.getMillis(2009, 2, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyAge("9 weeks", this.getMillis(2009, 1, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyAge("3 months", this.getMillis(2009, 0, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyAge("3 months", this.getMillis(2009, 0, 1, 0, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyAge("3 months", this.getMillis(2008, 11, 31, 23, 59), this.getMillis(2009, 3, 14, 9, 0));
    }

    public void testFuzzyDateCalcs() {
        this.assertFuzzyDate("in a few minutes", -300000L);
        this.assertFuzzyDate("at 11:59 PM", this.getMillis(2011, 7, 12, 23, 59), this.getMillis(2011, 7, 12, 11, 59));
        this.assertFuzzyDate("at 11:59 PM tomorrow", this.getMillis(2011, 7, 13, 23, 59), this.getMillis(2011, 7, 12, 23, 59));
        this.assertFuzzyDate("at 23:59 tomorrow", this.getMillis(2011, 7, 13, 23, 59), this.getMillis(2011, 7, 12, 23, 59), this.gmt(), Locale.FRANCE);
        this.assertFuzzyDate("Thursday", this.getMillis(2011, 7, 18, 23, 59), this.getMillis(2011, 7, 12, 23, 59));
        this.assertFuzzyDate("Aug 19", this.getMillis(2011, 7, 19, 23, 59), this.getMillis(2011, 7, 12, 23, 59));
        this.assertFuzzyDate("December", this.getMillis(2011, 11, 19, 23, 59), this.getMillis(2011, 7, 12, 23, 59));
        this.assertFuzzyDate("Dec 2012", this.getMillis(2012, 11, 19, 23, 59), this.getMillis(2011, 7, 12, 23, 59));
        this.assertFuzzyDate("a moment ago", 1000L);
        this.assertFuzzyDate("a moment ago", 59000L);
        this.assertFuzzyDate("just now", 60000L);
        this.assertFuzzyDate("just now", 599000L);
        this.assertFuzzyDate("12:00 AM", this.getMillis(2005, 5, 5, 0, 0), this.getMillis(2005, 5, 5, 23, 59));
        this.assertFuzzyDate("11:59 PM yesterday", this.getMillis(2005, 5, 4, 23, 59), this.getMillis(2005, 5, 5, 23, 59));
        this.assertFuzzyDate("23:59 yesterday", this.getMillis(2005, 5, 4, 23, 59), this.getMillis(2005, 5, 5, 23, 59), this.gmt(), Locale.FRANCE);
        this.assertFuzzyDate("last Friday", this.getMillis(2009, 3, 10, 12, 0), this.getMillis(2009, 3, 14, 12, 0));
        this.assertFuzzyDate("last vendredi", this.getMillis(2009, 3, 10, 12, 0), this.getMillis(2009, 3, 14, 12, 0), this.gmt(), Locale.FRANCE);
        this.assertFuzzyDate("last Tuesday", this.getMillis(2009, 3, 7, 12, 0), this.getMillis(2009, 3, 14, 12, 0));
        this.assertFuzzyDate("Apr 6", this.getMillis(2009, 3, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyDate("Mar 6", this.getMillis(2009, 2, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyDate("February", this.getMillis(2009, 1, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyDate("January", this.getMillis(2009, 0, 6, 12, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyDate("January", this.getMillis(2009, 0, 1, 0, 0), this.getMillis(2009, 3, 14, 9, 0));
        this.assertFuzzyDate("Dec 2008", this.getMillis(2008, 11, 31, 23, 59), this.getMillis(2009, 3, 14, 9, 0));
    }

    private long getMillis(int year, int month, int day, int hour, int min, int sec, int millis) {
        GregorianCalendar cal = new GregorianCalendar(this.gmt());
        cal.set(year, month, day, hour, min, sec);
        cal.set(14, millis);
        return cal.getTimeInMillis();
    }

    private long getMillis(int year, int month, int day, int hour, int min) {
        return this.getMillis(year, month, day, hour, min, 0, 0);
    }

    private TimeZone gmt() {
        return TimeZone.getTimeZone("GMT");
    }

    private void assertFuzzyAge(String expected, long birth, long now) {
        this.assertFuzzyAge(expected, birth, now, this.gmt(), Locale.US);
    }

    private void assertFuzzyAge(String expected, long birth, long now, TimeZone tz, Locale loc) {
        DateHelperTest.assertEquals((String)expected, (String)DateHelper.fuzzyAge((long)birth, (long)now, (TimeZone)tz, (Locale)loc));
    }

    private void assertFuzzyAge(String expected, long age) {
        long now = System.currentTimeMillis();
        long birth = now - age;
        this.assertFuzzyAge(expected, birth, now);
    }

    private void assertFuzzyDate(String expected, long birth, long now) {
        this.assertFuzzyDate(expected, birth, now, this.gmt(), Locale.US);
    }

    private void assertFuzzyDate(String expected, long birth, long now, TimeZone tz, Locale loc) {
        DateHelperTest.assertEquals((String)expected, (String)DateHelper.fuzzyDate((long)birth, (long)now, (TimeZone)tz, (Locale)loc));
    }

    private void assertFuzzyDate(String expected, long age) {
        long now = System.currentTimeMillis();
        long birth = now - age;
        this.assertFuzzyDate(expected, birth, now);
    }

    public void testRoundDownToNearest() {
        GregorianCalendar test = new GregorianCalendar();
        test.set(2006, 5, 25, 14, 52, 13);
        GregorianCalendar exp = new GregorianCalendar();
        exp.setTimeInMillis(test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)13);
        exp.set(14, 0);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)12);
        exp.set(13, 0);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)10);
        exp.set(12, 0);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)5);
        exp.set(11, 0);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)3);
        exp.set(7, ((Calendar)exp).getMinimum(7));
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)2);
        exp.set(5, 1);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        DateHelper.roundDownToNearest((Calendar)test, (int)1);
        exp.set(6, 1);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
        exp.set(2006, 0, 1, 0, 0, 0);
        DateHelperTest.assertEquals((long)exp.getTimeInMillis(), (long)test.getTimeInMillis());
    }

    public void testWithinInterval() {
        long tenOhOne = this.getMillis(2005, 0, 12, 10, 1);
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)13, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)12, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)10, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)7, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)5, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)6, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)4, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)3, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)2, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)1, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)1, (int)13, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)6000, (int)13, (long)tenOhOne, (long)tenOhOne, (TimeZone)this.gmt()));
        long oneToEleven = this.getMillis(2005, 0, 12, 10, 59);
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)13, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)1, (int)13, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)3600, (int)13, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)12, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)1, (int)12, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)60, (int)12, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)10, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)7, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)5, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)6, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)4, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)3, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)2, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)0, (int)1, (long)tenOhOne, (long)oneToEleven, (TimeZone)this.gmt()));
        long tenOhOne2006 = this.getMillis(2006, 0, 12, 10, 1);
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)13, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)12, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)10, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)7, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)5, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)6, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)4, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)3, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)2, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)11, (int)2, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)12, (int)2, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertFalse((boolean)DateHelper.withinInterval((int)0, (int)1, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
        DateHelperTest.assertTrue((boolean)DateHelper.withinInterval((int)1, (int)1, (long)tenOhOne, (long)tenOhOne2006, (TimeZone)this.gmt()));
    }

    public void testWithinIntervalWithSwappedTimestamps() {
        long start = this.getMillis(2015, 2, 10, 0, 0);
        long end = this.getMillis(2015, 1, 10, 0, 0);
        DateHelperTest.assertEquals((boolean)DateHelper.withinInterval((int)0, (int)2, (long)start, (long)end, (TimeZone)this.gmt()), (boolean)DateHelper.withinInterval((int)0, (int)2, (long)end, (long)start, (TimeZone)this.gmt()));
        DateHelperTest.assertEquals((boolean)DateHelper.withinInterval((int)0, (int)1, (long)start, (long)end, (TimeZone)this.gmt()), (boolean)DateHelper.withinInterval((int)0, (int)1, (long)end, (long)start, (TimeZone)this.gmt()));
    }

    public void testToGmtString() {
        GregorianCalendar cal = new GregorianCalendar(this.gmt());
        cal.set(2008, 0, 3, 13, 27, 58);
        DateHelperTest.assertEquals((String)"3 Jan 2008 13:27:58 GMT", (String)DateHelper.toGmtString((Date)cal.getTime()));
        try {
            DateHelper.toGmtString(null);
            DateHelperTest.fail((String)("[" + NullPointerException.class + "] should have been thrown"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDayRelation() throws Exception {
        Date today = ISO8601DateHelper.parseAsUTC((String)"2009-01-24T11:11:00+11:00");
        Date todayMinusHour = ISO8601DateHelper.parseAsUTC((String)"2009-01-24T10:55:00+11:00");
        Date daysAgo = ISO8601DateHelper.parseAsUTC((String)"2009-01-20T10:55:00+11:00");
        Date daysBefore = ISO8601DateHelper.parseAsUTC((String)"2009-01-31T10:55:00+11:00");
        TimeZone here = TimeZone.getTimeZone("GMT+11:00");
        DateHelperTest.assertEquals((Object)DateHelper.Relation.TODAY, (Object)DateHelper.getDayRelation((Date)today, (Date)todayMinusHour, (TimeZone)here));
        DateHelperTest.assertEquals((Object)DateHelper.Relation.YESTERDAY, (Object)DateHelper.getDayRelation((Date)today, (Date)todayMinusHour, (TimeZone)this.gmt()));
        DateHelperTest.assertEquals((Object)DateHelper.Relation.NEITHER, (Object)DateHelper.getDayRelation((Date)today, (Date)daysAgo, (TimeZone)here));
        DateHelperTest.assertEquals((Object)DateHelper.Relation.NEITHER, (Object)DateHelper.getDayRelation((Date)today, (Date)daysAgo, (TimeZone)this.gmt()));
        DateHelperTest.assertEquals((Object)DateHelper.Relation.NEITHER, (Object)DateHelper.getDayRelation((Date)today, (Date)daysBefore, (TimeZone)here));
        DateHelperTest.assertEquals((Object)DateHelper.Relation.NEITHER, (Object)DateHelper.getDayRelation((Date)today, (Date)daysBefore, (TimeZone)this.gmt()));
    }

    public void testFuzzyTime() throws Exception {
        Date now = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:10:00+11:00");
        Date underOneMinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:09:59+11:00");
        Date oneMinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:08:59+11:00");
        Date almost2MinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:08:01+11:00");
        Date tenMinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:00:00+11:00");
        Date oneHourAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T08:09:00+11:00");
        Date fiveHourAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T04:09:00+11:00");
        Date yesterday = ISO8601DateHelper.parseAsUTC((String)"2010-12-23T23:59:59+11:00");
        Date yesterdayMorn = ISO8601DateHelper.parseAsUTC((String)"2010-12-23T09:00:00+11:00");
        TimeZone here = TimeZone.getTimeZone("GMT+11:00");
        DateHelperTest.assertEquals((String)"1 min ago", (String)DateHelper.fuzzyTime((Date)underOneMinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"1 min ago", (String)DateHelper.fuzzyTime((Date)oneMinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"1 min ago", (String)DateHelper.fuzzyTime((Date)almost2MinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"10 mins ago", (String)DateHelper.fuzzyTime((Date)tenMinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"1 hr ago", (String)DateHelper.fuzzyTime((Date)oneHourAgo, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"5 hrs ago", (String)DateHelper.fuzzyTime((Date)fiveHourAgo, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"11:59 pm", (String)DateHelper.fuzzyTime((Date)yesterday, (Date)now, (TimeZone)here, (Locale)Locale.US));
        DateHelperTest.assertEquals((String)"9:00 am", (String)DateHelper.fuzzyTime((Date)yesterdayMorn, (Date)now, (TimeZone)here, (Locale)Locale.US));
    }

    public void testFuzzyTimeCustom() throws Exception {
        String customFormat = "'at' h:mm a";
        Date now = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:10:00+11:00");
        Date underOneMinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:09:59+11:00");
        Date oneMinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:08:59+11:00");
        Date almost2MinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:08:01+11:00");
        Date tenMinAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T09:00:00+11:00");
        Date oneHourAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T08:09:00+11:00");
        Date fiveHourAgo = ISO8601DateHelper.parseAsUTC((String)"2010-12-24T04:09:00+11:00");
        Date yesterday = ISO8601DateHelper.parseAsUTC((String)"2010-12-23T23:59:59+11:00");
        Date yesterdayMorn = ISO8601DateHelper.parseAsUTC((String)"2010-12-23T09:00:00+11:00");
        TimeZone here = TimeZone.getTimeZone("GMT+11:00");
        DateHelperTest.assertEquals((String)"1 min ago", (String)DateHelper.fuzzyTime((Date)underOneMinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"1 min ago", (String)DateHelper.fuzzyTime((Date)oneMinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"1 min ago", (String)DateHelper.fuzzyTime((Date)almost2MinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"10 mins ago", (String)DateHelper.fuzzyTime((Date)tenMinAgo, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"1 hr ago", (String)DateHelper.fuzzyTime((Date)oneHourAgo, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"5 hrs ago", (String)DateHelper.fuzzyTime((Date)fiveHourAgo, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"at 11:59 pm", (String)DateHelper.fuzzyTime((Date)yesterday, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
        DateHelperTest.assertEquals((String)"at 9:00 am", (String)DateHelper.fuzzyTime((Date)yesterdayMorn, (Date)now, (TimeZone)here, (Locale)Locale.US, (String)"'at' h:mm a"));
    }

    public void testParseDurationNoUnits() {
        DateHelperTest.assertMinutesParse("no unit means minutes", 0L, "0");
        DateHelperTest.assertMinutesParse("no unit means minutes", 42L, "42");
        DateHelperTest.assertMinutesParse("no unit means minutes, several values added up", 6L, "1 2 3");
    }

    public void testParseDurationWithUnits() {
        DateHelperTest.assertMinutesParse("m means minutes", 0L, "0m");
        DateHelperTest.assertMinutesParse("m means minutes", 42L, "42m");
        DateHelperTest.assertMinutesParse("m means minutes, several values added up", 6L, "1m 2m 3m");
        DateHelperTest.assertMinutesParse("different units added up", 90L, "1h 30m");
    }

    public void testParseDurationInvalidUnits() {
        DateHelperTest.assertMinutesDoNotParse("empty string", "");
        DateHelperTest.assertMinutesDoNotParse("x is not valid unit", "42x");
        DateHelperTest.assertMinutesDoNotParse("x is not valid unit", "1x 30m");
        DateHelperTest.assertMinutesDoNotParse("s is not valid unit", "1s 30m");
    }

    public void testParseDurationNegativeValues() {
        DateHelperTest.assertMinutesDoNotParse("negative value", "-42");
        DateHelperTest.assertMinutesDoNotParse("negative value", "-42m");
        DateHelperTest.assertMinutesDoNotParse("negative value", "-1h 30m");
        DateHelperTest.assertMinutesDoNotParse("negative value", "1h -30m");
    }

    public void testParseDurationWithExtraText() {
        DateHelperTest.assertMinutesParse("first unit must be valid", 42L, "abc 42m xyz");
        DateHelperTest.assertMinutesParse("extra text ignored", 90L, "1 hour and 30 minutes");
        DateHelperTest.assertMinutesParse("units may be plural", 123L, "2 hours and 3 minutes");
    }

    public void testParseDurationUnitPrefixes() {
        String unitLongName = "minutes";
        for (int i = 1; i <= unitLongName.length(); ++i) {
            DateHelperTest.assertMinutesParse("units may be abbreviated", 42L, String.format("42%s", unitLongName.substring(0, i)));
        }
    }

    private static void assertMinutesParse(String msg, long expected, String durationText) {
        Assert.assertThat((String)msg, (Object)durationText, DateHelperTest.isDurationMinutes((Matcher<? super Long>)CoreMatchers.equalTo((Object)expected)));
    }

    private static void assertMinutesDoNotParse(String msg, String durationText) {
        Assert.assertThat((String)msg, (Object)durationText, DateHelperTest.isDurationMinutes((Matcher<? super Long>)CoreMatchers.nullValue()));
    }

    private static Matcher<String> isDurationMinutes(final Matcher<? super Long> objectMatcher) {
        return new TypeSafeMatcher<String>(){
            Long durationMinutes;

            protected boolean matchesSafely(String durationText) {
                this.durationMinutes = DateHelper.getDurationMinutes((String)durationText);
                return objectMatcher.matches((Object)this.durationMinutes);
            }

            public void describeTo(Description description) {
                description.appendText("duration minutes: ").appendDescriptionOf((SelfDescribing)objectMatcher).appendText(" but got: ").appendValue((Object)this.durationMinutes);
            }
        };
    }

    public void testFormatDuration() {
        this.assertDurationFormats("0m", 0L);
        this.assertDurationFormats("42m", 42L);
        this.assertDurationFormats("1h 30m", 90L);
    }

    public void testFormatDurationNegativeClipsToZero() {
        this.assertDurationFormats("0m", -42L);
    }

    public void testFormatDurationDaysAndWeeksRemainInHours() {
        this.assertDurationFormats("8h", 480L);
        this.assertDurationFormats("24h", 1440L);
        this.assertDurationFormats("168h", 10080L);
    }

    private void assertDurationFormats(String expectedDurationText, long minutes) {
        DateHelperTest.assertEquals((String)expectedDurationText, (String)DateHelper.formatDurationMinutes((long)minutes));
    }

    public void testSameYear() throws Exception {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar cal1 = new GregorianCalendar(tz);
        cal1.set(1, 2011);
        cal1.set(2, 1);
        cal1.set(5, 20);
        GregorianCalendar cal2 = new GregorianCalendar(tz);
        cal2.set(1, 2011);
        cal2.set(2, 1);
        cal2.set(5, 20);
        DateHelperTest.assertTrue((String)"Same years should evaluate to true", (boolean)DateHelper.isSameYear((Date)cal1.getTime(), (Date)cal2.getTime(), (TimeZone)tz));
        cal2.set(1, 2010);
        cal2.set(2, 2);
        cal2.set(5, 20);
        DateHelperTest.assertFalse((String)"Within 12 months but different years should evaluate to false", (boolean)DateHelper.isSameYear((Date)cal1.getTime(), (Date)cal2.getTime(), (TimeZone)tz));
        cal2.set(1, 2009);
        cal2.set(2, 12);
        cal2.set(5, 20);
        DateHelperTest.assertFalse((String)"Different years should evaluate to false", (boolean)DateHelper.isSameYear((Date)cal1.getTime(), (Date)cal2.getTime(), (TimeZone)tz));
        cal2.set(1, 1985);
        cal2.set(2, 2);
        cal2.set(5, 5);
        DateHelperTest.assertFalse((String)"A long time ago should evaluate to false", (boolean)DateHelper.isSameYear((Date)cal1.getTime(), (Date)cal2.getTime(), (TimeZone)tz));
    }

    public void testGetNearestHalfHour() throws Exception {
        DateHelperTest.assertEquals((String)"Jan 1, 2011 1am's nearest half hour should be itself", (Object)new Date(this.getMillis(2011, 0, 1, 1, 0, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2011, 0, 1, 1, 0, 0, 0))));
        DateHelperTest.assertEquals((String)"Jan 1, 2011 1:30am's nearest half hour should be itself", (Object)new Date(this.getMillis(2011, 0, 1, 1, 30, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2011, 0, 1, 1, 30, 0, 0))));
        DateHelperTest.assertEquals((String)"Jan 1, 2011 1:30:30.333am's nearest half hour should be 1:30am", (Object)new Date(this.getMillis(2011, 0, 1, 1, 30, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2011, 0, 1, 1, 30, 30, 333))));
        DateHelperTest.assertEquals((String)"Jan 1, 2011 1:15am's nearest half hour should be 1:30am", (Object)new Date(this.getMillis(2011, 0, 1, 1, 30, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2011, 0, 1, 1, 15, 0, 0))));
        DateHelperTest.assertEquals((String)"Jan 1, 2011 1:45am's nearest half hour should be 2:00am", (Object)new Date(this.getMillis(2011, 0, 1, 2, 0, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2011, 0, 1, 1, 45, 0, 0))));
        DateHelperTest.assertEquals((String)"Jan 1, 2011 1:14am's nearest half hour should be 1:00am", (Object)new Date(this.getMillis(2011, 0, 1, 1, 0, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2011, 0, 1, 1, 14, 0, 0))));
        DateHelperTest.assertEquals((String)"Dec 31, 2010 11:45pm's nearest half hour should be Jan 1, 2011 12am", (Object)new Date(this.getMillis(2011, 0, 1, 0, 0, 0, 0)), (Object)DateHelper.getNearestHalfHour((Date)new Date(this.getMillis(2010, 11, 31, 23, 45, 0, 0))));
    }
}

