/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.CsvWriter;
import com.cenqua.fisheye.util.DateHelper;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;

public class CsvWriterTest
extends TestCase {
    private StringWriter out = new StringWriter();
    private CsvWriter csv = new CsvWriter((Writer)this.out);

    public void testSimple() throws Exception {
        this.csv.writeHeaderColumn("a");
        this.csv.writeHeaderColumn("b");
        this.csv.writeHeaderColumn("c");
        this.csv.endHeader();
        this.csv.writeInt(Integer.valueOf(1));
        this.csv.writeString("foo");
        this.csv.writeDate(DateHelper.componentsToTime((int)2005, (int)10, (int)21, (int)12, (int)12, (int)13));
        this.csv.endRow();
        this.csv.writeInt(Integer.valueOf(100));
        this.csv.writeString("");
        this.csv.writeDate(DateHelper.componentsToTime((int)2005, (int)10, (int)21, (int)0, (int)0, (int)0));
        this.csv.endRow();
        this.csv.writeInt(Integer.valueOf(-100));
        this.csv.writeString(null);
        this.csv.writeDate(DateHelper.componentsToTime((int)2005, (int)3, (int)3, (int)1, (int)2, (int)3));
        this.csv.endRow();
        this.csv.writeInt(Integer.valueOf(1));
        this.csv.writeString("foo\nbar");
        this.csv.writeInt(Integer.valueOf(2));
        this.csv.endRow();
        String[] testArray = new String[]{"A", "B", "C"};
        this.csv.writeStringArray(testArray);
        this.assertOutput("\"a\",\"b\",\"c\"\r\n1,\"foo\",2005/10/21 12:12:13\r\n100,,2005/10/21 00:00:00\r\n-100,,2005/03/03 01:02:03\r\n1,\"foo\nbar\",2\r\n\"A, B, C\"");
    }

    private void assertOutput(String expected) {
        CsvWriterTest.assertEquals((String)expected, (String)this.out.toString());
    }
}

