/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.CollectionsUtil;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class CollectionsUtilTest
extends TestCase {
    public void testSubListEmptyList() {
        List<String> empty = Arrays.asList(new String[0]);
        CollectionsUtilTest.assertEquals((int)0, (int)CollectionsUtil.findSublist(Arrays.asList("one", "two"), empty));
        CollectionsUtilTest.assertEquals((int)0, (int)CollectionsUtil.findSublist(empty, empty));
    }

    public void testSublist() {
        List<String> list1234 = Arrays.asList("one", "two", "three", "four");
        List<String> sublist12 = Arrays.asList("one", "two");
        List<String> sublist1 = Arrays.asList("one");
        List<String> sublist23 = Arrays.asList("two", "three");
        List<String> sublist4 = Arrays.asList("four");
        List<String> sublist24 = Arrays.asList("two", "four");
        CollectionsUtilTest.assertEquals((int)0, (int)CollectionsUtil.findSublist(list1234, sublist1));
        CollectionsUtilTest.assertEquals((int)0, (int)CollectionsUtil.findSublist(list1234, sublist12));
        CollectionsUtilTest.assertEquals((int)1, (int)CollectionsUtil.findSublist(list1234, sublist23));
        CollectionsUtilTest.assertEquals((int)3, (int)CollectionsUtil.findSublist(list1234, sublist4));
        CollectionsUtilTest.assertEquals((int)-1, (int)CollectionsUtil.findSublist(list1234, sublist24));
    }

    public void testSublistNull() {
        List<String> list1234 = Arrays.asList("one", "two", "three", "four");
        CollectionsUtilTest.assertEquals((int)-1, (int)CollectionsUtil.findSublist(list1234, null));
        CollectionsUtilTest.assertEquals((int)-1, (int)CollectionsUtil.findSublist(null, list1234));
        CollectionsUtilTest.assertEquals((int)-1, (int)CollectionsUtil.findSublist(null, null));
    }

    public void testSublistWithNullValuesInList() {
        List<String> list12null34 = Arrays.asList("one", "two", null, "three", "four");
        List<String> list2null3 = Arrays.asList("two", null, "three");
        List<String> list34 = Arrays.asList("three", "four");
        List<String> list243 = Arrays.asList("two", "four", "three");
        CollectionsUtilTest.assertEquals((int)1, (int)CollectionsUtil.findSublist(list12null34, list2null3));
        CollectionsUtilTest.assertEquals((int)3, (int)CollectionsUtil.findSublist(list12null34, list34));
        CollectionsUtilTest.assertEquals((int)-1, (int)CollectionsUtil.findSublist(list12null34, list243));
    }
}

