/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.AntGlob;
import junit.framework.TestCase;

public class AntGlobTest
extends TestCase {
    public void testMatching() {
        AntGlobTest.assertMatches("*.java", "foo.java");
        AntGlobTest.assertNotMatches("*.java", "foo.javax");
        AntGlobTest.assertMatches("/*.java", "foo.java");
        AntGlobTest.assertMatches("*.java", "bla/foo.java");
        AntGlobTest.assertNotMatches("/*.java", "bla/foo.java");
        AntGlobTest.assertMatches("**/*.java", "foo.java");
        AntGlobTest.assertMatches("**/*.java", "blah/foo.java");
        AntGlobTest.assertMatches("**/*.java", "blah/bar/foo.java");
        AntGlobTest.assertMatches("/**/*.java", "foo.java");
        AntGlobTest.assertMatches("/**/*.java", "blah/foo.java");
        AntGlobTest.assertMatches("/**/*.java", "blah/bar/foo.java");
        AntGlobTest.assertMatches("bar/*.java", "blah/bar/foo.java");
        AntGlobTest.assertMatches("**/bar/*.java", "blah/bar/foo.java");
        AntGlobTest.assertMatches("**/bar/**/*.java", "blah/bar/foo.java");
        AntGlobTest.assertMatches("**/bar/**/x/**/*.java", "/bar/x/foo.java");
        AntGlobTest.assertMatches("**/bar/**/x/**/*.java", "blah/bar/x/foo.java");
        AntGlobTest.assertMatches("**/bar/**/x/**/*.java", "blah/bar/blah/x/foo.java");
        AntGlobTest.assertMatches("**/bar/**/x/**/*.java", "blah/bar/blah/x/blah/foo.java");
        AntGlobTest.assertNotMatches("**/taskdefs/**/ide", "/ant/proposal/myrmidon/src/main/org/apache/tools/ant/taskdefs/optional/ide/default.ini");
        AntGlobTest.assertMatches("/foo/bar/**", "/foo/bar/foo.java");
        AntGlobTest.assertMatches("/foo/bar/", "/foo/bar/foo.java");
        AntGlobTest.assertMatches("/foo/bar/", "/foo/bar/wombat/foo.java");
    }

    public void testExactPrefixMatching() {
        AntGlobTest.assertTrue((String)"Simple path, implicit", (boolean)AntGlob.isExactPrefixMatcher((String)"/a/"));
        AntGlobTest.assertTrue((String)"Normal path, implicit", (boolean)AntGlob.isExactPrefixMatcher((String)"/a/b/"));
        AntGlobTest.assertTrue((String)"Root path, implicit", (boolean)AntGlob.isExactPrefixMatcher((String)"/"));
        AntGlobTest.assertTrue((String)"Simple path, explicit", (boolean)AntGlob.isExactPrefixMatcher((String)"/a/**"));
        AntGlobTest.assertTrue((String)"Normal path, explicit", (boolean)AntGlob.isExactPrefixMatcher((String)"/a/b/**"));
        AntGlobTest.assertTrue((String)"Root path, explicit", (boolean)AntGlob.isExactPrefixMatcher((String)"/**"));
        AntGlobTest.assertFalse((String)"Relative path, implicit", (boolean)AntGlob.isExactPrefixMatcher((String)"a/"));
        AntGlobTest.assertFalse((String)"Relative path, explicit", (boolean)AntGlob.isExactPrefixMatcher((String)"a/**"));
        AntGlobTest.assertFalse((String)"Empty path", (boolean)AntGlob.isExactPrefixMatcher((String)""));
        AntGlobTest.assertFalse((String)"Simple file path", (boolean)AntGlob.isExactPrefixMatcher((String)"/a"));
        AntGlobTest.assertFalse((String)"Normal file path", (boolean)AntGlob.isExactPrefixMatcher((String)"/a/b"));
    }

    public void testTrailingAsteriskTrimming() {
        AntGlobTest.assertEquals((String)"no asterisks", (String)"/a/", (String)AntGlob.trimTrailingAsterisks((String)"/a/"));
        AntGlobTest.assertEquals((String)"glob on path", (String)"/a/", (String)AntGlob.trimTrailingAsterisks((String)"/a/**"));
        AntGlobTest.assertEquals((String)"glob only", (String)"/", (String)AntGlob.trimTrailingAsterisks((String)"/**"));
        AntGlobTest.assertEquals((String)"asterisks only", (String)"", (String)AntGlob.trimTrailingAsterisks((String)"**"));
        AntGlobTest.assertEquals((String)"empty string", (String)"", (String)AntGlob.trimTrailingAsterisks((String)""));
    }

    private static void assertMatches(String pattern, String path) {
        AntGlob p = new AntGlob(pattern);
        AntGlobTest.assertTrue((String)(pattern + " against " + path), (boolean)p.matches((CharSequence)path));
    }

    private static void assertNotMatches(String pattern, String path) {
        AntGlob p = new AntGlob(pattern);
        AntGlobTest.assertFalse((String)(pattern + " against " + path), (boolean)p.matches((CharSequence)path));
    }
}

