/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.AgeLogScale;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public final class AgeLogScaleTest {
    private long min;
    private long max;
    private AgeLogScale logScale;

    @Before
    public void setUp() throws Exception {
        this.min = 0L;
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(2000, 0, 1);
        this.max = c.getTimeInMillis();
        this.logScale = new AgeLogScale(this.min, this.max);
    }

    @Test
    public void testDateOfIndex() throws Exception {
        int start = 0;
        int total = 10;
        long lastDate = -1L;
        for (int i = start; i <= total; ++i) {
            long dateOfIndex = this.logScale.dateOfIndex(i, total);
            if (lastDate != -1L) {
                Assert.assertTrue((dateOfIndex > lastDate ? 1 : 0) != 0);
            }
            lastDate = dateOfIndex;
        }
        Assert.assertEquals((long)this.logScale.dateOfIndex(start, total), (long)this.min);
        long mid = this.logScale.dateOfIndex(total / 2, total);
        Assert.assertTrue((mid > (this.max - this.min) / 2L ? 1 : 0) != 0);
        Assert.assertEquals((long)this.logScale.dateOfIndex(total, total), (long)this.max);
    }

    @Test
    public void testIndexOfDate() throws Exception {
        int start = 0;
        int total = 10;
        int lastIndex = -1;
        for (int i = start; i < total; ++i) {
            long dateOfIndex = this.logScale.dateOfIndex(i, total);
            int indexOfDate = this.logScale.indexOfDate(dateOfIndex, start, total);
            Assert.assertTrue((indexOfDate >= lastIndex ? 1 : 0) != 0);
            lastIndex = indexOfDate;
        }
        int startIndex = this.logScale.indexOfDate(this.min, start, total);
        Assert.assertEquals((int)startIndex, (int)start);
        long middle = (this.max - this.min) / 2L + this.min;
        int middleIndex = this.logScale.indexOfDate(middle, start, total);
        Assert.assertTrue((middleIndex < total / 2 ? 1 : 0) != 0);
        int endIndex = this.logScale.indexOfDate(this.max, start, total);
        Assert.assertEquals((int)endIndex, (int)total);
    }
}

