/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso.cookie;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import com.cenqua.fisheye.user.embeddedcrowd.sso.cookie.CachedCookieConfigurationService;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CachedCookieConfigurationServiceTest {
    private CachedCookieConfigurationService cookieConfigurationService;
    private CrowdDirectoryService crowdDirectoryServiceMock;
    private RestCrowdClientFactory restCrowdClientFactoryMock;
    private CrowdClient crowdClientMock1;
    private CrowdClient crowdClientMock2;
    private CrowdClient crowdClientMock3;
    private Directory directory1;
    private Directory directory2;
    private Directory directory3;
    private CookieConfiguration cookieConfiguration1;
    private CookieConfiguration cookieConfiguration2;
    private CookieConfiguration cookieConfiguration3;

    @Before
    public void setUp() throws Exception {
        this.crowdDirectoryServiceMock = (CrowdDirectoryService)Mockito.mock(CrowdDirectoryService.class);
        this.restCrowdClientFactoryMock = (RestCrowdClientFactory)Mockito.mock(RestCrowdClientFactory.class);
        this.cookieConfigurationService = new CachedCookieConfigurationService(this.crowdDirectoryServiceMock, this.restCrowdClientFactoryMock);
        this.directory1 = this.createDirectory(1L, DirectoryType.CROWD);
        this.directory2 = this.createDirectory(2L, DirectoryType.CROWD);
        this.directory3 = this.createDirectory(3L, DirectoryType.CUSTOM);
        this.crowdClientMock1 = (CrowdClient)Mockito.mock(CrowdClient.class);
        this.crowdClientMock2 = (CrowdClient)Mockito.mock(CrowdClient.class);
        this.crowdClientMock3 = (CrowdClient)Mockito.mock(CrowdClient.class);
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(1L)).thenReturn((Object)this.directory1);
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(2L)).thenReturn((Object)this.directory2);
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(3L)).thenReturn((Object)this.directory3);
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn(Arrays.asList(this.directory1, this.directory2, this.directory3));
        Mockito.when((Object)this.restCrowdClientFactoryMock.newInstance((ClientProperties)Matchers.any())).thenAnswer(invocation -> {
            String applicationName;
            ClientProperties clientProperties = (ClientProperties)invocation.getArguments()[0];
            switch (applicationName = clientProperties.getApplicationName()) {
                case "directory1": {
                    return this.crowdClientMock1;
                }
                case "directory2": {
                    return this.crowdClientMock2;
                }
                case "directory3": {
                    return this.crowdClientMock3;
                }
            }
            throw new IllegalStateException();
        });
        this.cookieConfiguration1 = new CookieConfiguration("domain1", true, "name1");
        Mockito.when((Object)this.crowdClientMock1.getCookieConfiguration()).thenReturn((Object)this.cookieConfiguration1);
        this.cookieConfiguration2 = new CookieConfiguration("domain1", true, "name1");
        Mockito.when((Object)this.crowdClientMock2.getCookieConfiguration()).thenReturn((Object)this.cookieConfiguration2);
        this.cookieConfiguration3 = new CookieConfiguration("domain1", true, "name1");
        Mockito.when((Object)this.crowdClientMock3.getCookieConfiguration()).thenReturn((Object)this.cookieConfiguration3);
    }

    @Test
    public void testGetCookieConfigurationForDirectory() throws Exception {
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock1, (VerificationMode)Mockito.never())).getCookieConfiguration();
        MatcherAssert.assertThat((Object)this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory1), (Matcher)CoreMatchers.equalTo((Object)this.cookieConfiguration1));
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock1, (VerificationMode)Mockito.times((int)1))).getCookieConfiguration();
        MatcherAssert.assertThat((Object)this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory1), (Matcher)CoreMatchers.equalTo((Object)this.cookieConfiguration1));
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock1, (VerificationMode)Mockito.times((int)1))).getCookieConfiguration();
    }

    @Test
    public void testGetCookieConfigurationForDirectoryInit() throws Exception {
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock1, (VerificationMode)Mockito.never())).getCookieConfiguration();
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock2, (VerificationMode)Mockito.never())).getCookieConfiguration();
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock3, (VerificationMode)Mockito.never())).getCookieConfiguration();
        MatcherAssert.assertThat((Object)this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory1), (Matcher)CoreMatchers.equalTo((Object)this.cookieConfiguration1));
        MatcherAssert.assertThat((Object)this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory2), (Matcher)CoreMatchers.equalTo((Object)this.cookieConfiguration2));
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock1, (VerificationMode)Mockito.times((int)1))).getCookieConfiguration();
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock2, (VerificationMode)Mockito.times((int)1))).getCookieConfiguration();
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock3, (VerificationMode)Mockito.never())).getCookieConfiguration();
        MatcherAssert.assertThat((Object)this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory1), (Matcher)CoreMatchers.equalTo((Object)this.cookieConfiguration1));
        MatcherAssert.assertThat((Object)this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory2), (Matcher)CoreMatchers.equalTo((Object)this.cookieConfiguration2));
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock1, (VerificationMode)Mockito.times((int)1))).getCookieConfiguration();
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock2, (VerificationMode)Mockito.times((int)1))).getCookieConfiguration();
        ((CrowdClient)Mockito.verify((Object)this.crowdClientMock3, (VerificationMode)Mockito.never())).getCookieConfiguration();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetCookieConfigurationForNonCrowdDirectory() throws Exception {
        this.cookieConfigurationService.getCookieConfigurationForDirectory(this.directory3);
    }

    private Directory createDirectory(final long id, final DirectoryType directoryType) {
        return new Directory(){

            @Nullable
            public Set<String> getValues(String key) {
                return null;
            }

            public String getValue(String key) {
                return null;
            }

            public Set<String> getKeys() {
                return null;
            }

            public boolean isEmpty() {
                return false;
            }

            public Long getId() {
                return id;
            }

            public String getName() {
                return "directory" + id;
            }

            public boolean isActive() {
                return false;
            }

            public String getEncryptionType() {
                return null;
            }

            public Map<String, String> getAttributes() {
                return ImmutableMap.of((Object)"application.name", (Object)("directory" + id));
            }

            public Set<OperationType> getAllowedOperations() {
                return null;
            }

            public String getDescription() {
                return null;
            }

            public DirectoryType getType() {
                return directoryType;
            }

            public String getImplementationClass() {
                return null;
            }

            public Date getCreatedDate() {
                return null;
            }

            public Date getUpdatedDate() {
                return null;
            }
        };
    }
}

