/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso.configuration;

import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.RootConfigSSOConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RootConfigSSOConfigurationServiceTest {
    private RootConfigSSOConfigurationService ssoConfigurationService;
    private RootConfig rootConfigMock;

    @Before
    public void setUp() {
        this.rootConfigMock = (RootConfig)Mockito.mock(RootConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.ssoConfigurationService = new RootConfigSSOConfigurationService(this.rootConfigMock);
    }

    @Test
    public void testIsSSOEnabledNoConfigurationSecurity() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getConfig().isSetSecurity()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.isSSOEnabled(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsSSOEnabledNoConfigurationSecurityCrowd() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getConfig().isSetSecurity()).thenReturn((Object)true);
        SecurityType securityType = (SecurityType)Mockito.mock(SecurityType.class);
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity()).thenReturn((Object)securityType);
        Mockito.when((Object)securityType.isSetCrowd()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.isSSOEnabled(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsSSOEnabledCrowdSSOFalse() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getConfig().isSetSecurity()).thenReturn((Object)true);
        SecurityType securityType = (SecurityType)Mockito.mock(SecurityType.class);
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity()).thenReturn((Object)securityType);
        Mockito.when((Object)securityType.isSetCrowd()).thenReturn((Object)true);
        CrowdAuthConfigType crowdAuthConfigType = (CrowdAuthConfigType)Mockito.mock(CrowdAuthConfigType.class);
        Mockito.when((Object)securityType.getCrowd()).thenReturn((Object)crowdAuthConfigType);
        Mockito.when((Object)crowdAuthConfigType.getSsoEnabled()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.isSSOEnabled(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsSSOEnabledCrowdSSOTrue() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getConfig().isSetSecurity()).thenReturn((Object)true);
        SecurityType securityType = (SecurityType)Mockito.mock(SecurityType.class);
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity()).thenReturn((Object)securityType);
        Mockito.when((Object)securityType.isSetCrowd()).thenReturn((Object)true);
        CrowdAuthConfigType crowdAuthConfigType = (CrowdAuthConfigType)Mockito.mock(CrowdAuthConfigType.class);
        Mockito.when((Object)securityType.getCrowd()).thenReturn((Object)crowdAuthConfigType);
        Mockito.when((Object)crowdAuthConfigType.getSsoEnabled()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.isSSOEnabled(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testConfigXmlPropertiesIgnored() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getConfig().isSetSecurity()).thenReturn((Object)true);
        SecurityType securityType = (SecurityType)Mockito.mock(SecurityType.class);
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity()).thenReturn((Object)securityType);
        Mockito.when((Object)securityType.isSetCrowd()).thenReturn((Object)true);
        CrowdAuthConfigType crowdAuthConfigType = (CrowdAuthConfigType)Mockito.mock(CrowdAuthConfigType.class);
        Mockito.when((Object)securityType.getCrowd()).thenReturn((Object)crowdAuthConfigType);
        Mockito.when((Object)crowdAuthConfigType.getCrowdProperties()).thenReturn((Object)"crowd.property1=value1\ncrowd.property2=value2\ncrowd.property3=value3\n");
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("crowd.property1"), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("crowd.property2"), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("crowd.property3"), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetCrowdPropertiesDefaults() throws Exception {
        Mockito.when((Object)this.rootConfigMock.getConfig().isSetSecurity()).thenReturn((Object)true);
        SecurityType securityType = (SecurityType)Mockito.mock(SecurityType.class);
        Mockito.when((Object)this.rootConfigMock.getConfig().getSecurity()).thenReturn((Object)securityType);
        Mockito.when((Object)securityType.isSetCrowd()).thenReturn((Object)true);
        CrowdAuthConfigType crowdAuthConfigType = (CrowdAuthConfigType)Mockito.mock(CrowdAuthConfigType.class);
        Mockito.when((Object)securityType.getCrowd()).thenReturn((Object)crowdAuthConfigType);
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("session.validationinterval"), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("http.timeout"), (Matcher)Matchers.equalTo((Object)"5000"));
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("socket.timeout"), (Matcher)Matchers.equalTo((Object)"20000"));
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("cookie.tokenkey"), (Matcher)Matchers.equalTo((Object)"crowd.token_key"));
        MatcherAssert.assertThat((Object)this.ssoConfigurationService.getCrowdProperties().getProperty("session.lastvalidation"), (Matcher)Matchers.equalTo((Object)"fisheye.crowd.session.lastvalidation"));
    }
}

