/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso.authenticator;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import com.cenqua.fisheye.user.embeddedcrowd.sso.authenticator.DefaultAuthenticatorFactoryService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.SSOConfigurationService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.cookie.CookieConfigurationService;
import com.google.common.collect.ImmutableMap;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class DefaultAuthenticatorFactoryServiceTest {
    private DefaultAuthenticatorFactoryService authenticatorService;
    private RestCrowdClientFactory restCrowdClientFactoryMock;
    private SSOConfigurationService ssoConfigurationServiceMock;
    private CookieConfigurationService cookieConfigurationServiceMock;
    private Directory directoryMock1;
    private CookieConfiguration cookieConfiguration1;
    private CrowdClient crowdClientMock;

    @Before
    public void setUp() {
        this.restCrowdClientFactoryMock = (RestCrowdClientFactory)Mockito.mock(RestCrowdClientFactory.class);
        this.ssoConfigurationServiceMock = (SSOConfigurationService)Mockito.mock(SSOConfigurationService.class);
        this.cookieConfigurationServiceMock = (CookieConfigurationService)Mockito.mock(CookieConfigurationService.class);
        this.authenticatorService = new DefaultAuthenticatorFactoryService(this.restCrowdClientFactoryMock, this.ssoConfigurationServiceMock, this.cookieConfigurationServiceMock);
        this.directoryMock1 = (Directory)Mockito.mock(Directory.class);
        this.cookieConfiguration1 = (CookieConfiguration)Mockito.mock(CookieConfiguration.class);
        this.crowdClientMock = (CrowdClient)Mockito.mock(CrowdClient.class);
    }

    @Test
    public void testCreateAuthenticatorForDirectory() throws Exception {
        Properties configXmlCrowdProperties = new Properties();
        configXmlCrowdProperties.put("cookie.tokenkey", "cookie.token1");
        configXmlCrowdProperties.put("application.login.url", "app.url1");
        configXmlCrowdProperties.put("http.proxy.username", "app.username1");
        configXmlCrowdProperties.put("http.proxy.password", "app.password1");
        configXmlCrowdProperties.put("http.proxy.host", "proxy.host1");
        configXmlCrowdProperties.put("http.proxy.port", "8080");
        configXmlCrowdProperties.put("http.proxy.username", "proxy.username");
        configXmlCrowdProperties.put("http.proxy.password", "proxy.password");
        Mockito.when((Object)this.ssoConfigurationServiceMock.getCrowdProperties()).thenReturn((Object)configXmlCrowdProperties);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"cookie.token2");
        Mockito.when((Object)this.cookieConfiguration1.getDomain()).thenReturn((Object)"domain2");
        ArgumentCaptor clientPropertiesArgumentCaptor = ArgumentCaptor.forClass(ClientProperties.class);
        Mockito.when((Object)this.restCrowdClientFactoryMock.newInstance((ClientProperties)clientPropertiesArgumentCaptor.capture())).thenReturn((Object)this.crowdClientMock);
        ImmutableMap directoryAttributes = ImmutableMap.of((Object)"application.login.url", (Object)"app.url2", (Object)"application.name", (Object)"app.username2", (Object)"application.password", (Object)"app.password2");
        Mockito.when((Object)this.directoryMock1.getAttributes()).thenReturn((Object)directoryAttributes);
        CrowdHttpAuthenticator authenticator = this.authenticatorService.createAuthenticatorForDirectory(this.directoryMock1);
        MatcherAssert.assertThat((Object)authenticator, (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)IsNull.nullValue())));
        ClientProperties clientProperties = (ClientProperties)clientPropertiesArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)clientProperties.getCookieTokenKey(), (Matcher)Matchers.equalTo((Object)"cookie.token2"));
        MatcherAssert.assertThat((Object)clientProperties.getSSOCookieDomainName(), (Matcher)Matchers.equalTo((Object)"domain2"));
        MatcherAssert.assertThat((Object)clientProperties.getApplicationAuthenticationURL(), (Matcher)Matchers.equalTo((Object)"app.url2"));
        MatcherAssert.assertThat((Object)clientProperties.getApplicationAuthenticationContext().getName(), (Matcher)Matchers.equalTo((Object)"app.username2"));
        MatcherAssert.assertThat((Object)clientProperties.getApplicationAuthenticationContext().getCredential().getCredential(), (Matcher)Matchers.equalTo((Object)"app.password2"));
        MatcherAssert.assertThat((Object)clientProperties.getHttpProxyHost(), (Matcher)Matchers.equalTo((Object)"proxy.host1"));
        MatcherAssert.assertThat((Object)clientProperties.getHttpProxyPort(), (Matcher)Matchers.equalTo((Object)"8080"));
        MatcherAssert.assertThat((Object)clientProperties.getHttpProxyUsername(), (Matcher)Matchers.equalTo((Object)"proxy.username"));
        MatcherAssert.assertThat((Object)clientProperties.getHttpProxyPassword(), (Matcher)Matchers.equalTo((Object)"proxy.password"));
    }
}

