/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.AuthenticationState;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.user.User;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.embeddedcrowd.sso.DefaultEmbeddedCrowdSSOService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.authenticator.AuthenticatorFactoryService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.cookie.CookieConfigurationService;
import com.google.common.base.Optional;
import com.google.gwt.dev.util.collect.Lists;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultEmbeddedCrowdSSOServiceTest {
    public static final String DOMAIN = "foo.com";
    private DefaultEmbeddedCrowdSSOService embeddedCrowdSSOService;
    private CrowdService crowdServiceMock;
    private CrowdDirectoryService crowdDirectoryServiceMock;
    private AuthenticatorFactoryService authenticatorFactoryService;
    private CookieConfigurationService cookieConfigurationServiceMock;
    private HttpServletRequest httpServletRequestMock;
    private HttpServletResponse httpServletResponseMock;
    private User userMock1;
    private User userMock2;
    private Directory directoryMock1;
    private Directory directoryMock2;
    private CrowdHttpAuthenticator crowdHttpAuthenticatorMock1;
    private CrowdHttpAuthenticator crowdHttpAuthenticatorMock2;
    private CookieConfiguration cookieConfiguration1;
    private CookieConfiguration cookieConfiguration2;
    private AuthenticationState authenticationState1;
    private AuthenticationState authenticationState2;
    private Principal principal1;
    private Principal principal2;

    @Before
    public void setUp() throws Exception {
        this.crowdServiceMock = (CrowdService)Mockito.mock(CrowdService.class);
        this.crowdDirectoryServiceMock = (CrowdDirectoryService)Mockito.mock(CrowdDirectoryService.class);
        this.authenticatorFactoryService = (AuthenticatorFactoryService)Mockito.mock(AuthenticatorFactoryService.class);
        this.cookieConfigurationServiceMock = (CookieConfigurationService)Mockito.mock(CookieConfigurationService.class);
        this.embeddedCrowdSSOService = new DefaultEmbeddedCrowdSSOService(this.crowdServiceMock, this.crowdDirectoryServiceMock, this.authenticatorFactoryService, this.cookieConfigurationServiceMock);
        this.httpServletRequestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.httpServletResponseMock = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.userMock1 = (User)Mockito.mock(User.class);
        this.userMock2 = (User)Mockito.mock(User.class);
        this.directoryMock1 = (Directory)Mockito.mock(Directory.class);
        this.directoryMock2 = (Directory)Mockito.mock(Directory.class);
        this.crowdHttpAuthenticatorMock1 = (CrowdHttpAuthenticator)Mockito.mock(CrowdHttpAuthenticator.class);
        this.crowdHttpAuthenticatorMock2 = (CrowdHttpAuthenticator)Mockito.mock(CrowdHttpAuthenticator.class);
        this.cookieConfiguration1 = (CookieConfiguration)Mockito.mock(CookieConfiguration.class);
        this.cookieConfiguration2 = (CookieConfiguration)Mockito.mock(CookieConfiguration.class);
        this.authenticationState1 = (AuthenticationState)Mockito.mock(AuthenticationState.class);
        this.authenticationState2 = (AuthenticationState)Mockito.mock(AuthenticationState.class);
        this.principal1 = (Principal)Mockito.mock(Principal.class);
        this.principal2 = (Principal)Mockito.mock(Principal.class);
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticateWhenUserNotFound() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("nonexisting")).thenReturn(null);
        this.embeddedCrowdSSOService.authenticate("nonexisting", "password", this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test
    public void testAuthenticateWhenUserFromNonCrowdDirectory() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingNonCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingNonCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CUSTOM);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.authenticate("existingNonCrowd", "password", this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.absent()));
    }

    @Test
    public void testAuthenticateWhenUserFromCrowdDirectory() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.authenticate(this.httpServletRequestMock, this.httpServletResponseMock, "existingCrowd", "password")).thenReturn((Object)this.userMock1);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.authenticate("existingCrowd", "password", this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)this.userMock1)));
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticateWhenAuthenticatorThrows() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.authenticate(this.httpServletRequestMock, this.httpServletResponseMock, "existingCrowd", "password")).thenThrow(new Throwable[]{new ApplicationPermissionException("testAuthenticateWhenAuthenticatorThrows")});
        this.embeddedCrowdSSOService.authenticate("existingCrowd", "password", this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test(expected=AuthenticationException.class)
    public void testLogoutWhenUserNotFound() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("nonexisting")).thenReturn(null);
        this.embeddedCrowdSSOService.logout("nonexisting", this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test
    public void testLogoutWhenUserFromNonCrowdDirectory() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingNonCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingNonCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CUSTOM);
        this.embeddedCrowdSSOService.logout("existingNonCrowd", this.httpServletRequestMock, this.httpServletResponseMock);
        ((AuthenticatorFactoryService)Mockito.verify((Object)this.authenticatorFactoryService, (VerificationMode)Mockito.never())).createAuthenticatorForDirectory((Directory)org.mockito.Matchers.any());
    }

    @Test
    public void testLogoutWhenUserFromCrowdDirectory() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        this.embeddedCrowdSSOService.logout("existingCrowd", this.httpServletRequestMock, this.httpServletResponseMock);
        ((CrowdHttpAuthenticator)Mockito.verify((Object)this.crowdHttpAuthenticatorMock1, (VerificationMode)Mockito.times((int)1))).logout(this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test(expected=AuthenticationException.class)
    public void testLogoutWhenAuthenticatorThrows() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        ((CrowdHttpAuthenticator)Mockito.doThrow((Throwable)new ApplicationPermissionException("testAuthenticateWhenAuthenticatorThrows")).when((Object)this.crowdHttpAuthenticatorMock1)).logout(this.httpServletRequestMock, this.httpServletResponseMock);
        this.embeddedCrowdSSOService.logout("existingCrowd", this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test
    public void testGetToken2CrowdDirectoriesWithTokenOneReturnsInvalidSecondReturnsValid() throws Exception {
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn((Object)Lists.create((Object[])new Directory[]{this.directoryMock1, this.directoryMock2}));
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.directoryMock2.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock2)).thenReturn((Object)this.cookieConfiguration2);
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration2.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.httpServletRequestMock.getAttribute("crowd.token_key")).thenReturn((Object)"token.1234");
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock2)).thenReturn((Object)this.crowdHttpAuthenticatorMock2);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState2);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)false);
        Mockito.when((Object)this.authenticationState2.isAuthenticated()).thenReturn((Object)true);
        Mockito.when((Object)this.authenticationState2.getAuthenticatedPrincipal()).thenReturn((Object)Optional.of((Object)this.principal2));
        Mockito.when((Object)this.principal2.getName()).thenReturn((Object)"user1234");
        Mockito.when((Object)this.crowdServiceMock.getUser("user1234")).thenReturn((Object)this.userMock2);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.getUserFromToken(this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)this.userMock2)));
    }

    @Test
    public void testGetToken2CrowdDirectoriesWithTokenBothReturnInvalid() throws Exception {
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn((Object)Lists.create((Object[])new Directory[]{this.directoryMock1, this.directoryMock2}));
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.directoryMock2.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock2)).thenReturn((Object)this.cookieConfiguration2);
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration2.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.httpServletRequestMock.getAttribute("crowd.token_key")).thenReturn((Object)"token.1234");
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock2)).thenReturn((Object)this.crowdHttpAuthenticatorMock2);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState2);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)false);
        Mockito.when((Object)this.authenticationState2.isAuthenticated()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.getUserFromToken(this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.absent()));
    }

    @Test
    public void testGetToken2CrowdDirectoriesWithTokenOneReturnsCookieWithNullNameNullDomain() throws Exception {
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn(null);
        Mockito.when((Object)this.cookieConfiguration1.getDomain()).thenReturn(null);
        this.testGetToken2CrowdDirectories(this.userMock2);
        ((AuthenticatorFactoryService)Mockito.verify((Object)this.authenticatorFactoryService, (VerificationMode)Mockito.never())).createAuthenticatorForDirectory(this.directoryMock1);
    }

    @Test
    public void testGetToken2CrowdDirectoriesWithTokenOneReturnsCookieWithNonNullNameNullDomain() throws Exception {
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration1.getDomain()).thenReturn(null);
        this.testGetToken2CrowdDirectories(this.userMock1);
    }

    @Test
    public void testGetToken2CrowdDirectoriesWithTokenOneReturnsCookieWithNullNameNonNullDomain() throws Exception {
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn(null);
        Mockito.when((Object)this.cookieConfiguration1.getDomain()).thenReturn((Object)DOMAIN);
        this.testGetToken2CrowdDirectories(this.userMock2);
        ((AuthenticatorFactoryService)Mockito.verify((Object)this.authenticatorFactoryService, (VerificationMode)Mockito.never())).createAuthenticatorForDirectory(this.directoryMock1);
    }

    @Test
    public void testGetToken2CrowdDirectoriesWithTokenOneReturnsCookieWithNonNullNameNonNullDomain() throws Exception {
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration1.getDomain()).thenReturn((Object)DOMAIN);
        this.testGetToken2CrowdDirectories(this.userMock1);
    }

    private void testGetToken2CrowdDirectories(User expectedUser) throws Exception {
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn((Object)Lists.create((Object[])new Directory[]{this.directoryMock1, this.directoryMock2}));
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.directoryMock2.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock2)).thenReturn((Object)this.cookieConfiguration2);
        Mockito.when((Object)this.cookieConfiguration2.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration2.getDomain()).thenReturn((Object)DOMAIN);
        Mockito.when((Object)this.httpServletRequestMock.getAttribute("crowd.token_key")).thenReturn((Object)"token.1234");
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock2)).thenReturn((Object)this.crowdHttpAuthenticatorMock2);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState2);
        Mockito.when((Object)this.httpServletRequestMock.getServerName()).thenReturn((Object)DOMAIN);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)true);
        Mockito.when((Object)this.authenticationState2.isAuthenticated()).thenReturn((Object)true);
        Mockito.when((Object)this.authenticationState1.getAuthenticatedPrincipal()).thenReturn((Object)Optional.of((Object)this.principal1));
        Mockito.when((Object)this.authenticationState2.getAuthenticatedPrincipal()).thenReturn((Object)Optional.of((Object)this.principal2));
        Mockito.when((Object)this.principal1.getName()).thenReturn((Object)"user1");
        Mockito.when((Object)this.principal2.getName()).thenReturn((Object)"user2");
        Mockito.when((Object)this.crowdServiceMock.getUser("user1")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.crowdServiceMock.getUser("user2")).thenReturn((Object)this.userMock2);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.getUserFromToken(this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)expectedUser)));
    }

    @Test
    public void testGetToken2CrowdDirectoriesWhenOneThrowsSecondReturnsValid() throws Exception {
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn((Object)Lists.create((Object[])new Directory[]{this.directoryMock1, this.directoryMock2}));
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.directoryMock2.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock2)).thenReturn((Object)this.cookieConfiguration2);
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration2.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.httpServletRequestMock.getAttribute("crowd.token_key")).thenReturn((Object)"token.1234");
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock2)).thenReturn((Object)this.crowdHttpAuthenticatorMock2);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenThrow(new Throwable[]{new OperationFailedException()});
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState2);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)false);
        Mockito.when((Object)this.authenticationState2.isAuthenticated()).thenReturn((Object)true);
        Mockito.when((Object)this.authenticationState2.getAuthenticatedPrincipal()).thenReturn((Object)Optional.of((Object)this.principal2));
        Mockito.when((Object)this.principal2.getName()).thenReturn((Object)"user1234");
        Mockito.when((Object)this.crowdServiceMock.getUser("user1234")).thenReturn((Object)this.userMock2);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.getUserFromToken(this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)this.userMock2)));
    }

    @Test(expected=AuthenticationException.class)
    public void testGetToken2CrowdDirectoriesWhenBothThrows() throws Exception {
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn((Object)Lists.create((Object[])new Directory[]{this.directoryMock1, this.directoryMock2}));
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.directoryMock2.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock2)).thenReturn((Object)this.cookieConfiguration2);
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration2.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.httpServletRequestMock.getAttribute("crowd.token_key")).thenReturn((Object)"token.1234");
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock2)).thenReturn((Object)this.crowdHttpAuthenticatorMock2);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenThrow(new Throwable[]{new OperationFailedException()});
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenThrow(new Throwable[]{new OperationFailedException()});
        this.embeddedCrowdSSOService.getUserFromToken(this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test
    public void testGetUserFromTokenWhenCheckAuthenticatedReturnsNoPrincipal() throws Exception {
        Mockito.when((Object)this.crowdDirectoryServiceMock.findAllDirectories()).thenReturn((Object)Lists.create((Object[])new Directory[]{this.directoryMock1, this.directoryMock2}));
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.directoryMock2.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock1)).thenReturn((Object)this.cookieConfiguration1);
        Mockito.when((Object)this.cookieConfigurationServiceMock.getCookieConfigurationForDirectory(this.directoryMock2)).thenReturn((Object)this.cookieConfiguration2);
        Mockito.when((Object)this.cookieConfiguration1.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.cookieConfiguration2.getName()).thenReturn((Object)"crowd.token_key");
        Mockito.when((Object)this.httpServletRequestMock.getAttribute("crowd.token_key")).thenReturn((Object)"token.1234");
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock2)).thenReturn((Object)this.crowdHttpAuthenticatorMock2);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenThrow(new Throwable[]{new OperationFailedException()});
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState2);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)false);
        Mockito.when((Object)this.authenticationState2.isAuthenticated()).thenReturn((Object)true);
        Mockito.when((Object)this.authenticationState2.getAuthenticatedPrincipal()).thenReturn((Object)Optional.absent());
        Mockito.when((Object)this.crowdHttpAuthenticatorMock2.getUser(this.httpServletRequestMock)).thenReturn((Object)this.userMock2);
        Mockito.when((Object)this.userMock2.getName()).thenReturn((Object)"user1234");
        Mockito.when((Object)this.crowdServiceMock.getUser("user1234")).thenReturn((Object)this.userMock2);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.getUserFromToken(this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)this.userMock2)));
        ((CrowdHttpAuthenticator)Mockito.verify((Object)this.crowdHttpAuthenticatorMock2, (VerificationMode)Mockito.times((int)1))).getUser(this.httpServletRequestMock);
    }

    @Test(expected=AuthenticationException.class)
    public void testIsRequestUserStillValidWhenUserNotFound() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("nonexisting")).thenReturn(null);
        this.embeddedCrowdSSOService.isRequestUserStillValid("nonexisting", this.httpServletRequestMock, this.httpServletResponseMock);
    }

    @Test
    public void testIsRequestUserStillValidWhenUserFromNonCrowdDirectory() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingNonCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingNonCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CUSTOM);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.isRequestUserStillValid("existingNonCrowd", this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.absent()));
    }

    @Test
    public void testIsRequestUserStillValidWhenUserFromCrowdDirectoryAuthenticatorReturnsTrue() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState1);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.isRequestUserStillValid("existingCrowd", this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)true)));
    }

    @Test
    public void testIsRequestUserStillValidWhenUserFromCrowdDirectoryAuthenticatorReturnsFalse() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenReturn((Object)this.authenticationState1);
        Mockito.when((Object)this.authenticationState1.isAuthenticated()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)this.embeddedCrowdSSOService.isRequestUserStillValid("existingCrowd", this.httpServletRequestMock, this.httpServletResponseMock), (Matcher)Matchers.equalTo((Object)Optional.of((Object)false)));
    }

    @Test(expected=AuthenticationException.class)
    public void testIsRequestUserStillValidWhenAuthenticatorThrows() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.getUser("existingCrowd")).thenReturn((Object)this.userMock1);
        Mockito.when((Object)this.userMock1.getDirectoryId()).thenReturn((Object)10L);
        Mockito.when((Object)this.userMock1.getName()).thenReturn((Object)"existingCrowd");
        Mockito.when((Object)this.crowdDirectoryServiceMock.findDirectoryById(10L)).thenReturn((Object)this.directoryMock1);
        Mockito.when((Object)this.directoryMock1.getType()).thenReturn((Object)DirectoryType.CROWD);
        Mockito.when((Object)this.authenticatorFactoryService.createAuthenticatorForDirectory(this.directoryMock1)).thenReturn((Object)this.crowdHttpAuthenticatorMock1);
        Mockito.when((Object)this.crowdHttpAuthenticatorMock1.checkAuthenticated(this.httpServletRequestMock, this.httpServletResponseMock)).thenThrow(new Throwable[]{new OperationFailedException("testAuthenticateWhenAuthenticatorThrows")});
        this.embeddedCrowdSSOService.isRequestUserStillValid("existingCrowd", this.httpServletRequestMock, this.httpServletResponseMock);
    }
}

