/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.embeddedcrowd.DefaultEmbeddedCrowdAuth;
import com.cenqua.fisheye.user.embeddedcrowd.EmbeddedCrowdAuthTok;
import com.cenqua.fisheye.user.embeddedcrowd.sso.EmbeddedCrowdSSOService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.SSOConfigurationService;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.DummyHttpServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EmbeddedCrowdAuthTest {
    @Mock
    private CrowdService crowdServiceMock;
    @Mock
    private EmbeddedCrowdSSOService embeddedCrowdSSOService;
    @Mock
    SSOConfigurationService ssoConfigurationService;
    @InjectMocks
    private DefaultEmbeddedCrowdAuth embeddedCrowdAuth;

    @Test
    public void testAuthenticate_shouldReturnNullOnAuthenticationFailure() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.authenticate(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString())).thenThrow(new Throwable[]{new FailedAuthenticationException()});
        EmbeddedCrowdAuthTok authTok = this.embeddedCrowdAuth.authenticate("username", "password", (HttpServletRequest)new DummyHttpServletRequest(), (HttpServletResponse)new DummyHttpServletResponse());
        MatcherAssert.assertThat((Object)authTok, (Matcher)Matchers.equalTo(null));
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticate_shouldThrowOnAuthenticationError() throws Exception {
        Mockito.when((Object)this.crowdServiceMock.authenticate(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString())).thenThrow(new Throwable[]{new OperationFailedException()});
        this.embeddedCrowdAuth.authenticate("username", "password", (HttpServletRequest)new DummyHttpServletRequest(), (HttpServletResponse)new DummyHttpServletResponse());
    }
}

