/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationCompleteEvent;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationStartedEvent;
import com.cenqua.fisheye.user.embeddedcrowd.DefaultUserSynchronizationStatusManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultUserSynchronizationStatusManagerTest {
    @Mock
    EventPublisher eventPublisher;
    @InjectMocks
    DefaultUserSynchronizationStatusManager userSyncStatusManager;

    @Test
    public void shouldTrackSyncStatus() throws Exception {
        this.userSyncStatusManager.onRemoteDirectorySynchronisationStartedEvent(new RemoteDirectorySynchronisationStartedEvent(1L));
        this.userSyncStatusManager.onRemoteDirectorySynchronisationStartedEvent(new RemoteDirectorySynchronisationStartedEvent(2L));
        this.userSyncStatusManager.onRemoteDirectorySynchronisedEvent(this.createRemoteDirectorySynchronisedEvent(2L));
        boolean inProgressWhenStarted = this.userSyncStatusManager.isSynchronisationInProgress(1L);
        boolean inProgressWhenEnded = this.userSyncStatusManager.isSynchronisationInProgress(2L);
        boolean inProgressWhenNoActivity = this.userSyncStatusManager.isSynchronisationInProgress(3L);
        Assert.assertTrue((boolean)inProgressWhenStarted);
        Assert.assertFalse((boolean)inProgressWhenEnded);
        Assert.assertFalse((boolean)inProgressWhenNoActivity);
    }

    @Test
    public void shouldPublishEvents() throws Exception {
        this.userSyncStatusManager.onRemoteDirectorySynchronisedEvent(this.createRemoteDirectorySynchronisedEvent(123L));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish((Object)new RemoteDirectorySynchronisationCompleteEvent(123L));
    }

    @Test
    public void shouldHandleNextSyncStartedBeforePreviousCompletes() throws Exception {
        this.userSyncStatusManager.onRemoteDirectorySynchronisationStartedEvent(new RemoteDirectorySynchronisationStartedEvent(1L));
        this.userSyncStatusManager.onRemoteDirectorySynchronisationStartedEvent(new RemoteDirectorySynchronisationStartedEvent(1L));
        boolean inProgressWithTwo = this.userSyncStatusManager.isSynchronisationInProgress(1L);
        this.userSyncStatusManager.onRemoteDirectorySynchronisedEvent(this.createRemoteDirectorySynchronisedEvent(1L));
        boolean inProgressWithOne = this.userSyncStatusManager.isSynchronisationInProgress(1L);
        this.userSyncStatusManager.onRemoteDirectorySynchronisedEvent(this.createRemoteDirectorySynchronisedEvent(1L));
        boolean inProgressWithZero = this.userSyncStatusManager.isSynchronisationInProgress(1L);
        Assert.assertTrue((boolean)inProgressWithTwo);
        Assert.assertTrue((boolean)inProgressWithOne);
        Assert.assertFalse((boolean)inProgressWithZero);
    }

    private RemoteDirectorySynchronisedEvent createRemoteDirectorySynchronisedEvent(long directoryId) {
        RemoteDirectory remoteDirectory = (RemoteDirectory)Mockito.mock(RemoteDirectory.class);
        Mockito.when((Object)remoteDirectory.getDirectoryId()).thenReturn((Object)directoryId);
        return new RemoteDirectorySynchronisedEvent((Object)this, remoteDirectory);
    }
}

