/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.embeddedcrowd.DefaultEmbeddedCrowdAuth;
import com.cenqua.fisheye.user.embeddedcrowd.EmbeddedCrowdAuthTok;
import com.cenqua.fisheye.user.embeddedcrowd.sso.EmbeddedCrowdSSOService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.SSOConfigurationService;
import com.google.common.base.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultEmbeddedCrowdAuthTest {
    @Mock
    CrowdService crowdService;
    @Mock
    EmbeddedCrowdSSOService embeddedCrowdSSOService;
    @Mock
    SSOConfigurationService ssoConfigurationService;
    HttpServletRequest req = new MockHttpServletRequest();
    HttpServletResponse resp = new MockHttpServletResponse();
    @InjectMocks
    DefaultEmbeddedCrowdAuth auth;
    private User user = ImmutableUser.newUser().name("user").toUser();

    @Test
    public void testAuthenticate_shouldntFailIfSSOFails() throws Exception {
        Mockito.when((Object)this.crowdService.authenticate(this.user.getName(), "pass")).thenReturn((Object)this.user);
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.authenticate(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString(), (HttpServletRequest)org.mockito.Matchers.any(), (HttpServletResponse)org.mockito.Matchers.any())).thenThrow(new Throwable[]{new AuthenticationException("Ni!", null)});
        EmbeddedCrowdAuthTok result = this.auth.authenticate(this.user.getName(), "pass", this.req, this.resp);
        Assert.assertThat((Object)result.getUsername(), (Matcher)Matchers.equalTo((Object)this.user.getName()));
        Assert.assertThat((Object)result.isSsoAuthenticated(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAuthenticate_shouldTrySSOAuth() throws Exception {
        Mockito.when((Object)this.crowdService.authenticate(this.user.getName(), "pass")).thenReturn((Object)this.user);
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.authenticate(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString(), (HttpServletRequest)org.mockito.Matchers.any(), (HttpServletResponse)org.mockito.Matchers.any())).thenReturn((Object)Optional.absent());
        EmbeddedCrowdAuthTok result = this.auth.authenticate("user", "pass", this.req, this.resp);
        Assert.assertThat((Object)result.getUsername(), (Matcher)Matchers.equalTo((Object)this.user.getName()));
        Assert.assertThat((Object)result.isSsoAuthenticated(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAuthenticate_shouldDoSSOAuth() throws Exception {
        Mockito.when((Object)this.crowdService.authenticate(this.user.getName(), "pass")).thenReturn((Object)this.user);
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.authenticate(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString(), (HttpServletRequest)org.mockito.Matchers.any(), (HttpServletResponse)org.mockito.Matchers.any())).thenReturn((Object)Optional.of((Object)this.user));
        EmbeddedCrowdAuthTok result = this.auth.authenticate("user", "pass", this.req, this.resp);
        Assert.assertThat((Object)result.getUsername(), (Matcher)Matchers.equalTo((Object)this.user.getName()));
        Assert.assertThat((Object)result.isSsoAuthenticated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetToken() throws Exception {
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.getUserFromToken(this.req, this.resp)).thenReturn((Object)Optional.of((Object)this.user));
        AuthTok token = this.auth.getToken(this.req, this.resp);
        Assert.assertThat((Object)token.getUsername(), (Matcher)Matchers.is((Object)this.user.getName()));
    }

    @Test
    public void testGetToken_nullWhenNotSSOUser() throws Exception {
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.getUserFromToken(this.req, this.resp)).thenReturn((Object)Optional.absent());
        AuthTok token = this.auth.getToken(this.req, this.resp);
        Assert.assertThat((Object)token, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetToken_nullWhenNoSSO() throws Exception {
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)false);
        AuthTok token = this.auth.getToken(this.req, this.resp);
        Assert.assertThat((Object)token, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetToken_nullWhenFails() throws Exception {
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.getUserFromToken(this.req, this.resp)).thenThrow(new Throwable[]{new AuthenticationException(null)});
        AuthTok token = this.auth.getToken(this.req, this.resp);
        Assert.assertThat((Object)token, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testIsRequestStillValid() throws Exception {
        UserLogin userLogin = new UserLogin(new FecruUser("user"), (AuthTok)new EmbeddedCrowdAuthTok(this.user, true), (LoginCookie)Mockito.mock(LoginCookie.class));
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.isRequestUserStillValid("user", this.req, this.resp)).thenReturn((Object)Optional.of((Object)false));
        boolean result = this.auth.isRequestUserStillValid(userLogin, this.req, this.resp);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsRequestStillValid_shouldPassForNonSSOUsers() throws Exception {
        UserLogin userLogin = new UserLogin(new FecruUser("user"), (AuthTok)new EmbeddedCrowdAuthTok(this.user, true), (LoginCookie)Mockito.mock(LoginCookie.class));
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.isRequestUserStillValid("user", this.req, this.resp)).thenReturn((Object)Optional.absent());
        boolean result = this.auth.isRequestUserStillValid(userLogin, this.req, this.resp);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsRequestStillValid_shouldFailIfRemoteFails() throws Exception {
        UserLogin userLogin = new UserLogin(new FecruUser("user"), (AuthTok)new EmbeddedCrowdAuthTok(this.user, true), (LoginCookie)Mockito.mock(LoginCookie.class));
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.embeddedCrowdSSOService.isRequestUserStillValid("user", this.req, this.resp)).thenThrow(new Throwable[]{new AuthenticationException(null)});
        boolean result = this.auth.isRequestUserStillValid(userLogin, this.req, this.resp);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsRequestStillValid_shouldntRunForNonSSOSessions() throws Exception {
        UserLogin userLogin = new UserLogin(new FecruUser("user"), (AuthTok)new EmbeddedCrowdAuthTok(this.user, false), (LoginCookie)Mockito.mock(LoginCookie.class));
        Mockito.when((Object)this.ssoConfigurationService.isSSOEnabled()).thenReturn((Object)true);
        boolean result = this.auth.isRequestUserStillValid(userLogin, this.req, this.resp);
        ((EmbeddedCrowdSSOService)Mockito.verify((Object)this.embeddedCrowdSSOService, (VerificationMode)Mockito.never())).isRequestUserStillValid(org.mockito.Matchers.anyString(), (HttpServletRequest)org.mockito.Matchers.any(), (HttpServletResponse)org.mockito.Matchers.any());
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)true));
    }
}

