/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserRenamer;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchDAO;
import com.cenqua.fisheye.web.WaybackSpec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class UserRenamerTest {
    private UserRenamer renamer;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private LoginCookieDAO loginCookieDAO;
    @Autowired
    private WatchDAO watchDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private EventPublisher eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);

    @Before
    public void setUp() throws Exception {
        this.renamer = new UserRenamer(this.loginCookieDAO, this.userDAO, this.eventPublisher);
    }

    @Test
    public void testRename() throws Exception {
        FecruUser matt = new FecruUser("matt");
        FecruUser joe = new FecruUser("joe");
        this.userDAO.create(matt);
        this.userDAO.create(joe);
        this.watchDAO.add(new Watch(matt, "repo1", new Path((CharSequence)"/repo1/matt"), new WaybackSpec()));
        this.watchDAO.add(new Watch(joe, "repo2", new Path((CharSequence)"/repo2/joe"), new WaybackSpec()));
        LoginCookie mattCookie = LoginCookie.createRememberMeCookie((FecruUser)matt, (String)"12345");
        LoginCookie joeCookie = LoginCookie.createRememberMeCookie((FecruUser)joe, (String)"12345");
        this.loginCookieDAO.addCookie(mattCookie);
        this.loginCookieDAO.addCookie(joeCookie);
        this.renamer.rename("matt", "mac");
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        MatcherAssert.assertThat((Object)this.userDAO.getByUsername("joe"), (Matcher)Matchers.notNullValue());
        FecruUser mac = this.userDAO.getByUsername("mac");
        MatcherAssert.assertThat((Object)mac, (Matcher)Matchers.notNullValue());
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish((Object)new UserRenamedEvent("matt", "mac"));
        MatcherAssert.assertThat((Object)((Watch)this.watchDAO.getWatchesForRep("repo1").iterator().next()).getUser(), (Matcher)Matchers.is((Object)mac));
        MatcherAssert.assertThat((Object)((Watch)this.watchDAO.getWatchesForRep("repo2").iterator().next()).getUser(), (Matcher)Matchers.is((Object)joe));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookie(mattCookie.getLoginId()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookie(joeCookie.getLoginId()), (Matcher)CoreMatchers.notNullValue());
    }

    public void testRenameToExistingUser() throws Exception {
        FecruUser matt = new FecruUser("matt");
        FecruUser joe = new FecruUser("joe");
        this.userDAO.create(matt);
        this.userDAO.create(joe);
        this.watchDAO.add(new Watch(matt, "repo1", new Path((CharSequence)"/repo1/matt"), new WaybackSpec()));
        this.watchDAO.add(new Watch(joe, "repo2", new Path((CharSequence)"/repo2/joe"), new WaybackSpec()));
        this.loginCookieDAO.addCookie(LoginCookie.createRememberMeCookie((FecruUser)matt, (String)"12345"));
        this.loginCookieDAO.addCookie(LoginCookie.createRememberMeCookie((FecruUser)joe, (String)"12345"));
        try {
            this.renamer.rename("matt", "joe");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.never())).publish((Object)new UserRenamedEvent("matt", "mac"));
    }
}

