/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.user.LoginCookieToken;
import junit.framework.TestCase;

public class LoginCookieTokenTest
extends TestCase {
    private static final String[] USERNAMES = new String[]{"blah", "blah&", "!@#$%^&*(){}_+|\\'\"", "<font color=\"red\">red</font>"};
    private static final String[] RNDS = new String[]{"sdfasldkfj", "21983412983"};
    private static final long[] IDS = new long[]{0L, 1L, 2L};

    public void testEncodeDecodeToken() {
        for (String username : USERNAMES) {
            for (String rnd : RNDS) {
                for (long id : IDS) {
                    this.subtestEncodeDecodeToken(id, username, rnd);
                }
            }
        }
    }

    private void subtestEncodeDecodeToken(long id, String username, String rnd) {
        LoginCookieToken token = new LoginCookieToken(Long.valueOf(id), username, rnd);
        String encodedString = token.encode();
        LoginCookieToken decodedToken = LoginCookieToken.decode((String)encodedString);
        this.assertTokenEquals(token, decodedToken);
    }

    private void assertTokenEquals(LoginCookieToken expected, LoginCookieToken actual) {
        LoginCookieTokenTest.assertEquals((String)"username not equal after decoding", (String)actual.getUsername(), (String)expected.getUsername());
        LoginCookieTokenTest.assertEquals((String)"id not equal after decoding", (long)actual.getLoginId(), (long)expected.getLoginId());
        LoginCookieTokenTest.assertEquals((String)"rnd not equal after decoding", (String)actual.getRnd(), (String)expected.getRnd());
    }
}

