/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.user.AJPAuth;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.DefaultUserManager;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultUserManagerUnitTest {
    @Mock
    private AdminUserConfig adminUserConfig;
    @Mock
    private DirectoryManager directoryManager;
    @Mock
    private CrowdService crowdService;
    @Mock
    private ApplicationService applicationService;
    @Mock
    private ApplicationFactory applicationFactory;
    @Mock
    private DefaultUserManager userManager;
    @Mock
    GroupMembershipManager groupMembershipManager;
    @Mock
    GlobalPermissionManager globalPermissionManager;
    @Mock
    FecruUserDAO userDao;
    @Mock
    EventPublisher eventPublisher;
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();

    @Before
    public void setUp() throws Exception {
        this.userManager = new DefaultUserManager(null, null, this.userDao, (TxTemplate)new DummyTxTemplate(), this.rootConfigRule.getRootConfig(), null, null, this.directoryManager, null, null, this.crowdService, this.applicationService, this.applicationFactory, this.groupMembershipManager, this.globalPermissionManager, this.adminUserConfig, this.eventPublisher);
    }

    @Test
    public void testSearchGroupsAll() throws Exception {
        this.addGroup("g1", 1L, false);
        this.addGroup("g2", 2L, false);
        this.addGroup("a3", 3L, true);
        ArgumentCaptor<Query> queryArgumentCaptor = this.setCrowdServiceGroupsForQuery("g1", "g2", "a3");
        Page actual = this.userManager.searchGroups(GroupSearchCriteria.create(), PageRequest.create((Integer)0, (Integer)10));
        Assert.assertThat((Object)queryArgumentCaptor.getAllValues(), (Matcher)org.hamcrest.Matchers.contains((Object[])new Query[]{this.newGroupEntityQuery("", 0, 11)}));
        Assert.assertThat((Object)actual.getValues(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("g1", false)), org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("g2", false)), org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("a3", true))}));
    }

    @Test
    public void testSearchGroupsPrefix() throws Exception {
        this.addGroup("g1", 1L, false);
        this.addGroup("g2", 2L, false);
        this.addGroup("a3", 3L, true);
        ArgumentCaptor<Query> queryArgumentCaptor = this.setCrowdServiceGroupsForQuery("g1", "g2");
        Page actual = this.userManager.searchGroups(GroupSearchCriteria.create().prefix("g"), PageRequest.create((Integer)0, (Integer)10));
        Assert.assertThat((Object)queryArgumentCaptor.getAllValues(), (Matcher)org.hamcrest.Matchers.contains((Object[])new Query[]{this.newGroupEntityQuery("g", 0, 11)}));
        Assert.assertThat((Object)actual.getValues(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("g1", false)), org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("g2", false))}));
    }

    @Test
    public void testSearchGroupsPaging() throws Exception {
        this.addGroup("g1", 1L, false);
        this.addGroup("g2", 2L, false);
        this.addGroup("a3", 3L, true);
        this.addGroup("a4", 4L, true);
        this.addGroup("a5", 5L, true);
        ArgumentCaptor<Query> queryArgumentCaptor = this.setCrowdServiceGroupsForQuery("g1", "g2", "a3", "a4");
        Page actual = this.userManager.searchGroups(GroupSearchCriteria.create(), PageRequest.create((Integer)0, (Integer)3));
        Assert.assertThat((Object)queryArgumentCaptor.getAllValues(), (Matcher)org.hamcrest.Matchers.contains((Object[])new Query[]{this.newGroupEntityQuery("", 0, 4)}));
        Assert.assertThat((Object)actual.getValues(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("g1", false)), org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("g2", false)), org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("a3", true))}));
        Assert.assertFalse((boolean)actual.isLastPage());
        ArgumentCaptor<Query> queryArgumentCaptor2 = this.setCrowdServiceGroupsForQuery("a4", "a5");
        Page actual2 = this.userManager.searchGroups(GroupSearchCriteria.create(), PageRequest.create((Integer)3, (Integer)3));
        Assert.assertThat((Object)queryArgumentCaptor2.getAllValues(), (Matcher)org.hamcrest.Matchers.contains((Object[])new Query[]{this.newGroupEntityQuery("", 3, 4)}));
        Assert.assertThat((Object)actual2.getValues(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("a4", true)), org.hamcrest.Matchers.samePropertyValuesAs((Object)DefaultUserManagerUnitTest.newGroupInfo("a5", true))}));
        Assert.assertTrue((boolean)actual2.isLastPage());
    }

    @Test
    public void testGetAllLicensedUsernames() throws Exception {
        Mockito.when((Object)this.globalPermissionManager.getUsersWithPermission(GlobalPermissionType.FISHEYE_USER)).thenReturn((Object)ImmutableSet.of((Object)"bob", (Object)"tob"));
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isCrucibleOnly()).thenReturn((Object)false);
        Iterable userNames = this.userManager.getAllLicensedUsernames();
        Assert.assertThat((Object)userNames, (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"bob", "tob"}));
    }

    @Test
    public void testGetAllLicensedUsernames_cruOnly() throws Exception {
        Mockito.when((Object)this.globalPermissionManager.getUsersWithPermission(GlobalPermissionType.CRUCIBLE_USER)).thenReturn((Object)ImmutableSet.of((Object)"bob", (Object)"tob"));
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isCrucibleOnly()).thenReturn((Object)true);
        Iterable userNames = this.userManager.getAllLicensedUsernames();
        Assert.assertThat((Object)userNames, (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"bob", "tob"}));
    }

    @Test
    public void testExistsLicensedUser() throws Exception {
        FecruUser mockTom = this.mockUser("tom");
        Mockito.when((Object)this.userDao.getByUsername("tom")).thenReturn((Object)mockTom);
        FecruUser mockBom = this.mockUser("bom");
        Mockito.when((Object)this.userDao.getByUsername("bom")).thenReturn((Object)mockBom);
        Mockito.when((Object)this.globalPermissionManager.hasPermission("tom", GlobalPermissionType.FISHEYE_USER)).thenReturn((Object)true);
        boolean tom = this.userManager.existsLicensedUser("tom");
        boolean bom = this.userManager.existsLicensedUser("bom");
        Assert.assertTrue((boolean)tom);
        Assert.assertFalse((boolean)bom);
    }

    @Test
    public void testAddUser() throws Exception {
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getLicense().isFishEye()).thenReturn((Object)true);
        String username = "user";
        this.userManager.addUser("user", "display", "email", "pass", true);
        ((CrowdService)Mockito.verify((Object)this.crowdService)).addUser((User)Matchers.argThat((Matcher)org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.equalTo((Object)"user"))), (String)Matchers.eq((Object)"pass"));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(Matchers.any(UserListChangedEvent.class));
        ((GroupMembershipManager)Mockito.verify((Object)this.groupMembershipManager)).tryAddUserToGroup("fisheye-users", "user");
        ((GroupMembershipManager)Mockito.verify((Object)this.groupMembershipManager, (VerificationMode)Mockito.never())).tryAddUserToGroup("crucible-users", "user");
    }

    @Test
    public void testImportUser() throws Exception {
        String username = "user";
        this.userManager.importUser((AuthTok)new AJPAuth.AjpAuthTok(123L, "user"));
        ((ApplicationService)Mockito.verify((Object)this.applicationService)).addUser((Application)Matchers.any(Application.class), (UserTemplate)Matchers.argThat((Matcher)org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.equalTo((Object)"user"))), (PasswordCredential)Matchers.eq((Object)PasswordCredential.NONE));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(Matchers.any(UserListChangedEvent.class));
    }

    @Test
    public void testDeleteGroup() throws Exception {
        String groupName = "aGroupName";
        this.userManager.deleteGroup(groupName);
        ((CrowdService)Mockito.verify((Object)this.crowdService, (VerificationMode)Mockito.times((int)1))).removeGroup((Group)Matchers.argThat((Matcher)org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)groupName))));
    }

    private ArgumentCaptor<Query> setCrowdServiceGroupsForQuery(String ... groupNames) {
        List groups = Arrays.asList(groupNames).stream().map(name -> new ImmutableGroup(name)).collect(Collectors.toList());
        ArgumentCaptor queryArgumentCaptor = ArgumentCaptor.forClass(Query.class);
        Mockito.when((Object)this.crowdService.search((Query)queryArgumentCaptor.capture())).thenReturn(groups);
        return queryArgumentCaptor;
    }

    private EntityQuery<Group> newGroupEntityQuery(String searchPrefix, int startingAt, int maxResults) {
        return QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true), Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)Strings.nullToEmpty((String)searchPrefix))})).startingAt(startingAt).returningAtMost(maxResults);
    }

    private void addGroup(String name, long directoryId, boolean admin) throws Exception {
        com.atlassian.crowd.model.group.Group g1 = DefaultUserManagerUnitTest.newMockGroup(name, directoryId);
        Mockito.when((Object)this.applicationService.findGroupByName((Application)Matchers.any(Application.class), (String)Matchers.eq((Object)name))).thenReturn((Object)g1);
        Mockito.when((Object)this.adminUserConfig.isAdminGroup(name)).thenReturn((Object)admin);
        Mockito.when((Object)this.directoryManager.findDirectoryById(directoryId)).thenReturn((Object)this.newDirectoryImpl(name, directoryId));
    }

    private static GroupInfo newGroupInfo(String name, boolean admin) {
        return new GroupInfo(name, admin);
    }

    private DirectoryImpl newDirectoryImpl(String name, final long idParam) {
        DirectoryImpl directory = new DirectoryImpl(){
            {
                this.id = idParam;
            }
        };
        directory.setName(name);
        directory.setAllowedOperations((Set)ImmutableSet.copyOf((Object[])OperationType.values()));
        return directory;
    }

    private static com.atlassian.crowd.model.group.Group newMockGroup(String name, long directoryId) {
        com.atlassian.crowd.model.group.Group group = (com.atlassian.crowd.model.group.Group)Mockito.mock(com.atlassian.crowd.model.group.Group.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)name);
        Mockito.when((Object)group.getDirectoryId()).thenReturn((Object)directoryId);
        return group;
    }

    private FecruUser mockUser(String username) {
        FecruUser mock = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)mock.getUsername()).thenReturn((Object)username);
        Mockito.when((Object)mock.getDisplayName()).thenReturn((Object)username);
        Mockito.when((Object)mock.getEmail()).thenReturn((Object)username);
        Mockito.when((Object)mock.isEnabled()).thenReturn((Object)true);
        return mock;
    }
}

