/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.CrowdTestRule;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.user.permissions.DefaultGlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.PagedResourceFetchHelper;
import com.atlassian.fisheye.user.permissions.cache.EagerGlobalPermissionCacheLoader;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCache;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCacheLoader;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.AuthenticationFactory;
import com.cenqua.fisheye.user.DefaultAdminUserConfig;
import com.cenqua.fisheye.user.DefaultGroupMembershipManager;
import com.cenqua.fisheye.user.DefaultUserManager;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.web.WatchDAO;
import java.util.List;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml", "classpath:/tests-db-spring-context-crowd.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DefaultUserManagerPermissionSearchTest {
    private static final int PAGE_SIZE = 3;
    private static final String USER_NAME = "paged-search-user";
    private Auth mockAuth;
    private AdminUserConfig mockAdminUserConfig;
    private AuthenticationFactory mockAuthenticationFactory;
    private ProductLicense mockFeLicense;
    private ProductLicense mockCruLicense;
    private LicenseInfo mockLicenseInfo;
    private LicenseManager mockLicenseManager;
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    @Autowired
    @Rule
    public CrowdTestRule crowdTestRule;
    public UserPermissionsTestRule userPermissionsTestRule;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private LoginCookieDAO loginCookieDAO;
    @Autowired
    private WatchDAO watchDAO;
    @Autowired
    private TxTemplate txTemplate;
    @Autowired
    private CrowdService crowdService;
    @Autowired
    private DirectoryManager directoryManager;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationFactory applicationFactory;
    @Autowired
    private UserRepositoryPropertyManager userRepositoryPropertyManager;
    @Autowired
    private GlobalPermissionDao globalPermissiondao;
    @Autowired
    private EventPublisher eventPublisher;
    private DefaultGlobalPermissionManager globalPermissionManager;
    private DefaultUserManager userManager;
    private CommitterUserMappingManager mockCommitterUserMappingManager;
    private CurrentSessionProvider mockCurrentSessionProvider;
    private DefaultGroupMembershipManager groupMembershipManager;

    @Before
    public void setup() throws Exception {
        this.mockAuth = (Auth)Mockito.mock(Auth.class);
        this.mockAdminUserConfig = (AdminUserConfig)Mockito.mock(DefaultAdminUserConfig.class);
        this.mockAuthenticationFactory = (AuthenticationFactory)Mockito.mock(AuthenticationFactory.class);
        this.mockFeLicense = (ProductLicense)Mockito.mock(ProductLicense.class);
        this.mockCruLicense = (ProductLicense)Mockito.mock(ProductLicense.class);
        this.mockLicenseInfo = (LicenseInfo)Mockito.mock(LicenseInfo.class);
        this.mockLicenseManager = (LicenseManager)Mockito.mock(LicenseManager.class);
        this.mockCurrentSessionProvider = (CurrentSessionProvider)Mockito.mock(CurrentSessionProvider.class);
        Mockito.when((Object)this.mockCurrentSessionProvider.currentSession()).thenReturn(Mockito.mock(Session.class));
        this.mockCommitterUserMappingManager = (CommitterUserMappingManager)Mockito.mock(CommitterUserMappingManager.class);
        Mockito.when((Object)this.mockLicenseInfo.getFisheyeLicense()).thenReturn((Object)this.mockFeLicense);
        Mockito.when((Object)this.mockLicenseInfo.getCrucibleLicense()).thenReturn((Object)this.mockCruLicense);
        Mockito.when((Object)this.mockFeLicense.isUnlimitedNumberOfUsers()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getLicense()).thenReturn((Object)this.mockLicenseInfo);
        Mockito.when((Object)this.mockAuthenticationFactory.getAuth((SecurityType)Mockito.any(SecurityType.class))).thenReturn((Object)this.mockAuth);
        this.groupMembershipManager = new DefaultGroupMembershipManager(this.crowdService, this.userDAO, this.eventPublisher);
        GlobalPermissionCache globalPermissionCache = new GlobalPermissionCache((GlobalPermissionCacheLoader)new EagerGlobalPermissionCacheLoader(this.globalPermissiondao, (GroupMembershipManager)this.groupMembershipManager));
        this.globalPermissionManager = new DefaultGlobalPermissionManager(this.globalPermissiondao, this.eventPublisher, globalPermissionCache);
        this.userManager = new DefaultUserManager(this.loginCookieDAO, this.watchDAO, this.userDAO, this.txTemplate, this.rootConfigRule.getRootConfig(), this.mockAuthenticationFactory, this.mockLicenseManager, this.directoryManager, null, this.userRepositoryPropertyManager, this.crowdService, this.applicationService, this.applicationFactory, (GroupMembershipManager)this.groupMembershipManager, (GlobalPermissionManager)this.globalPermissionManager, this.mockAdminUserConfig, this.eventPublisher);
        this.userManager.setCommitterUserMappingManager(this.mockCommitterUserMappingManager);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getUserManager()).thenReturn((Object)this.userManager);
        this.crowdTestRule.createInternalDirectory();
        this.userPermissionsTestRule = new UserPermissionsTestRule((GlobalPermissionManager)this.globalPermissionManager, globalPermissionCache, (GroupMembershipManager)this.groupMembershipManager, (UserManager)this.userManager);
        this.userPermissionsTestRule.before();
        this.userManager.init();
    }

    @After
    public void tearDown() throws Exception {
        this.userPermissionsTestRule.after();
    }

    @Test
    public void testSearchUsersWithoutSpecifyingPermissions() throws Exception {
        int noExpectedPages = 3;
        this.buildPagesAndAddUsers(3, i -> GlobalPermissionType.FISHEYE_USER);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 3);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)3L, (long)pages.size());
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new Integer[]{0, 1, 2}));
        Assert.assertThat(pages.get(1), (Matcher)Matchers.contains((Object[])new Integer[]{3, 4, 5}));
        Assert.assertThat(pages.get(2), (Matcher)Matchers.contains((Object[])new Integer[]{6, 7, 8}));
    }

    @Test
    public void testSearchUsersWithAllUsersMatchingPermissions() throws Exception {
        int noExpectedPages = 3;
        this.buildPagesAndAddUsers(3, i -> GlobalPermissionType.FISHEYE_USER);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME).withPermissions(GlobalPermissionType.FISHEYE_USER);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 3);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)3L, (long)pages.size());
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new Integer[]{0, 1, 2}));
        Assert.assertThat(pages.get(1), (Matcher)Matchers.contains((Object[])new Integer[]{3, 4, 5}));
        Assert.assertThat(pages.get(2), (Matcher)Matchers.contains((Object[])new Integer[]{6, 7, 8}));
    }

    @Test
    public void testSearchUsersWithEverySecondUserMatchingPermissions() throws Exception {
        int noExpectedPages = 2;
        this.buildPagesAndAddUsers(3, i -> i % 2 == 0 ? GlobalPermissionType.FISHEYE_USER : null);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME).withPermissions(GlobalPermissionType.FISHEYE_USER);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 2);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)2L, (long)pages.size());
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new Integer[]{0, 2, 4}));
        Assert.assertThat(pages.get(1), (Matcher)Matchers.contains((Object[])new Integer[]{6, 8}));
    }

    @Test
    public void testSearchUsersOnlyLastPageMatching() throws Exception {
        boolean noExpectedPages = true;
        this.buildPagesAndAddUsers(3, i -> i >= 6 ? GlobalPermissionType.FISHEYE_USER : null);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME).withPermissions(GlobalPermissionType.FISHEYE_USER);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 1);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)1L, (long)pages.size());
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new Integer[]{6, 7, 8}));
    }

    @Test
    public void testSearchUsersOnlyFirstPageMatching() throws Exception {
        boolean noExpectedPages = true;
        this.buildPagesAndAddUsers(3, i -> i < 3 ? GlobalPermissionType.FISHEYE_USER : null);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME).withPermissions(GlobalPermissionType.FISHEYE_USER);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 1);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)1L, (long)pages.size());
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new Integer[]{0, 1, 2}));
    }

    @Test
    public void testSearchUsersOnlyOneItem() throws Exception {
        boolean noExpectedPages = true;
        this.buildPagesAndAddUsers(3, i -> i == 5 ? GlobalPermissionType.FISHEYE_USER : null);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME).withPermissions(GlobalPermissionType.FISHEYE_USER);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 1);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)1L, (long)pages.size());
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new Integer[]{5}));
    }

    @Test
    public void testSearchUsersWithNoneUserMatchingPermissions() throws Exception {
        boolean noExpectedPages = true;
        this.buildPagesAndAddUsers(3, i -> null);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().named(USER_NAME).withPermissions(GlobalPermissionType.FISHEYE_USER);
        List<List<Integer>> pages = this.fetchPagedUsers(userSearchCriteria, 3, 1);
        Assert.assertEquals((String)"Size of pages doesn't match", (long)1L, (long)pages.size());
        Assert.assertTrue((String)"Page should be empty", (boolean)pages.get(0).isEmpty());
    }

    private void buildPagesAndAddUsers(int noPages, Function<Integer, GlobalPermissionType> userPermissions) throws LicensePolicyException {
        for (int i = 0; i < noPages; ++i) {
            for (int j = 0; j < 3; ++j) {
                int no = i * 3 + j;
                String userName = USER_NAME + no;
                GlobalPermissionType permission = userPermissions.apply(no);
                if (permission == null) {
                    this.userManager.addUser(userName, userName, userName, userName, false).getDisplayName();
                    continue;
                }
                if (permission == GlobalPermissionType.CRUCIBLE_USER) {
                    this.userPermissionsTestRule.addFecruUser(userName).getDisplayName();
                    continue;
                }
                if (permission != GlobalPermissionType.FISHEYE_USER) continue;
                this.userPermissionsTestRule.addFecruUser(userName).getDisplayName();
            }
        }
    }

    private List<List<Integer>> fetchPagedUsers(UserSearchCriteria userSearchCriteria, int pageSize, int noExpectedPages) {
        return PagedResourceFetchHelper.fetchPagedResource(pageSize, noExpectedPages, pageRequest -> this.userManager.searchUsers(userSearchCriteria, pageRequest), fecruUser -> Integer.parseInt(fecruUser.getUsername().substring(USER_NAME.length())));
    }
}

