/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.AuthType;
import com.atlassian.fecru.user.CrowdTestRule;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fecru.user.UserMatcher;
import com.atlassian.fecru.user.UserTestRule;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AJPAuth;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.AuthenticationFactory;
import com.cenqua.fisheye.user.CustomAuth;
import com.cenqua.fisheye.user.DefaultAdminUserConfig;
import com.cenqua.fisheye.user.DefaultGroupMembershipManager;
import com.cenqua.fisheye.user.DefaultUserManager;
import com.cenqua.fisheye.user.DummyAuthTok;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.user.UserTestHelper;
import com.cenqua.fisheye.user.embeddedcrowd.EmbeddedCrowdAuthTok;
import com.cenqua.fisheye.user.plugin.AuthToken;
import com.cenqua.fisheye.user.plugin.ExampleFishEyeAuthenticator;
import com.cenqua.fisheye.web.WatchDAO;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.DummyHttpServletResponse;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-crowd.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DefaultUserManagerIntegrationTest {
    public static final String VALID_USERNAME = "validusername";
    public static final String ANOTHER_VALID_NAME = "anothervalidname";
    public static final String INVALID_USERNAME = "$invalidname$";
    public static final String INACTIVE_USER = "inactiveuser";
    public static final String ACTIVE_USER = "activeuser";
    public static final Set<String> ADMIN_GROUPS = ImmutableSet.of((Object)"admin-group-1", (Object)"admin-group-2", (Object)"admin-group-3");
    private final AuthenticationController mockAuthController = (AuthenticationController)Mockito.mock(AuthenticationController.class);
    private Auth mockAuth;
    private AdminUserConfig mockAdminUserConfig;
    private AuthenticationFactory mockAuthenticationFactory;
    private ProductLicense mockFeLicense;
    private ProductLicense mockCruLicense;
    private LicenseInfo mockLicenseInfo;
    private LicenseManager mockLicenseManager;
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    @Autowired
    @Rule
    public CrowdTestRule crowdTestRule;
    @Autowired
    @Rule
    public UserTestRule userTestRule;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private LoginCookieDAO loginCookieDAO;
    @Autowired
    private WatchDAO watchDAO;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private TxTemplate txTemplate;
    @Autowired
    private CrowdService crowdService;
    @Autowired
    private DirectoryManager directoryManager;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationFactory applicationFactory;
    @Autowired
    private UserRepositoryPropertyManager userRepositoryPropertyManager;
    @Autowired
    private GlobalPermissionManager globalPermissionManager;
    @Autowired
    private CurrentSessionProvider currentSessionProvider;
    @Autowired
    private EventPublisher eventPublisher;
    private DefaultUserManager userManager;
    private CommitterUserMappingManager mockCommitterUserMappingManager;
    private Directory directory;
    private DefaultGroupMembershipManager groupMembershipManager;

    @Before
    public void setup() throws Exception {
        this.eventPublisher = (EventPublisher)Mockito.spy((Object)this.eventPublisher);
        this.userTestRule.setupFecruUserListener(this.crowdService);
        this.mockAuth = (Auth)Mockito.mock(Auth.class);
        this.mockAdminUserConfig = (AdminUserConfig)Mockito.mock(DefaultAdminUserConfig.class);
        this.mockAuthenticationFactory = (AuthenticationFactory)Mockito.mock(AuthenticationFactory.class);
        this.mockFeLicense = (ProductLicense)Mockito.mock(ProductLicense.class);
        this.mockCruLicense = (ProductLicense)Mockito.mock(ProductLicense.class);
        this.mockLicenseInfo = (LicenseInfo)Mockito.mock(LicenseInfo.class);
        this.mockLicenseManager = (LicenseManager)Mockito.mock(LicenseManager.class);
        this.mockCommitterUserMappingManager = (CommitterUserMappingManager)Mockito.mock(CommitterUserMappingManager.class);
        Mockito.when((Object)this.mockLicenseInfo.getFisheyeLicense()).thenReturn((Object)this.mockFeLicense);
        Mockito.when((Object)this.mockLicenseInfo.getCrucibleLicense()).thenReturn((Object)this.mockCruLicense);
        Mockito.when((Object)this.mockFeLicense.isUnlimitedNumberOfUsers()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getLicense()).thenReturn((Object)this.mockLicenseInfo);
        Mockito.when((Object)this.mockAuthenticationFactory.getAuth((SecurityType)Mockito.any(SecurityType.class))).thenReturn((Object)this.mockAuth);
        this.groupMembershipManager = new DefaultGroupMembershipManager(this.crowdService, this.userDAO, this.eventPublisher);
        this.userManager = new DefaultUserManager(this.loginCookieDAO, this.watchDAO, this.userDAO, this.txTemplate, this.rootConfigRule.getRootConfig(), this.mockAuthenticationFactory, this.mockLicenseManager, this.directoryManager, this.mockAuthController, this.userRepositoryPropertyManager, this.crowdService, this.applicationService, this.applicationFactory, (GroupMembershipManager)this.groupMembershipManager, this.globalPermissionManager, this.mockAdminUserConfig, this.eventPublisher);
        this.userManager.setCommitterUserMappingManager(this.mockCommitterUserMappingManager);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getUserManager()).thenReturn((Object)this.userManager);
        Mockito.when((Object)this.mockLicenseInfo.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)this.mockLicenseInfo.isCrucible()).thenReturn((Object)true);
        this.directory = this.crowdTestRule.createInternalDirectory();
        this.createAdminGroups();
        this.userManager.init();
        Mockito.reset((Object[])new EventPublisher[]{this.eventPublisher});
        this.userManager.addGroup("fisheye-users");
        this.userManager.addGroup("crucible-users");
        this.globalPermissionManager.setPermissionsForGroup("fisheye-users", GlobalPermissionType.FISHEYE_USER);
        this.globalPermissionManager.setPermissionsForGroup("crucible-users", GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Mockito.when((Object)this.mockLicenseInfo.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)this.mockLicenseInfo.isCrucible()).thenReturn((Object)true);
    }

    private void createAdminGroups() throws OperationNotPermittedException, InvalidGroupException {
        Mockito.when((Object)this.mockAdminUserConfig.getGroupSet()).thenReturn(ADMIN_GROUPS);
        for (String adminGroup : ADMIN_GROUPS) {
            Mockito.when((Object)this.mockAdminUserConfig.isAdminGroup(adminGroup)).thenReturn((Object)true);
            this.userManager.addGroup(adminGroup);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (String userName : this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1))) {
            this.cleanUser(userName);
        }
    }

    @Test
    public void testAddUser() throws Exception {
        this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", false);
        this.sessionFactory.getCurrentSession().flush();
        this.assertUserExists(VALID_USERNAME);
    }

    @Test
    public void testAddUser_shouldNotAddToDefaultGroupsByDefault() throws Exception {
        Mockito.when((Object)this.mockLicenseInfo.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)this.mockLicenseInfo.isCrucible()).thenReturn((Object)true);
        this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", false);
        this.assertUserExists(VALID_USERNAME);
        Assert.assertThat((Object)this.groupMembershipManager.isUserInGroup("fisheye-users", VALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Assert.assertThat((Object)this.groupMembershipManager.isUserInGroup("crucible-users", VALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void testAddUser_shouldAddToDefaultGroups() throws Exception {
        Mockito.when((Object)this.mockLicenseInfo.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)this.mockLicenseInfo.isCrucible()).thenReturn((Object)true);
        this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", true);
        this.assertUserExists(VALID_USERNAME);
        Assert.assertThat((Object)this.groupMembershipManager.isUserInGroup("fisheye-users", VALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)this.groupMembershipManager.isUserInGroup("crucible-users", VALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void testAddUser_shouldAddToFisheyeDefaultGroupOnlyWhenFisheyeLicenseOnly() throws Exception {
        Mockito.when((Object)this.mockLicenseInfo.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)this.mockLicenseInfo.isCrucible()).thenReturn((Object)false);
        this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", true);
        this.assertUserExists(VALID_USERNAME);
        Assert.assertThat((Object)this.groupMembershipManager.isUserInGroup("fisheye-users", VALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)this.groupMembershipManager.isUserInGroup("crucible-users", VALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void testAddUser_shouldGracefullyHandleDefaultGroupsNonexistance() throws Exception {
        Mockito.when((Object)this.mockLicenseInfo.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)this.mockLicenseInfo.isCrucible()).thenReturn((Object)true);
        this.userManager.deleteGroup("fisheye-users");
        this.userManager.deleteGroup("crucible-users");
        this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", true);
        this.assertUserExists(VALID_USERNAME);
    }

    @Test
    public void testAnonHasPermissionToAccess() throws Exception {
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isAnonAccessAllowed()).thenReturn((Object)true);
        RepositoryConfig cfg = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        Mockito.when((Object)cfg.isAnonAccessAllowed()).thenReturn((Object)true);
        Mockito.when((Object)handle.getCfg()).thenReturn((Object)cfg);
        Assert.assertTrue((String)"Global-anon & repo-anon should allow anon access", (boolean)this.userManager.hasPermissionToAccess((Principal)Principal.Anonymous.ANON, handle));
        Mockito.when((Object)cfg.isAnonAccessAllowed()).thenReturn((Object)false);
        Assert.assertFalse((String)"Global-anon only should not allow anon access", (boolean)this.userManager.hasPermissionToAccess((Principal)Principal.Anonymous.ANON, handle));
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isAnonAccessAllowed()).thenReturn((Object)false);
        Mockito.when((Object)cfg.isAnonAccessAllowed()).thenReturn((Object)true);
        Assert.assertFalse((String)"Repo-anon only should not allow anon access", (boolean)this.userManager.hasPermissionToAccess((Principal)Principal.Anonymous.ANON, handle));
    }

    @Test
    public void testNonAnonHasPermissionToAccessFE_5081() throws Exception {
        Mockito.when((Object)this.mockAuthenticationFactory.getAuth((SecurityType)Mockito.any(SecurityType.class))).thenReturn(null);
        this.userManager = new DefaultUserManager(this.loginCookieDAO, this.watchDAO, this.userDAO, (TxTemplate)new DummyTxTemplate(), this.rootConfigRule.getRootConfig(), this.mockAuthenticationFactory, this.mockLicenseManager, this.directoryManager, this.mockAuthController, this.userRepositoryPropertyManager, this.crowdService, this.applicationService, this.applicationFactory, (GroupMembershipManager)this.groupMembershipManager, this.globalPermissionManager, this.mockAdminUserConfig, this.eventPublisher);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isAnonAccessAllowed()).thenReturn((Object)false);
        RepositoryConfig cfg = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        Mockito.when((Object)cfg.isAnonAccessAllowed()).thenReturn((Object)true);
        Mockito.when((Object)handle.getCfg()).thenReturn((Object)cfg);
        UserLogin login = UserTestHelper.createPrincipal("user");
        Assert.assertTrue((String)"Global-anon & repo-anon should allow logged-in access", (boolean)this.userManager.hasPermissionToAccess((Principal)login, handle));
    }

    @Test
    public void testAddUserValidatesName() throws Exception {
        FecruUser validUserRet = this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", false);
        Assert.assertThat((String)"validUserIn created properly", (Object)validUserRet, (Matcher)new UserMatcher.Builder().withUserName(VALID_USERNAME).build());
        try {
            this.userManager.addUser("$invalidusername$", "", "", "password", false);
            Assert.fail((String)"should throw exception, user name is invalid");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage().toLowerCase(), (Matcher)org.hamcrest.Matchers.containsString((String)"invalid user name"));
        }
        Assert.assertThat((String)"invalid user was NOT created", (Object)this.userManager.existsLicensedUser("$invalidUserName$"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
        try {
            this.userManager.addUser("$admin$", "$admin$", "$admin$", "password", false);
            Assert.fail((String)"should throw exception, user name is invalid");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage().toLowerCase(), (Matcher)org.hamcrest.Matchers.containsString((String)"invalid user name"));
        }
        Assert.assertThat((String)"invalid user was NOT created", (Object)this.userManager.existsLicensedUser("$admin$"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testRenameUserValidatesName() throws Exception {
        FecruUser validUserRet = this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", false);
        Assert.assertThat((String)"validUserIn created properly", (Object)validUserRet, (Matcher)new UserMatcher.Builder().withUserName(VALID_USERNAME).build());
        Assert.assertThat((String)"target name does not exist prior to the test", (Object)this.userManager.existsEnabledUser(ANOTHER_VALID_NAME), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
        this.userManager.renameUser(validUserRet.getUsername(), ANOTHER_VALID_NAME);
        Assert.assertThat((String)"user renamed correctly", (Object)this.userManager.existsEnabledUser(ANOTHER_VALID_NAME), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.TRUE));
        try {
            this.userManager.renameUser(ANOTHER_VALID_NAME, INVALID_USERNAME);
            Assert.fail((String)"should throw exception, user name is invalid");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage().toLowerCase(), (Matcher)org.hamcrest.Matchers.containsString((String)"invalid user name"));
        }
        Assert.assertThat((String)"invalid user was NOT created", (Object)this.userManager.existsLicensedUser(INVALID_USERNAME), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testRenameToInactiveUser() throws Exception {
        this.txTemplate.execute(callback -> {
            FecruUser inactiveUserResult = this.userManager.addUser(INACTIVE_USER, INACTIVE_USER, INACTIVE_USER, "password", false);
            this.userManager.deleteUser(INACTIVE_USER, false);
            return null;
        });
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        User activeUser = ImmutableUser.newUser().name(ACTIVE_USER).toUser();
        this.userManager.addUser(ACTIVE_USER, ACTIVE_USER, ACTIVE_USER, "password", false);
        try {
            this.userManager.renameUser(ACTIVE_USER, INACTIVE_USER);
            Assert.fail((String)"Should have failed to rename");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"User \"inactiveuser\" already exists."));
        }
        Assert.assertFalse((boolean)this.userManager.existsEnabledUser(INACTIVE_USER));
        Assert.assertTrue((boolean)this.userManager.existsEnabledUser(ACTIVE_USER));
        Assert.assertNull((Object)this.crowdService.getUser(INACTIVE_USER));
        Assert.assertNotNull((Object)this.crowdService.getUser(ACTIVE_USER));
    }

    private void cleanUser(String userName) {
        if (this.userDAO.existsAny(userName)) {
            try {
                this.userManager.deleteUserFully(userName);
            }
            catch (Exception e) {
                System.out.println("Unable to clean up user " + userName);
            }
        }
    }

    @Test
    public void testAddInternalGroup() throws Exception {
        Assert.assertThat((String)"no group exist prior to the test", (Object)this.userManager.groupExists("validGroupName"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
        this.userManager.addGroup("validGroupName");
        Assert.assertThat((String)"group created for valid name", (Object)this.userManager.groupExists("validGroupName"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.TRUE));
        try {
            this.userManager.addGroup("$invalidGroupName$");
            Assert.fail((String)"should throw exception, group name is invalid");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage().toLowerCase(), (Matcher)org.hamcrest.Matchers.containsString((String)"invalid group name"));
        }
        Assert.assertThat((String)"invalid group was NOT created", (Object)this.userManager.groupExists("$invalidGroupName$"), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testValidateCurrentUser_doesntDeAuthIfAuthControllerAlreadyAuthorized() throws Exception {
        HttpServletRequest request = this.mockRequest();
        FecruUser user = this.userManager.addUser("joe", "joe", "joe", "joe", true);
        Mockito.when((Object)this.mockAuth.getAuthType()).thenReturn((Object)AuthType.AJP);
        Mockito.when((Object)this.mockAuthController.shouldAttemptAuthentication(request)).thenReturn((Object)false);
        Mockito.when((Object)request.getAttribute("feuser")).thenReturn((Object)new UserLogin(user, (AuthTok)new AJPAuth.AjpAuthTok(3600L, user.getUsername()), null));
        this.userManager.validateCurrentUser(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        ((HttpServletRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.never())).removeAttribute("feuser");
    }

    @Test
    public void testValidateCurrentUser_doesDeAuthIfAuthControllerHasNotAlreadyAuthorized() throws Exception {
        HttpServletRequest request = this.mockRequest();
        FecruUser user = this.userManager.addUser("joe", "joe", "joe", "joe", true);
        Mockito.when((Object)this.mockAuth.getAuthType()).thenReturn((Object)AuthType.AJP);
        Mockito.when((Object)this.mockAuthController.shouldAttemptAuthentication(request)).thenReturn((Object)true);
        Mockito.when((Object)request.getAttribute("feuser")).thenReturn((Object)new UserLogin(user, (AuthTok)new AJPAuth.AjpAuthTok(3600L, user.getUsername()), null));
        this.userManager.validateCurrentUser(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        ((HttpServletRequest)Mockito.verify((Object)request)).removeAttribute("feuser");
    }

    @Test
    public void testDeleteUser() throws Exception {
        this.userManager.addUser("joe", "joe", "joe", "joe", false);
        this.userManager.deleteUserAndRemoveCommitterMappings("joe");
        Assert.assertThat((Object)this.crowdService.getUser("joe"), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testGetUserByEmail() throws Exception {
        String email = "joey@joey.joey";
        String username = "joey";
        this.userManager.addUser("joey", "joey", "joey@joey.joey", "password", false);
        String user = this.userManager.getUsernameByEmail("joey@joey.joey");
        String noUser = this.userManager.getUsernameByEmail("joey");
        Assert.assertThat((Object)user, (Matcher)org.hamcrest.Matchers.equalTo((Object)"joey"));
        Assert.assertThat((Object)noUser, (Matcher)org.hamcrest.Matchers.nullValue());
    }

    private HttpServletRequest mockRequest() {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)"/");
        return req;
    }

    private void createUsers(int userCount) throws Exception {
        for (int i = 0; i < userCount; ++i) {
            this.userManager.addUser("user" + i, "user" + i, "user" + i, "user" + i, true);
        }
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test
    public void testAdminGroupsPreservedOnStart() throws IOException, OperationNotPermittedException, InvalidGroupException {
        ((AdminUserConfig)Mockito.verify((Object)this.mockAdminUserConfig, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testChangePassword() throws Exception {
        FecruUser createdUser = this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "secret", false);
        Assert.assertThat((String)"user created with 'secret' password", (Object)createdUser, (Matcher)new UserMatcher.Builder().withUserName(VALID_USERNAME).build());
        Assert.assertThat((Object)this.isPasswordValidForCrowdUser(VALID_USERNAME, "secret"), (Matcher)org.hamcrest.Matchers.is((Object)true));
        new LoginCookieHelper(VALID_USERNAME).persistRememberMeCookie().preCookUrl();
        Assert.assertThat((String)"2 login cookies should get created", (Object)this.loginCookieDAO.findCookies(createdUser, null, null, null, null), (Matcher)org.hamcrest.Matchers.iterableWithSize((int)2));
        this.userManager.changePassword(VALID_USERNAME, "newSecret");
        FecruUser passChangedUser = this.userDAO.getByUsername(VALID_USERNAME);
        Assert.assertThat((String)"password changed", (Object)passChangedUser, (Matcher)new UserMatcher.Builder().withUserName(VALID_USERNAME).build());
        Assert.assertThat((Object)this.isPasswordValidForCrowdUser(VALID_USERNAME, "newSecret"), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((String)"login cookies deleted by password change", (Object)this.loginCookieDAO.findCookies(createdUser, null, null, null, null), (Matcher)org.hamcrest.Matchers.emptyIterable());
    }

    private boolean isPasswordValidForCrowdUser(String username, String password) {
        try {
            this.crowdService.authenticate(username, password);
            return true;
        }
        catch (FailedAuthenticationException e) {
            return false;
        }
    }

    @Test
    public void testPasswordReset() throws Exception {
        FecruUser createdUser = this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", true);
        Assert.assertThat((String)"user created with 'password' password", (Object)createdUser, (Matcher)new UserMatcher.Builder().withUserName(VALID_USERNAME).build());
        Assert.assertThat((Object)this.isPasswordValidForCrowdUser(VALID_USERNAME, "password"), (Matcher)org.hamcrest.Matchers.is((Object)true));
        new LoginCookieHelper(VALID_USERNAME).persistRememberMeCookie().preCookUrl();
        Assert.assertThat((String)"2 login cookies should get created", (Object)this.loginCookieDAO.findCookies(createdUser, null, null, null, null), (Matcher)org.hamcrest.Matchers.iterableWithSize((int)2));
        long beforePassResetReq = System.currentTimeMillis();
        this.userManager.requestPasswordReset(VALID_USERNAME, "someSRnd");
        FecruUser passResetReqdUser = this.userDAO.getByUsername(VALID_USERNAME);
        Assert.assertThat((Object)passResetReqdUser, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)passResetReqdUser.getPasswordResetSRnd(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"someSRnd"));
        Assert.assertThat((Object)passResetReqdUser.getPasswordResetTimeStamp(), (Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(beforePassResetReq)));
        Assert.assertThat((String)"login cookies don't get deleted by requestPasswordReset", (Object)this.loginCookieDAO.findCookies(createdUser, null, null, null, null), (Matcher)org.hamcrest.Matchers.iterableWithSize((int)2));
        this.userManager.resetPassword(VALID_USERNAME, "newPass");
        FecruUser passResetUser = this.userDAO.getByUsername(VALID_USERNAME);
        Assert.assertThat((Object)passResetUser, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)passResetUser.getFailedLoginAttempts(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0L));
        Assert.assertThat((Object)passResetUser.getPasswordResetSRnd(), (Matcher)org.hamcrest.Matchers.nullValue());
        Assert.assertThat((Object)passResetUser.getPasswordResetTimeStamp(), (Matcher)org.hamcrest.Matchers.equalTo((Object)0L));
        Assert.assertThat((String)"password reset", (Object)passResetUser, (Matcher)new UserMatcher.Builder().withUserName(VALID_USERNAME).build());
        Assert.assertThat((Object)this.isPasswordValidForCrowdUser(VALID_USERNAME, "newPass"), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((String)"login cookies deleted by password reset", (Object)this.loginCookieDAO.findCookies(createdUser, null, null, null, null), (Matcher)org.hamcrest.Matchers.emptyIterable());
    }

    private void testImportOfInvalidUserFails(String userName, String reason) throws Exception {
        Assert.assertThat((String)reason, (Object)this.userManager.importUser((AuthTok)new DummyAuthTok(userName)), (Matcher)org.hamcrest.Matchers.nullValue());
        Assert.assertThat((String)"invalid user was NOT imported", (Object)this.userManager.existsLicensedUser(userName), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.crowdService.getUser(userName), (Matcher)org.hamcrest.Matchers.nullValue());
    }

    private void testImportOfValidUserSucceeds(String userName, String expectedUserName, String reason) throws Exception {
        FecruUser importedUser = this.userManager.importUser((AuthTok)new DummyAuthTok(userName));
        Assert.assertThat((String)reason, (Object)importedUser, (Matcher)new UserMatcher.Builder().withUserName(expectedUserName).build());
        Assert.assertThat((String)"valid user was imported", (Object)this.userManager.existsLicensedUser(expectedUserName), (Matcher)org.hamcrest.Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)importedUser.isCrowdBacked(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)this.groupMembershipManager.getGroupsForUser(expectedUserName), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"crucible-users", "fisheye-users"}));
        User crowdUser = this.crowdService.getUser(expectedUserName);
        Assert.assertThat((Object)crowdUser.getName(), (Matcher)org.hamcrest.Matchers.equalTo((Object)expectedUserName));
    }

    @Test
    public void testImportUser() throws Exception {
        this.testImportOfInvalidUserFails("$admin$", "password authenticated admin special user name disallowed");
        this.testImportOfValidUserSucceeds("validName", "validName", "user of valid name imported");
        this.testImportOfValidUserSucceeds("invalidName$$$", "invalidName$$$", "invalid name still allowed unless it is password authenticated special user name");
        this.testImportOfInvalidUserFails("$ADMin$", "non lowercase password authenticated special user disallowed if system forcing lowercase usernames");
    }

    @Test
    public void testImportUser_importsExistingUserCustom() throws Exception {
        String username = "customtwotimes";
        CustomAuth.CustomAuthTok authTok = new CustomAuth.CustomAuthTok(Long.MAX_VALUE, (AuthToken)new ExampleFishEyeAuthenticator.ExampleAuthToken("customtwotimes"));
        this.userManager.importUser((AuthTok)authTok);
        this.userManager.importUser((AuthTok)authTok);
        List userGroups = this.groupMembershipManager.getGroupsForUser("customtwotimes");
        User crowdUser = this.crowdService.getUser(authTok.getUsername());
        Assert.assertThat((String)"Should exist in cru_user", (Object)this.userDAO.existsAny(authTok.getUsername()), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((String)"Should be added to Crowd, as it is a Custom AuthTok", (Object)crowdUser, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((String)"Should get default groups, as it is a Custom AuthTok", (Object)userGroups, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"fisheye-users", "crucible-users"}));
    }

    @Test
    public void testImportUser_reenablesDeletedUser() throws Exception {
        String user = "user";
        this.userManager.addUser("user", "user", "user", "user", true);
        this.userManager.deleteUser("user", true);
        this.currentSessionProvider.currentSession().flush();
        this.currentSessionProvider.currentSession().clear();
        Optional enabledUserAfterDelete = this.userManager.getEnabledUser("user");
        FecruUser userAfterDelete = this.userManager.getUser("user");
        this.userManager.importUser((AuthTok)new AJPAuth.AjpAuthTok(Long.MAX_VALUE, "user"));
        List userGroups = this.groupMembershipManager.getGroupsForUser("user");
        Assert.assertThat((String)"Should exist in Crowd", (Object)this.crowdService.getUser("user"), (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)enabledUserAfterDelete.isPresent(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
        Assert.assertThat((Object)userAfterDelete.getUsername(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"user"));
        Assert.assertThat((Object)userGroups, (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"fisheye-users", "crucible-users"}));
    }

    @Test
    public void testImportUser_doesntReenableDisabledUser() throws Exception {
        String user = "user";
        this.userManager.addUser("user", "user", "user", "user", false);
        this.crowdService.updateUser(ImmutableUser.newUser().name("user").active(false).toUser());
        this.currentSessionProvider.currentSession().flush();
        this.currentSessionProvider.currentSession().clear();
        this.userManager.importUser((AuthTok)new AJPAuth.AjpAuthTok(Long.MAX_VALUE, "user"));
        FecruUser afterImport = this.userManager.getUser("user");
        List userGroups = this.groupMembershipManager.getGroupsForUser("user");
        Assert.assertThat((String)"Should still be disabled in Crowd", (Object)this.crowdService.getUser("user").isActive(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Assert.assertThat((String)"Should be disabled in FeCru", (Object)afterImport.isEnabled(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Assert.assertThat((String)"Shouldn't be in groups", (Object)userGroups, (Matcher)org.hamcrest.Matchers.empty());
    }

    @Test
    public void testImportUser_handlesUserAlreadyExisting() throws Exception {
        String username = "createdDuringAuth";
        User user = this.crowdService.addUser(ImmutableUser.newUser().name("createdDuringAuth").active(true).toUser(), "foobar");
        this.currentSessionProvider.currentSession().flush();
        this.currentSessionProvider.currentSession().clear();
        FecruUser fecruUser = this.userManager.importUser((AuthTok)new EmbeddedCrowdAuthTok(user, false));
        Assert.assertThat((Object)fecruUser.getId(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.notNullValue()));
        Assert.assertThat((Object)fecruUser.isCrowdBacked(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(UserListChangedEvent.class)));
        Assert.assertThat((String)"Shouldn't get default groups, as it was created during auth", (Object)this.groupMembershipManager.getGroupsForUser("createdDuringAuth"), (Matcher)org.hamcrest.Matchers.emptyIterable());
    }

    @Test
    public void testTryRequestDelegatedLogin() throws Exception {
        CustomAuth.CustomAuthTok tok = new CustomAuth.CustomAuthTok(123456L, (AuthToken)new ExampleFishEyeAuthenticator.ExampleAuthToken("user"));
        Mockito.when((Object)this.mockAuth.getToken((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class))).thenReturn((Object)tok);
        Mockito.when((Object)this.mockAuth.getAutoAdd()).thenReturn((Object)true);
        UserLogin userLogin = this.userManager.tryRequestDelegatedLogin((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)userLogin.getUsername(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"user"));
        Assert.assertThat((Object)userLogin.getAuthTok(), (Matcher)org.hamcrest.Matchers.sameInstance((Object)tok));
    }

    @Test
    public void testTryRequestDelegatedLogin_noAutoAdd() throws Exception {
        CustomAuth.CustomAuthTok tok = new CustomAuth.CustomAuthTok(123456L, (AuthToken)new ExampleFishEyeAuthenticator.ExampleAuthToken("user"));
        Mockito.when((Object)this.mockAuth.getToken((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class))).thenReturn((Object)tok);
        Mockito.when((Object)this.mockAuth.getAutoAdd()).thenReturn((Object)false);
        UserLogin userLogin = this.userManager.tryRequestDelegatedLogin((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)userLogin, (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testTryRequestDelegatedLogin_authFailed() throws Exception {
        Mockito.when((Object)this.mockAuth.getToken((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class))).thenReturn(null);
        UserLogin userLogin = this.userManager.tryRequestDelegatedLogin((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertThat((Object)userLogin, (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void testUpdateUser() throws Exception {
        String username = "john";
        this.userManager.addUser("john", "John Kowalski", "kowalski@john.com", "password", false);
        String newEmail = "notkowalski@john.com";
        String newDisplayname = "John Notkowalski";
        this.userManager.updateUser("john", "John Notkowalski", "notkowalski@john.com");
        User updated = this.crowdService.getUser("john");
        Assert.assertThat((Object)updated.getDisplayName(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"John Notkowalski"));
        Assert.assertThat((Object)updated.getEmailAddress(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"notkowalski@john.com"));
    }

    @Test
    public void testAddUser_shouldLowercaseUsernameInOurTableButKeepCaseInCrowd() throws Exception {
        String username = "LOWERupper";
        String lowerCase = "LOWERupper".toLowerCase();
        FecruUser fecruUser = this.userManager.addUser("LOWERupper", "Just in case ", "foo", "foo", false);
        FecruUser lowerFecruUser = this.userManager.getUser(lowerCase);
        User crowdUser = this.crowdService.getUser("LOWERupper");
        User lowerCrowdUser = this.crowdService.getUser(lowerCase);
        try {
            this.userManager.addUser("LOWERupper", "Another one", "bar", "bar", false);
            Assert.fail((String)"Should fail creating user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((String)"should attach crowd user", (boolean)fecruUser.isCrowdBacked());
        Assert.assertEquals((String)"should return the preserved case name from crowd user", (Object)"LOWERupper", (Object)fecruUser.getUsername());
        Assert.assertEquals((String)"crowd username should preserve case", (Object)"LOWERupper", (Object)crowdUser.getName());
        Assert.assertEquals((String)"fecru user lookup should be case-insensitive", (Object)fecruUser, (Object)lowerFecruUser);
        Assert.assertEquals((String)"crowd user lookup should be case-insensitive", (Object)crowdUser, (Object)lowerCrowdUser);
    }

    @Test
    public void testSearchPagedUsers() throws Exception {
        int userCount = 50;
        this.createUsers(50);
        LinkedHashSet all = new LinkedHashSet();
        PageRequest pageRequest = PageRequest.create((Integer)0, (Integer)1);
        UserSearchCriteria userSearchCriteria = UserSearchCriteria.create().all().withPermissions(GlobalPermissionType.FISHEYE_USER);
        boolean done = false;
        do {
            Page page = this.userManager.searchUsers(userSearchCriteria, pageRequest);
            Iterables.addAll(all, (Iterable)page.getValues());
            if (!page.isLastPage()) {
                pageRequest = page.getNextPageRequest();
                continue;
            }
            done = true;
        } while (!done);
        Assert.assertThat(all, (Matcher)org.hamcrest.Matchers.hasSize((int)50));
    }

    @Test
    public void searchUsersShouldHandleDuplicateUsernames() throws Exception {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        builder.setName("second");
        builder.setActive(true);
        builder.setType(DirectoryType.CUSTOM);
        builder.setImplementationClass(InternalDirectory.class.getName());
        Directory secondDir = this.crowdTestRule.addDirectory(builder.toDirectory());
        this.addUserToDirectory("user0", this.directory);
        this.addUserToDirectory("user1", this.directory);
        this.addUserToDirectory("user0", secondDir);
        this.addUserToDirectory("user2", secondDir);
        Iterable users = this.userManager.searchUsers(UserSearchCriteria.create().named("user"), PageRequest.createDefault()).getValues();
        Assert.assertThat((Object)users, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Matcher[])new Matcher[]{org.hamcrest.Matchers.hasProperty((String)"username", (Matcher)org.hamcrest.Matchers.equalTo((Object)"user0")), org.hamcrest.Matchers.hasProperty((String)"username", (Matcher)org.hamcrest.Matchers.equalTo((Object)"user1")), org.hamcrest.Matchers.hasProperty((String)"username", (Matcher)org.hamcrest.Matchers.equalTo((Object)"user2"))}));
    }

    @Test
    public void testLicensedUserOnCrucibleOnly() throws Exception {
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isCrucibleOnly()).thenReturn((Object)true);
        String feOnlyUser = "feOnlyUser";
        String fecruUser = "fecruUser";
        FecruUser feOnly = this.userManager.addUser("feOnlyUser", "feOnlyUser", "feOnlyUser", "feOnlyUser", false);
        FecruUser fecru = this.userManager.addUser("fecruUser", "fecruUser", "fecruUser", "fecruUser", false);
        this.groupMembershipManager.addUserToGroup("fisheye-users", "feOnlyUser");
        this.groupMembershipManager.addUserToGroup("crucible-users", "fecruUser");
        FecruUser resultFeOnly = this.userManager.getLicensedUser("feOnlyUser");
        FecruUser resultFeOnlyByKey = this.userManager.getLicensedUser(feOnly.getKey().intValue());
        FecruUser resultFeOnlyById = this.userManager.getLicensedUser(feOnly.getId().intValue());
        boolean resultExistFeOnly = this.userManager.existsLicensedUser("feOnlyUser");
        FecruUser resultFecru = this.userManager.getLicensedUser("fecruUser");
        FecruUser resultFecruByKey = this.userManager.getLicensedUser(fecru.getKey().intValue());
        FecruUser resultFecruById = this.userManager.getLicensedUser(fecru.getId().intValue());
        boolean resultExistFecru = this.userManager.existsLicensedUser("fecruUser");
        Assert.assertNull((Object)resultFeOnly);
        Assert.assertNull((Object)resultFeOnlyByKey);
        Assert.assertNull((Object)resultFeOnlyById);
        Assert.assertFalse((boolean)resultExistFeOnly);
        Assert.assertNotNull((Object)resultFecru);
        Assert.assertNotNull((Object)resultFecruByKey);
        Assert.assertNotNull((Object)resultFecruById);
        Assert.assertTrue((boolean)resultExistFecru);
    }

    @Test
    public void testLicensedUserOnFecruOnly() throws Exception {
        Mockito.when((Object)this.rootConfigRule.getRootConfig().isCrucibleOnly()).thenReturn((Object)false);
        String feOnlyUser = "feOnlyUser";
        String fecruUser = "fecruUser";
        FecruUser feOnly = this.userManager.addUser("feOnlyUser", "feOnlyUser", "feOnlyUser", "feOnlyUser", false);
        FecruUser fecru = this.userManager.addUser("fecruUser", "fecruUser", "fecruUser", "fecruUser", false);
        this.groupMembershipManager.addUserToGroup("fisheye-users", "feOnlyUser");
        this.groupMembershipManager.addUserToGroup("crucible-users", "fecruUser");
        FecruUser resultFeOnly = this.userManager.getLicensedUser("feOnlyUser");
        FecruUser resultFeOnlyByKey = this.userManager.getLicensedUser(feOnly.getKey().intValue());
        FecruUser resultFeOnlyById = this.userManager.getLicensedUser(feOnly.getId().intValue());
        boolean resultExistFeOnly = this.userManager.existsLicensedUser("feOnlyUser");
        FecruUser resultFecru = this.userManager.getLicensedUser("fecruUser");
        FecruUser resultFecruByKey = this.userManager.getLicensedUser(fecru.getKey().intValue());
        FecruUser resultFecruById = this.userManager.getLicensedUser(fecru.getId().intValue());
        boolean resultExistFecru = this.userManager.existsLicensedUser("fecruUser");
        Assert.assertNotNull((Object)resultFeOnly);
        Assert.assertNotNull((Object)resultFeOnlyByKey);
        Assert.assertNotNull((Object)resultFeOnlyById);
        Assert.assertTrue((boolean)resultExistFeOnly);
        Assert.assertNotNull((Object)resultFecru);
        Assert.assertNotNull((Object)resultFecruByKey);
        Assert.assertNotNull((Object)resultFecruById);
        Assert.assertTrue((boolean)resultExistFecru);
    }

    @Test
    public void testLogin_shouldFailWhenAuthReturnsNull() throws Exception {
        FecruUser user = this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", true);
        Mockito.when((Object)this.mockAuth.authenticate(Matchers.anyString(), Matchers.anyString(), (HttpServletRequest)Matchers.anyObject(), (HttpServletResponse)Matchers.anyObject())).thenReturn(null);
        long failedLoginAttempts = user.getFailedLoginAttempts();
        UserLogin login = this.userManager.login((HttpServletRequest)new DummyHttpServletRequest(), (HttpServletResponse)new DummyHttpServletResponse(), VALID_USERNAME, "password", false);
        Assert.assertThat((Object)login, (Matcher)org.hamcrest.Matchers.equalTo(null));
        Assert.assertThat((Object)user.getFailedLoginAttempts(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(failedLoginAttempts + 1L)));
    }

    @Test
    public void testLogin_shouldFailWhenAuthThrows() throws Exception {
        FecruUser user = this.userManager.addUser(VALID_USERNAME, VALID_USERNAME, VALID_USERNAME, "password", true);
        Mockito.when((Object)this.mockAuth.authenticate(Matchers.anyString(), Matchers.anyString(), (HttpServletRequest)Matchers.anyObject(), (HttpServletResponse)Matchers.anyObject())).thenThrow(new Throwable[]{new AuthenticationException((Throwable)new RuntimeException())});
        long failedLoginAttempts = user.getFailedLoginAttempts();
        UserLogin login = this.userManager.login((HttpServletRequest)new DummyHttpServletRequest(), (HttpServletResponse)new DummyHttpServletResponse(), "username", "password", false);
        Assert.assertThat((Object)login, (Matcher)org.hamcrest.Matchers.equalTo(null));
        Assert.assertThat((Object)user.getFailedLoginAttempts(), (Matcher)org.hamcrest.Matchers.equalTo((Object)failedLoginAttempts));
    }

    @Test
    public void testLogin_shouldImportUsers() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        CustomAuth.CustomAuthTok tok = new CustomAuth.CustomAuthTok(123L, (AuthToken)new ExampleFishEyeAuthenticator.ExampleAuthToken("username"));
        Mockito.when((Object)this.mockAuth.authenticate("username", "password", (HttpServletRequest)req, (HttpServletResponse)resp)).thenReturn((Object)tok);
        Mockito.when((Object)this.mockAuth.getAutoAdd()).thenReturn((Object)true);
        UserLogin login = this.userManager.login((HttpServletRequest)req, (HttpServletResponse)resp, "username", "password", false);
        Assert.assertThat((Object)login.getUsername(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"username"));
        Assert.assertThat((Object)login.getAuthTok(), (Matcher)org.hamcrest.Matchers.sameInstance((Object)tok));
    }

    @Test
    public void testLogin_shouldntImportDisabledUsers() throws Exception {
        String user = "user";
        this.userManager.addUser("user", "user", "user", "user", false);
        this.crowdService.updateUser(ImmutableUser.newUser().name("user").active(false).toUser());
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        CustomAuth.CustomAuthTok tok = new CustomAuth.CustomAuthTok(123L, (AuthToken)new ExampleFishEyeAuthenticator.ExampleAuthToken("username"));
        Mockito.when((Object)this.mockAuth.authenticate("user", "user", (HttpServletRequest)req, (HttpServletResponse)resp)).thenReturn((Object)tok);
        Mockito.when((Object)this.mockAuth.getAutoAdd()).thenReturn((Object)true);
        UserLogin login = this.userManager.login((HttpServletRequest)req, (HttpServletResponse)resp, "user", "user", false);
        FecruUser dbUser = this.userManager.getUser("user");
        User crowdUser = this.crowdService.getUser("user");
        List userGroups = this.groupMembershipManager.getGroupsForUser("user");
        Assert.assertThat((Object)login, (Matcher)org.hamcrest.Matchers.nullValue());
        Assert.assertThat((Object)dbUser.isEnabled(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Assert.assertThat((Object)crowdUser.isActive(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Assert.assertThat((Object)userGroups, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.empty()));
    }

    private void addUserToDirectory(String username, Directory directory) throws Exception {
        this.directoryManager.addUser(directory.getId().longValue(), new UserTemplate(ImmutableUser.newUser().name(username).directoryId(directory.getId().longValue()).toUser()), PasswordCredential.NONE);
        if (!this.userDAO.existsAny(username)) {
            this.userDAO.create(new FecruUser(username));
        }
    }

    private void assertUserExists(String username) {
        User crowdUser = this.crowdService.getUser(username);
        FecruUser fecruUser = this.userManager.getUser(username);
        Assert.assertThat((Object)crowdUser.getName(), (Matcher)org.hamcrest.Matchers.equalTo((Object)username));
        Assert.assertThat((Object)crowdUser.getDirectoryId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)this.directory.getId()));
        Assert.assertThat((Object)fecruUser.getUsername(), (Matcher)org.hamcrest.Matchers.equalTo((Object)username));
    }

    private class LoginCookieHelper {
        private final String userName;

        LoginCookieHelper(String userName) {
            this.userName = userName;
        }

        LoginCookieHelper persistRememberMeCookie() {
            FecruUser user = DefaultUserManagerIntegrationTest.this.userDAO.getByUsername(this.userName);
            Assert.assertThat((Object)user, (Matcher)org.hamcrest.Matchers.notNullValue());
            DefaultUserManagerIntegrationTest.this.userManager.createRememberMeCookie(user, true);
            return this;
        }

        LoginCookieHelper preCookUrl() {
            HttpServletRequest reqMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            UserLogin ulMock = (UserLogin)Mockito.mock(UserLogin.class);
            Mockito.when((Object)reqMock.getAttribute("feuser")).thenReturn((Object)ulMock);
            Mockito.when((Object)ulMock.getUsername()).thenReturn((Object)this.userName);
            DefaultUserManagerIntegrationTest.this.userManager.preCookUrl(reqMock, "/static", true);
            return this;
        }
    }
}

